/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.impl.jnbt.CompoundTag_v1_8_R3;
import net.aufdemrand.denizen.nms.interfaces.EntityHelper;
import net.aufdemrand.denizen.nms.util.BoundingBox;
import net.aufdemrand.denizen.nms.util.Utilities;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EntityTracker;
import net.minecraft.server.v1_8_R3.EntityTrackerEntry;
import net.minecraft.server.v1_8_R3.EnumDirection;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.MovingObjectPosition;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import net.minecraft.server.v1_8_R3.PathEntity;
import net.minecraft.server.v1_8_R3.Vec3D;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityHelper_v1_8_R3
implements EntityHelper {
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static Map<UUID, Set<UUID>> hiddenEntities = new HashMap<UUID, Set<UUID>>();

    @Override
    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Block.getById((int)location.getBlock().getType().getId()).interact((World)((CraftWorld)location.getWorld()).getHandle(), pos, ((CraftWorld)location.getWorld()).getHandle().getType(pos), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumDirection.NORTH, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public org.bukkit.entity.Entity getEntity(org.bukkit.World world, UUID uuid) {
        Entity entity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public boolean isBreeding(Animals entity) {
        return ((CraftAnimals)entity).getHandle().isInLove();
    }

    @Override
    public void setBreeding(Animals entity, boolean breeding) {
        if (breeding) {
            ((CraftAnimals)entity).getHandle().c((EntityHuman)null);
        } else {
            ((CraftAnimals)entity).getHandle().cs();
        }
    }

    @Override
    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.entity.Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().c(compound);
        return CompoundTag_v1_8_R3.fromNMSTag(compound);
    }

    @Override
    public void setNbtData(org.bukkit.entity.Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().f(((CompoundTag_v1_8_R3)compoundTag).toNMSTag());
    }

    @Override
    public void setSilent(org.bukkit.entity.Entity entity, boolean silent) {
        ((CraftEntity)entity).getHandle().b(silent);
    }

    @Override
    public boolean isSilent(org.bukkit.entity.Entity entity) {
        return ((CraftEntity)entity).getHandle().R();
    }

    @Override
    public ItemStack getItemInHand(LivingEntity entity) {
        return entity.getEquipment().getItemInHand();
    }

    @Override
    public void setItemInHand(LivingEntity entity, ItemStack itemStack) {
        entity.getEquipment().setItemInHand(itemStack);
    }

    @Override
    public ItemStack getItemInOffHand(LivingEntity entity) {
        return new ItemStack(Material.AIR);
    }

    @Override
    public void setItemInOffHand(LivingEntity entity, ItemStack itemStack) {
    }

    @Override
    public void stopFollowing(org.bukkit.entity.Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    @Override
    public void stopWalking(org.bukkit.entity.Entity entity) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().n();
    }

    @Override
    public void toggleAI(org.bukkit.entity.Entity entity, boolean hasAI) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).k(!hasAI);
    }

    @Override
    public boolean isAIDisabled(org.bukkit.entity.Entity entity) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return true;
        }
        return ((EntityInsentient)nmsEntity).ce();
    }

    @Override
    public double getSpeed(org.bukkit.entity.Entity entity) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).b();
    }

    @Override
    public void setSpeed(org.bukkit.entity.Entity entity, double speed) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
    }

    @Override
    public void follow(final org.bukkit.entity.Entity target, final org.bukkit.entity.Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander) {
        if (target == null || follower == null) {
            return;
        }
        Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0f);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation(targetLocation, follower.getLocation(), maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        follower.teleport(Utilities.getWalkableLocationNear(targetLocation, locationNearInt));
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation(targetLocation, follower.getLocation(), lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    @Override
    public void walkTo(final org.bukkit.entity.Entity entity, Location location, double speed, final Runnable callback) {
        PathEntity path;
        if (entity == null || location == null) {
            return;
        }
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        final boolean aiDisabled = this.isAIDisabled(entity);
        if (aiDisabled) {
            this.toggleAI(entity, true);
            nmsEntity.onGround = true;
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ())) != null) {
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).b();
            nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            new BukkitRunnable(){

                public void run() {
                    if (entityNavigation.m() || path.b()) {
                        if (callback != null) {
                            callback.run();
                        }
                        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(oldSpeed);
                        if (aiDisabled) {
                            EntityHelper_v1_8_R3.this.toggleAI(entity, false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    @Override
    public void hideEntity(Player player, org.bukkit.entity.Entity entity, boolean keepInTabList) {
        if (entity instanceof Player) {
            player.hidePlayer((Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        UUID playerUUID = player.getUniqueId();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            UUID entityUUID;
            Set<UUID> hidden;
            if (!hiddenEntities.containsKey(playerUUID)) {
                hiddenEntities.put(playerUUID, new HashSet());
            }
            if (!(hidden = hiddenEntities.get(playerUUID)).contains(entityUUID = entity.getUniqueId())) {
                hidden.add(entityUUID);
                EntityTracker tracker = ((WorldServer)craftPlayer.getHandle().world).tracker;
                Entity other = ((CraftEntity)entity).getHandle();
                EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(other.getId());
                if (entry != null) {
                    entry.clear(entityPlayer);
                }
            }
        }
    }

    @Override
    public void unhideEntity(Player player, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            player.showPlayer((Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        UUID playerUUID = player.getUniqueId();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            Set<UUID> hidden;
            UUID entityUUID = entity.getUniqueId();
            if (hiddenEntities.containsKey(playerUUID) && (hidden = hiddenEntities.get(playerUUID)).contains(entityUUID)) {
                hidden.remove(entityUUID);
            }
            EntityTracker tracker = ((WorldServer)craftPlayer.getHandle().world).tracker;
            Entity other = ((CraftEntity)entity).getHandle();
            EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    @Override
    public boolean isHidden(Player player, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            return !player.canSee((Player)entity);
        }
        UUID uuid = player.getUniqueId();
        Set<UUID> hiding = hiddenEntities.get(uuid);
        return hiding != null && hiding.contains(entity.getUniqueId());
    }

    @Override
    public void rotate(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = this.normalizeYaw(yaw - 180.0f);
            }
            this.look(entity, yaw, pitch);
        } else {
            Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    @Override
    public float getBaseYaw(org.bukkit.entity.Entity entity) {
        Entity handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aK;
    }

    @Override
    public void look(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.yaw = yaw;
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aK = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.aI = yaw;
                }
                livingHandle.aL = yaw;
            }
            handle.pitch = pitch;
        }
    }

    private static MovingObjectPosition rayTrace(org.bukkit.World world, Vector start, Vector end) {
        return ((CraftWorld)world).getHandle().rayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()));
    }

    @Override
    public boolean canTrace(org.bukkit.World world, Vector start, Vector end) {
        return EntityHelper_v1_8_R3.rayTrace(world, start, end) == null;
    }

    @Override
    public EntityHelper.MapTraceResult mapTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        Vector startVec = start.toVector();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        Vector endVec = startVec.clone().add(new Vector(nx, -ny, nz).multiply(range));
        MovingObjectPosition l = EntityHelper_v1_8_R3.rayTrace(start.getWorld(), startVec, endVec);
        if (l == null || l.pos == null) {
            return null;
        }
        Vector finalVec = new Vector(l.pos.a, l.pos.b, l.pos.c);
        EntityHelper.MapTraceResult mtr = new EntityHelper.MapTraceResult();
        switch (l.direction) {
            case NORTH: {
                mtr.angle = BlockFace.NORTH;
                break;
            }
            case SOUTH: {
                mtr.angle = BlockFace.SOUTH;
                break;
            }
            case EAST: {
                mtr.angle = BlockFace.EAST;
                break;
            }
            case WEST: {
                mtr.angle = BlockFace.WEST;
            }
        }
        Vector hit = finalVec.clone().subtract(endVec.clone().subtract(startVec).normalize().multiply(0.072));
        mtr.hitLocation = new Location(start.getWorld(), hit.getX(), hit.getY(), hit.getZ());
        return mtr;
    }

    @Override
    public Location rayTrace(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelper_v1_8_R3.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.pos != null) {
            return new Location(start.getWorld(), l.pos.a, l.pos.b, l.pos.c);
        }
        return null;
    }

    @Override
    public Location getImpactNormal(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelper_v1_8_R3.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.direction != null) {
            return new Location(start.getWorld(), (double)l.direction.getAdjacentX(), (double)l.direction.getAdjacentY(), (double)l.direction.getAdjacentZ());
        }
        return null;
    }

    @Override
    public Location eyeTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        return this.rayTrace(start, new Vector(nx, -ny, nz), range);
    }

    @Override
    public Location faceLocation(Location from, Location at) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        Location newLocation = from.clone();
        newLocation.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(direction.getX(), direction.getZ())));
        newLocation.setPitch(90.0f - (float)Math.toDegrees(Math.acos(direction.getY())));
        return newLocation;
    }

    @Override
    public void faceLocation(org.bukkit.entity.Entity from, Location at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location origin = from instanceof LivingEntity ? ((LivingEntity)from).getEyeLocation() : from.getLocation().getBlock().getLocation().add(0.5, 0.5, 0.5);
        Location rotated = this.faceLocation(origin, at);
        this.rotate(from, rotated.getYaw(), rotated.getPitch());
    }

    @Override
    public void faceEntity(org.bukkit.entity.Entity entity, org.bukkit.entity.Entity target) {
        this.faceLocation(entity, target.getLocation());
    }

    @Override
    public boolean isFacingLocation(Location from, Location at, float degreeLimit) {
        double currentYaw = this.normalizeYaw(from.getYaw());
        double requiredYaw = this.normalizeYaw(this.getYaw(at.toVector().subtract(from.toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    @Override
    public boolean isFacingLocation(org.bukkit.entity.Entity from, Location at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at, degreeLimit);
    }

    @Override
    public boolean isFacingEntity(org.bukkit.entity.Entity from, org.bukkit.entity.Entity at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at.getLocation(), degreeLimit);
    }

    @Override
    public float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = (float)((double)yaw + 360.0);
        }
        return yaw;
    }

    @Override
    public float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    @Override
    public String getCardinal(float yaw) {
        if (0.0f <= (yaw = this.normalizeYaw(yaw)) && (double)yaw < 22.5) {
            return "south";
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return "southwest";
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return "west";
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return "northwest";
        }
        if (157.5 <= (double)yaw && (double)yaw < 202.5) {
            return "north";
        }
        if (202.5 <= (double)yaw && (double)yaw < 247.5) {
            return "northeast";
        }
        if (247.5 <= (double)yaw && (double)yaw < 292.5) {
            return "east";
        }
        if (292.5 <= (double)yaw && (double)yaw < 337.5) {
            return "southeast";
        }
        if (337.5 <= (double)yaw && (double)yaw < 360.0) {
            return "south";
        }
        return null;
    }

    @Override
    public void move(org.bukkit.entity.Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public BoundingBox getBoundingBox(org.bukkit.entity.Entity entity) {
        AxisAlignedBB boundingBox = ((CraftEntity)entity).getHandle().getBoundingBox();
        Vector position = new Vector(boundingBox.a, boundingBox.b, boundingBox.c);
        Vector size = new Vector(boundingBox.d, boundingBox.e, boundingBox.f);
        return new BoundingBox(position, size);
    }

    @Override
    public void setBoundingBox(org.bukkit.entity.Entity entity, BoundingBox boundingBox) {
        Vector low = boundingBox.getLow();
        Vector high = boundingBox.getHigh();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(low.getX(), low.getY(), low.getZ(), high.getX(), high.getY(), high.getZ()));
    }

    @Override
    public boolean isChestedHorse(org.bukkit.entity.Entity horse) {
        return horse instanceof Horse;
    }

    @Override
    public boolean isCarryingChest(org.bukkit.entity.Entity horse) {
        return horse instanceof Horse && ((Horse)horse).isCarryingChest();
    }

    @Override
    public void setCarryingChest(org.bukkit.entity.Entity horse, boolean carrying) {
        if (horse instanceof Horse) {
            ((Horse)horse).setCarryingChest(carrying);
        }
    }
}

