/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.nms.interfaces.BlockHelper;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;

public class dCuboid
implements dObject,
Cloneable,
Notable,
Adjustable {
    static final Pattern cuboid_by_saved = Pattern.compile("(cu@)?(.+)");
    static final Pattern cuboidLocations = Pattern.compile("(\\|?([-\\d\\.]+,){3}[\\w\\s]+\\|([-\\d\\.]+,){3}[\\w\\s]+)+", 2);
    public List<LocationPair> pairs = new ArrayList<LocationPair>();
    ArrayList<dObject> filter = new ArrayList();
    String prefix = "Cuboid";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public dCuboid clone() throws CloneNotSupportedException {
        return (dCuboid)super.clone();
    }

    public static List<dCuboid> getNotableCuboidsContaining(Location location) {
        ArrayList<dCuboid> cuboids = new ArrayList<dCuboid>();
        for (dCuboid cuboid : NotableManager.getAllType(dCuboid.class)) {
            if (!cuboid.isInsideCuboid(location)) continue;
            cuboids.add(cuboid);
        }
        return cuboids;
    }

    public static dCuboid valueOf(String string) {
        return dCuboid.valueOf(string, null);
    }

    @Fetchable(value="cu")
    public static dCuboid valueOf(String string, TagContext context) {
        Matcher m;
        if (string == null) {
            return null;
        }
        dList positions = dList.valueOf(string.replace("cu@", ""));
        if (positions.size() > 1 && dLocation.matches((String)positions.get(0)) && dLocation.matches((String)positions.get(1))) {
            if (positions.size() % 2 != 0) {
                if (context == null || context.debug) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("valueOf dCuboid returning null (Uneven number of locations): '" + string + "'.");
                }
                return null;
            }
            dCuboid toReturn = new dCuboid();
            for (int i = 0; i < positions.size(); i += 2) {
                dLocation pos_1 = dLocation.valueOf((String)positions.get(i));
                dLocation pos_2 = dLocation.valueOf((String)positions.get(i + 1));
                if (pos_1 == null || pos_2 == null) {
                    if (context == null || context.debug) {
                        net.aufdemrand.denizen.utilities.debugging.dB.echoError("valueOf in dCuboid returning null (null locations): '" + string + "'.");
                    }
                    return null;
                }
                if (pos_1.getWorld() == null || pos_2.getWorld() == null) {
                    if (context == null || context.debug) {
                        net.aufdemrand.denizen.utilities.debugging.dB.echoError("valueOf in dCuboid returning null (null worlds): '" + string + "'.");
                    }
                    return null;
                }
                toReturn.addPair(pos_1, pos_2);
            }
            if (toReturn.pairs.size() > 0) {
                return toReturn;
            }
        }
        if ((m = cuboid_by_saved.matcher(string)).matches() && NotableManager.isType(m.group(2), dCuboid.class)) {
            return (dCuboid)NotableManager.getSavedObject(m.group(2));
        }
        if (context == null || context.debug) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("valueOf dCuboid returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("cu@")) {
            return true;
        }
        Matcher m = cuboid_by_saved.matcher(string);
        if (m.matches() && NotableManager.isType(m.group(2), dCuboid.class)) {
            return true;
        }
        m = cuboidLocations.matcher(string.replace("cu@", ""));
        return m.matches();
    }

    public dCuboid() {
    }

    public dCuboid(Location point_1, Location point_2) {
        this.addPair(point_1, point_2);
    }

    public void addPair(Location point_1, Location point_2) {
        if (point_1.getWorld() != point_2.getWorld()) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Tried to make cross-world cuboid!");
            return;
        }
        if (this.pairs.size() > 0 && point_1.getWorld() != this.getWorld()) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Tried to make cross-world cuboid set!");
            return;
        }
        LocationPair pair = new LocationPair(new dLocation(point_1), new dLocation(point_2));
        this.pairs.add(pair);
    }

    public boolean isInsideCuboid(Location location) {
        for (LocationPair pair : this.pairs) {
            if (!location.getWorld().equals(pair.low.getWorld()) || !Utilities.isBetween(pair.low.getBlockX(), pair.high.getBlockX() + 1, location.getBlockX()) || !Utilities.isBetween(pair.low.getBlockY(), pair.high.getBlockY() + 1, location.getBlockY()) || !Utilities.isBetween(pair.low.getBlockZ(), pair.high.getBlockZ() + 1, location.getBlockZ())) continue;
            return true;
        }
        return false;
    }

    public dCuboid addBlocksToFilter(List<dMaterial> addl) {
        this.filter.addAll(addl);
        return this;
    }

    public dCuboid removeBlocksFromFilter(List<dMaterial> addl) {
        this.filter.removeAll(addl);
        return this;
    }

    public dCuboid removeFilter() {
        this.filter.clear();
        return this;
    }

    public dCuboid setAsFilter(List<dMaterial> list) {
        this.filter.clear();
        this.filter.addAll(list);
        return this;
    }

    public dList getOutline() {
        int max = Settings.blockTagsMaxBlocks();
        int index = 0;
        dList list = new dList();
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            dLocation loc_2 = pair.high;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int y = loc_1.getBlockY(); y < loc_1.getBlockY() + y_distance; ++y) {
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), y, loc_1.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), y, loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), y, loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), y, loc_1.getBlockZ()).identify());
                if (++index <= max) continue;
                return list;
            }
            for (int x = loc_1.getBlockX(); x < loc_1.getBlockX() + x_distance; ++x) {
                list.add(new dLocation(loc_1.getWorld(), x, loc_1.getBlockY(), loc_1.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), x, loc_1.getBlockY(), loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), x, loc_2.getBlockY(), loc_2.getBlockZ()).identify());
                list.add(new dLocation(loc_1.getWorld(), x, loc_2.getBlockY(), loc_1.getBlockZ()).identify());
                if (++index <= max) continue;
                return list;
            }
            for (int z = loc_1.getBlockZ(); z < loc_1.getBlockZ() + z_distance; ++z) {
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), loc_1.getBlockY(), z).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), loc_2.getBlockY(), z).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_1.getBlockX(), loc_2.getBlockY(), z).identify());
                list.add(new dLocation(loc_1.getWorld(), loc_2.getBlockX(), loc_1.getBlockY(), z).identify());
                if (++index <= max) continue;
                return list;
            }
            list.add(pair.high.identify());
        }
        return list;
    }

    public dList getBlocks() {
        return this.getBlocks(null);
    }

    private boolean matchesMaterialList(Location loc, List<dMaterial> materials) {
        if (materials == null) {
            return true;
        }
        dMaterial mat = dMaterial.getMaterialFrom(loc.getBlock().getType(), loc.getBlock().getData());
        for (dMaterial material : materials) {
            if (!mat.equals(material) && (mat.getMaterial() != material.getMaterial() || material.getData() != null && material.getData() != 0)) continue;
            return true;
        }
        return false;
    }

    public dList getBlocks(List<dMaterial> materials) {
        List<dLocation> locs = this.getBlocks_internal(materials);
        dList list = new dList();
        for (dLocation loc : locs) {
            list.add(loc.identify());
        }
        return list;
    }

    public List<dLocation> getBlocks_internal(List<dMaterial> materials) {
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<dLocation> list = new ArrayList<dLocation>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        dLocation loc = new dLocation(loc_1.clone().add((double)x, (double)y, (double)z));
                        if (loc.getY() < 0.0 || loc.getY() > 255.0) continue;
                        if (!this.filter.isEmpty()) {
                            for (dObject material : this.filter) {
                                if (!((dMaterial)material).matchesMaterialData(new MaterialData(loc.getBlock().getType(), loc.getBlock().getData())) || !this.matchesMaterialList(loc, materials)) continue;
                                list.add(loc);
                            }
                        } else if (this.matchesMaterialList(loc, materials)) {
                            list.add(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public void setBlocks_internal(List<BlockData> materials) {
        int index = 0;
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        if (loc_1.getY() + (double)y >= 0.0 && loc_1.getY() + (double)y < 256.0) {
                            materials.get(index).setBlock(loc_1.clone().add((double)x, (double)y, (double)z).getBlock());
                        }
                        ++index;
                    }
                }
            }
        }
    }

    public BlockData getBlockAt(double nX, double nY, double nZ, List<BlockData> materials) {
        int index = 0;
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        if ((double)x == nX && nY == (double)y && (double)z == nZ) {
                            return materials.get(index);
                        }
                        ++index;
                    }
                }
            }
        }
        return null;
    }

    public List<dLocation> getBlockLocations() {
        int max = Settings.blockTagsMaxBlocks();
        ArrayList<dLocation> list = new ArrayList<dLocation>();
        int index = 0;
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int z = 0; z != z_distance + 1; ++z) {
                    for (int y = 0; y != y_distance + 1; ++y) {
                        dLocation loc = new dLocation(loc_1.clone().add((double)x, (double)y, (double)z));
                        if (!this.filter.isEmpty()) {
                            for (dObject material : this.filter) {
                                if (!loc.getBlock().getType().name().equalsIgnoreCase(((dMaterial)material).getMaterial().name())) continue;
                                list.add(loc);
                            }
                        } else {
                            list.add(loc);
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public dList getSpawnableBlocks() {
        return this.getSpawnableBlocks(null);
    }

    public dList getSpawnableBlocks(List<dMaterial> mats) {
        int max = Settings.blockTagsMaxBlocks();
        dList list = new dList();
        int index = 0;
        BlockHelper blockHelper = NMSHandler.getInstance().getBlockHelper();
        for (LocationPair pair : this.pairs) {
            dLocation loc_1 = pair.low;
            int y_distance = pair.y_distance;
            int z_distance = pair.z_distance;
            int x_distance = pair.x_distance;
            for (int x = 0; x != x_distance + 1; ++x) {
                for (int y = 0; y != y_distance + 1; ++y) {
                    for (int z = 0; z != z_distance + 1; ++z) {
                        dLocation loc = new dLocation(loc_1.clone().add((double)x, (double)y, (double)z));
                        if (blockHelper.isSafeBlock(loc.getBlock().getType()) && blockHelper.isSafeBlock(loc.clone().add(0.0, 1.0, 0.0).getBlock().getType()) && loc.clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid() && this.matchesMaterialList(loc.clone().add(0.0, -1.0, 0.0), mats)) {
                            loc.add(0.5, 0.0, 0.5);
                            list.add(loc.identify());
                        }
                        if (++index <= max) continue;
                        return list;
                    }
                }
            }
        }
        return list;
    }

    public World getWorld() {
        if (this.pairs.size() == 0) {
            return null;
        }
        return this.pairs.get((int)0).high.getWorld();
    }

    public dLocation getHigh(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).high;
    }

    public dLocation getLow(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.pairs.size()) {
            return null;
        }
        return this.pairs.get((int)index).low;
    }

    @Override
    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Override
    @Note(value="Cuboids")
    public String getSaveObject() {
        return this.identifyFull().substring(3);
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "cuboid";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dCuboid setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.isUnique() ? "<G>" + this.prefix + "='<A>" + NotableManager.getSavedId(this) + "(<Y>" + this.identify() + "<A>)<G>'  " : "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        StringBuilder sb = new StringBuilder();
        sb.append("cu@");
        for (LocationPair pair : this.pairs) {
            if (pair.low.getWorld() == null || pair.high.getWorld() == null) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("Null world for cuboid, returning invalid identity!");
                return "cu@null";
            }
            sb.append(pair.low.getBlockX()).append(',').append(pair.low.getBlockY()).append(',').append(pair.low.getBlockZ()).append(',').append(pair.low.getWorld().getName()).append('|').append(pair.high.getBlockX()).append(',').append(pair.high.getBlockY()).append(',').append(pair.high.getBlockZ()).append(',').append(pair.high.getWorld().getName()).append('|');
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        dCuboid.registerTag("blocks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (attribute.hasContext(1)) {
                    return new dList(((dCuboid)object).getBlocks(dList.valueOf(attribute.getContext(1)).filter(dMaterial.class))).getAttribute(attribute.fulfill(1));
                }
                return new dList(((dCuboid)object).getBlocks()).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("get_blocks", registeredTags.get("blocks"));
        dCuboid.registerTag("members_size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dCuboid)object).pairs.size()).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("member", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > ((dCuboid)object).pairs.size()) {
                    member = ((dCuboid)object).pairs.size();
                }
                return new dCuboid(((dCuboid)object).pairs.get((int)(member - 1)).low, ((dCuboid)object).pairs.get((int)(member - 1)).high).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("get_member", registeredTags.get("member"));
        dCuboid.registerTag("spawnable_blocks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (attribute.hasContext(1)) {
                    return new dList(((dCuboid)object).getSpawnableBlocks(dList.valueOf(attribute.getContext(1)).filter(dMaterial.class))).getAttribute(attribute.fulfill(1));
                }
                return new dList(((dCuboid)object).getSpawnableBlocks()).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("get_spawnable_blocks", registeredTags.get("spawnable_blocks"));
        dCuboid.registerTag("outline", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new dList(((dCuboid)object).getOutline()).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("get_outline", registeredTags.get("outline"));
        dCuboid.registerTag("filter", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new dList((Collection<? extends dObject>)((dCuboid)object).filter).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("intersects", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag cu@cuboid.intersects[...] must have a value.");
                    return null;
                }
                dCuboid cub2 = dCuboid.valueOf(attribute.getContext(1));
                if (cub2 != null) {
                    boolean intersects = false;
                    block0: for (LocationPair pair : ((dCuboid)object).pairs) {
                        for (LocationPair pair2 : cub2.pairs) {
                            if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                                return new Element("false").getAttribute(attribute.fulfill(1));
                            }
                            if (!(pair2.low.getX() <= pair.high.getX()) || !(pair2.low.getY() <= pair.high.getY()) || !(pair2.low.getZ() <= pair.high.getZ()) || !(pair2.high.getX() >= pair.low.getX()) || !(pair2.high.getY() >= pair.low.getY()) || !(pair2.high.getZ() >= pair.low.getZ())) continue;
                            intersects = true;
                            break block0;
                        }
                    }
                    return new Element(intersects).getAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        dCuboid.registerTag("contains_location", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag cu@cuboid.contains_location[...] must have a value.");
                    return null;
                }
                dLocation loc = dLocation.valueOf(attribute.getContext(1));
                return new Element(((dCuboid)object).isInsideCuboid(loc)).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("is_within", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag cu@cuboid.is_within[...] must have a value.");
                    return null;
                }
                dCuboid cub2 = dCuboid.valueOf(attribute.getContext(1));
                if (cub2 != null) {
                    boolean contains = true;
                    for (LocationPair pair2 : ((dCuboid)object).pairs) {
                        boolean contained = false;
                        for (LocationPair pair : cub2.pairs) {
                            if (!pair.low.getWorld().getName().equalsIgnoreCase(pair2.low.getWorld().getName())) {
                                if (dB.verbose) {
                                    net.aufdemrand.denizen.utilities.debugging.dB.log("Worlds don't match!");
                                }
                                return new Element("false").getAttribute(attribute.fulfill(1));
                            }
                            if (!(pair2.low.getX() >= pair.low.getX()) || !(pair2.low.getY() >= pair.low.getY()) || !(pair2.low.getZ() >= pair.low.getZ()) || !(pair2.high.getX() <= pair.high.getX()) || !(pair2.high.getY() <= pair.high.getY()) || !(pair2.high.getZ() <= pair.high.getZ())) continue;
                            contained = true;
                            break;
                        }
                        if (contained) continue;
                        contains = false;
                        break;
                    }
                    return new Element(contains).getAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        dCuboid.registerTag("center", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                LocationPair pair;
                if (!attribute.hasContext(1)) {
                    pair = ((dCuboid)object).pairs.get(0);
                } else {
                    int member = attribute.getIntContext(1);
                    if (member < 1) {
                        member = 1;
                    }
                    if (member > ((dCuboid)object).pairs.size()) {
                        member = ((dCuboid)object).pairs.size();
                    }
                    pair = ((dCuboid)object).pairs.get(member - 1);
                }
                Location base = pair.high.clone().add(pair.low.clone()).add(1.0, 1.0, 1.0);
                base.setX(base.getX() / 2.0);
                base.setY(base.getY() / 2.0);
                base.setZ(base.getZ() / 2.0);
                return new dLocation(base).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                LocationPair pair;
                if (!attribute.hasContext(1)) {
                    pair = ((dCuboid)object).pairs.get(0);
                } else {
                    int member = attribute.getIntContext(1);
                    if (member < 1) {
                        member = 1;
                    }
                    if (member > ((dCuboid)object).pairs.size()) {
                        member = ((dCuboid)object).pairs.size();
                    }
                    pair = ((dCuboid)object).pairs.get(member - 1);
                }
                Location base = pair.high.clone().subtract(pair.low.clone()).add(1.0, 1.0, 1.0);
                return new dLocation(base).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("max", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    return ((dCuboid)object).pairs.get((int)0).high.getAttribute(attribute.fulfill(1));
                }
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > ((dCuboid)object).pairs.size()) {
                    member = ((dCuboid)object).pairs.size();
                }
                return ((dCuboid)object).pairs.get((int)(member - 1)).high.getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("min", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    return ((dCuboid)object).pairs.get((int)0).low.getAttribute(attribute.fulfill(1));
                }
                int member = attribute.getIntContext(1);
                if (member < 1) {
                    member = 1;
                }
                if (member > ((dCuboid)object).pairs.size()) {
                    member = ((dCuboid)object).pairs.size();
                }
                return ((dCuboid)object).pairs.get((int)(member - 1)).low.getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("include", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("The tag cu@cuboid.include[...] must have a value.");
                    return null;
                }
                try {
                    dLocation loc = dLocation.valueOf(attribute.getContext(1));
                    dCuboid cuboid = ((dCuboid)object).clone();
                    if (loc != null) {
                        if (loc.getX() < cuboid.pairs.get((int)0).low.getX()) {
                            cuboid.pairs.get((int)0).low = new dLocation(cuboid.pairs.get((int)0).low.getWorld(), loc.getX(), cuboid.pairs.get((int)0).low.getY(), cuboid.pairs.get((int)0).low.getZ());
                        }
                        if (loc.getY() < cuboid.pairs.get((int)0).low.getY()) {
                            cuboid.pairs.get((int)0).low = new dLocation(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), loc.getY(), cuboid.pairs.get((int)0).low.getZ());
                        }
                        if (loc.getZ() < cuboid.pairs.get((int)0).low.getZ()) {
                            cuboid.pairs.get((int)0).low = new dLocation(cuboid.pairs.get((int)0).low.getWorld(), cuboid.pairs.get((int)0).low.getX(), cuboid.pairs.get((int)0).low.getY(), loc.getZ());
                        }
                        if (loc.getX() > cuboid.pairs.get((int)0).high.getX()) {
                            cuboid.pairs.get((int)0).high = new dLocation(cuboid.pairs.get((int)0).high.getWorld(), loc.getX(), cuboid.pairs.get((int)0).high.getY(), cuboid.pairs.get((int)0).high.getZ());
                        }
                        if (loc.getY() > cuboid.pairs.get((int)0).high.getY()) {
                            cuboid.pairs.get((int)0).high = new dLocation(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), loc.getY(), cuboid.pairs.get((int)0).high.getZ());
                        }
                        if (loc.getZ() > cuboid.pairs.get((int)0).high.getZ()) {
                            cuboid.pairs.get((int)0).high = new dLocation(cuboid.pairs.get((int)0).high.getWorld(), cuboid.pairs.get((int)0).high.getX(), cuboid.pairs.get((int)0).high.getY(), loc.getZ());
                        }
                        return cuboid.getAttribute(attribute.fulfill(1));
                    }
                }
                catch (CloneNotSupportedException ex) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError(ex);
                }
                return null;
            }
        });
        dCuboid.registerTag("list_players", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dPlayer> players = new ArrayList<dPlayer>();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((dCuboid)object).isInsideCuboid(player.getLocation())) continue;
                    players.add(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player));
                }
                return new dList((Collection<? extends dObject>)players).getAttribute(attribute.fulfill(1));
            }
        });
        if (Depends.citizens != null) {
            dCuboid.registerTag("list_npcs", new TagRunnable(){

                @Override
                public String run(Attribute attribute, dObject object) {
                    ArrayList<dNPC> npcs = new ArrayList<dNPC>();
                    for (NPC npc : CitizensAPI.getNPCRegistry()) {
                        dNPC dnpc = dNPC.mirrorCitizensNPC(npc);
                        if (!((dCuboid)object).isInsideCuboid(dnpc.getLocation())) continue;
                        npcs.add(dnpc);
                    }
                    return new dList((Collection<? extends dObject>)npcs).getAttribute(attribute.fulfill(1));
                }
            });
        }
        dCuboid.registerTag("list_entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dEntity> entities = new ArrayList<dEntity>();
                dList types = new dList();
                if (attribute.hasContext(1)) {
                    types = dList.valueOf(attribute.getContext(1));
                }
                block0: for (Entity ent : ((dCuboid)object).getWorld().getEntities()) {
                    dEntity current = new dEntity(ent);
                    if (!ent.isValid() || !((dCuboid)object).isInsideCuboid(ent.getLocation())) continue;
                    if (!types.isEmpty()) {
                        for (String type : types) {
                            if (!current.identifySimpleType().equalsIgnoreCase(type)) continue;
                            entities.add(current);
                            continue block0;
                        }
                        continue;
                    }
                    entities.add(new dEntity(ent));
                }
                return new dList((Collection<? extends dObject>)entities).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("list_living_entities", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                ArrayList<dEntity> entities = new ArrayList<dEntity>();
                for (Entity ent : ((dCuboid)object).getWorld().getLivingEntities()) {
                    if (!ent.isValid() || !((dCuboid)object).isInsideCuboid(ent.getLocation()) || dEntity.isCitizensNPC(ent)) continue;
                    entities.add(new dEntity(ent));
                }
                return new dList((Collection<? extends dObject>)entities).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("list_chunks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                HashSet<Chunk> chunks = new HashSet<Chunk>();
                dCuboid obj = (dCuboid)object;
                for (LocationPair pair : obj.pairs) {
                    int minY = pair.low.getBlockY();
                    Chunk minChunk = pair.low.getChunk();
                    if (obj.isInsideCuboid(new Location(obj.getWorld(), (double)(minChunk.getX() * 16), (double)minY, (double)(minChunk.getZ() * 16)))) {
                        chunks.add(minChunk);
                    }
                    Chunk maxChunk = pair.high.getChunk();
                    if (obj.isInsideCuboid(new Location(obj.getWorld(), (double)(maxChunk.getX() * 16 + 15), (double)minY, (double)(maxChunk.getZ() * 16 + 15)))) {
                        chunks.add(maxChunk);
                    }
                    for (int x = minChunk.getX() + 1; x <= maxChunk.getX() - 1; ++x) {
                        for (int z = minChunk.getZ() + 1; z <= maxChunk.getZ() - 1; ++z) {
                            chunks.add(obj.getWorld().getChunkAt(x, z));
                        }
                    }
                }
                dList list = new dList();
                for (Chunk chunk : chunks) {
                    list.add(new dChunk(chunk).identify());
                }
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("list_partial_chunks", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                HashSet<Chunk> chunks = new HashSet<Chunk>();
                for (LocationPair pair : ((dCuboid)object).pairs) {
                    Chunk minChunk = pair.low.getChunk();
                    Chunk maxChunk = pair.high.getChunk();
                    for (int x = minChunk.getX(); x <= maxChunk.getX(); ++x) {
                        for (int z = minChunk.getZ(); z <= maxChunk.getZ(); ++z) {
                            chunks.add(((dCuboid)object).getWorld().getChunkAt(x, z));
                        }
                    }
                }
                dList list = new dList();
                for (Chunk chunk : chunks) {
                    list.add(new dChunk(chunk).identify());
                }
                return list.getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("notable_name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                String notname = NotableManager.getSavedId((dCuboid)object);
                if (notname == null) {
                    return null;
                }
                return new Element(notname).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("full", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dCuboid)object).identifyFull()).getAttribute(attribute.fulfill(1));
            }
        });
        dCuboid.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Cuboid").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Element value = mechanism.getValue();
        if (mechanism.matches("outset")) {
            int mod = 1;
            if (value != null && mechanism.requireInteger("Invalid integer specified. Assuming '1'.")) {
                mod = value.asInt();
            }
            for (LocationPair pair : this.pairs) {
                pair.low.add(-1 * mod, -1 * mod, -1 * mod);
                pair.high.add(mod, mod, mod);
                pair.generateDistances();
            }
            return;
        }
        if (mechanism.matches("expand")) {
            int mod = 1;
            if (value != null && mechanism.requireInteger("Invalid integer specified. Assuming '1'.")) {
                mod = value.asInt();
            }
            for (LocationPair pair : this.pairs) {
                pair.low.add(-1 * mod, -1 * mod, -1 * mod);
                pair.high.add(mod, mod, mod);
                pair.generateDistances();
            }
            return;
        }
        if (mechanism.matches("set_location")) {
            int mod = 1;
            if (value != null && mechanism.requireInteger("Invalid integer specified. Assuming '1'.")) {
                mod = value.asInt();
            }
            for (LocationPair pair : this.pairs) {
                pair.low.add(-1 * mod, -1 * mod, -1 * mod);
                pair.high.add(mod, mod, mod);
                pair.generateDistances();
            }
            return;
        }
        for (Property property : PropertyParser.getProperties(this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }

    public static class LocationPair {
        public dLocation low;
        public dLocation high;
        dLocation point_1;
        dLocation point_2;
        int x_distance;
        int y_distance;
        int z_distance;

        public LocationPair(dLocation point_1, dLocation point_2) {
            this.point_1 = point_1;
            this.point_2 = point_2;
            this.regenerate();
        }

        public void changePoint(int number, dLocation point) {
            if (number == 1) {
                this.point_1 = point;
            } else if (number == 2) {
                this.point_2 = point;
            }
            this.regenerate();
        }

        public void regenerate() {
            World world = this.point_1.getWorld();
            int x_high = this.point_1.getBlockX() >= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int x_low = this.point_1.getBlockX() <= this.point_2.getBlockX() ? this.point_1.getBlockX() : this.point_2.getBlockX();
            int y_high = this.point_1.getBlockY() >= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int y_low = this.point_1.getBlockY() <= this.point_2.getBlockY() ? this.point_1.getBlockY() : this.point_2.getBlockY();
            int z_high = this.point_1.getBlockZ() >= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            int z_low = this.point_1.getBlockZ() <= this.point_2.getBlockZ() ? this.point_1.getBlockZ() : this.point_2.getBlockZ();
            this.low = new dLocation(world, x_low, y_low, z_low);
            this.high = new dLocation(world, x_high, y_high, z_high);
            this.generateDistances();
        }

        public void generateDistances() {
            this.x_distance = this.high.getBlockX() - this.low.getBlockX();
            this.y_distance = this.high.getBlockY() - this.low.getBlockY();
            this.z_distance = this.high.getBlockZ() - this.low.getBlockZ();
        }
    }
}

