/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;

public class ItemSpawnEgg
implements Property {
    dItem item;

    public static boolean describes(dObject item) {
        if (!NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
            return false;
        }
        return item instanceof dItem && ((dItem)item).getItemStack().getItemMeta() instanceof SpawnEggMeta;
    }

    public static ItemSpawnEgg getFrom(dObject _item) {
        if (!ItemSpawnEgg.describes(_item)) {
            return null;
        }
        return new ItemSpawnEgg((dItem)_item);
    }

    private ItemSpawnEgg(dItem _item) {
        this.item = _item;
    }

    private EntityType getEntityType() {
        return ((SpawnEggMeta)this.item.getItemStack().getItemMeta()).getSpawnedType();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if ((attribute.startsWith("spawn_id") || attribute.startsWith("spawn_egg_entity")) && this.getEntityType() != null) {
            return new Element(this.getEntityType().getTypeId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("spawn_type") && this.getEntityType() != null) {
            return new Element(this.getEntityType().name()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        return this.getEntityType() != null ? this.getEntityType().name() : null;
    }

    @Override
    public String getPropertyId() {
        return "spawn_type";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        SpawnEggMeta sem;
        if ((mechanism.matches("spawn_id") || mechanism.matches("spawn_egg")) && mechanism.requireInteger()) {
            sem = (SpawnEggMeta)this.item.getItemStack().getItemMeta();
            sem.setSpawnedType(EntityType.fromId((int)mechanism.getValue().asInt()));
            this.item.getItemStack().setItemMeta((ItemMeta)sem);
        }
        if (mechanism.matches("spawn_type") && mechanism.requireEnum(false, (Enum<?>[])EntityType.values())) {
            try {
                sem = (SpawnEggMeta)this.item.getItemStack().getItemMeta();
                sem.setSpawnedType(EntityType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
                this.item.getItemStack().setItemMeta((ItemMeta)sem);
            }
            catch (IllegalArgumentException e) {
                dB.echoError(mechanism.getValue().asString().toUpperCase() + " is not a valid spawn egg entity!");
            }
        }
    }
}

