/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class AssignmentCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesArgumentType(dScript.class) && !scriptEntry.hasObject("script")) {
                if (arg.asType(dScript.class) != null && arg.asType(dScript.class).getType().equalsIgnoreCase("assignment")) {
                    scriptEntry.addObject("script", arg.asType(dScript.class));
                    continue;
                }
                throw new InvalidArgumentsException("Script specified is not an 'assignment-type' container.");
            }
            arg.reportUnhandled();
        }
        if (!((BukkitScriptEntryData)scriptEntry.entryData).hasNPC()) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an action!");
        }
        if (scriptEntry.getObject("action").equals((Object)Action.SET) && !scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Script specified was missing or invalid.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dScript script = (dScript)scriptEntry.getdObject("script");
        dB.report(scriptEntry, this.getName(), aH.debugObj("action", scriptEntry.getObject("action")) + (script != null ? script.debug() : ""));
        if (scriptEntry.getObject("action").equals((Object)Action.SET)) {
            ((AssignmentTrait)((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getCitizen().getTrait(AssignmentTrait.class)).setAssignment(script.getName(), ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer());
        } else if (scriptEntry.getObject("action").equals((Object)Action.REMOVE)) {
            ((AssignmentTrait)((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getCitizen().getTrait(AssignmentTrait.class)).removeAssignment(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer());
        }
    }

    private static enum Action {
        SET,
        REMOVE;

    }
}

