/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.AdvancementHelper;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Player;

public class AdvancementCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("target", "targets", "t") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("targets", arg.asType(dList.class).filter(dPlayer.class));
                continue;
            }
            if (!scriptEntry.hasObject("description") && arg.matchesPrefix("description", "d")) {
                scriptEntry.addObject("description", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("icon") && arg.matchesPrefix("icon", "i") && arg.matchesArgumentType(dMaterial.class)) {
                scriptEntry.addObject("icon", arg.asType(dMaterial.class));
                continue;
            }
            if (!scriptEntry.hasObject("frame") && arg.matchesPrefix("frame", "f") && arg.matchesEnum(Frame.values())) {
                scriptEntry.addObject("frame", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("toast") && arg.matches("hide_toast")) {
                scriptEntry.addObject("toast", Element.FALSE);
                continue;
            }
            if (!scriptEntry.hasObject("announce") && arg.matches("announce")) {
                scriptEntry.addObject("announce", Element.TRUE);
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", new Element(arg.raw_value));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Must specify a message!");
        }
        if (!scriptEntry.hasObject("targets")) {
            BukkitScriptEntryData data = (BukkitScriptEntryData)scriptEntry.entryData;
            if (!data.hasPlayer()) {
                throw new InvalidArgumentsException("Must specify valid player targets!");
            }
            scriptEntry.addObject("targets", Arrays.asList(data.getPlayer()));
        }
        scriptEntry.defaultObject("icon", dMaterial.AIR);
        scriptEntry.defaultObject("description", new Element("A custom Denizen advancement."));
        scriptEntry.defaultObject("frame", new Element("task"));
        scriptEntry.defaultObject("toast", Element.TRUE);
        scriptEntry.defaultObject("announce", Element.FALSE);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element text = scriptEntry.getElement("text");
        Element description = scriptEntry.getElement("description");
        Element frame = scriptEntry.getElement("frame");
        Element toast = scriptEntry.getElement("toast");
        Element announce = scriptEntry.getElement("announce");
        dMaterial icon = (dMaterial)scriptEntry.getdObject("icon");
        List players = (List)scriptEntry.getObject("targets");
        ArrayList<Player> bukkitPlayers = new ArrayList<Player>();
        for (dPlayer player : players) {
            bukkitPlayers.add(player.getPlayerEntity());
        }
        AdvancementHelper advancement = new AdvancementHelper(text.asString(), description.asString(), icon.getMaterial(), CoreUtilities.toLowerCase(frame.asString()), announce.asBoolean(), toast.asBoolean());
        advancement.showTo(bukkitPlayers);
    }

    private static enum Frame {
        CHALLENGE,
        GOAL,
        TASK;

    }
}

