/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;

public class SignCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class).setPrefix("location"));
                continue;
            }
            if (!scriptEntry.hasObject("direction") && arg.matchesPrefix("direction", "dir")) {
                scriptEntry.addObject("direction", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", arg.asType(dList.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a Sign location!");
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Must specify sign text!");
        }
        scriptEntry.defaultObject("type", new Element(Type.AUTOMATIC.name()));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        BlockFace bf;
        String direction = scriptEntry.hasObject("direction") ? ((Element)scriptEntry.getObject("direction")).asString() : null;
        Element typeElement = scriptEntry.getElement("type");
        dList text = (dList)scriptEntry.getObject("text");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        dB.report(scriptEntry, this.getName(), typeElement.debug() + location.debug() + text.debug());
        Type type = Type.valueOf(typeElement.asString().toUpperCase());
        Block sign = location.getBlock();
        if (type != Type.AUTOMATIC || sign.getType() != Material.WALL_SIGN && sign.getType() != Material.SIGN_POST) {
            if (type == Type.WALL_SIGN) {
                if (direction != null) {
                    bf = Utilities.chooseSignRotation(direction);
                    org.bukkit.material.Sign sgntmp = new org.bukkit.material.Sign(Material.WALL_SIGN);
                    sgntmp.setFacingDirection(bf);
                    sign.setTypeIdAndData(Material.WALL_SIGN.getId(), sgntmp.getData(), false);
                } else {
                    bf = Utilities.chooseSignRotation(sign);
                    org.bukkit.material.Sign sgntmp = new org.bukkit.material.Sign(Material.WALL_SIGN);
                    sgntmp.setFacingDirection(bf);
                    sign.setTypeIdAndData(Material.WALL_SIGN.getId(), sgntmp.getData(), false);
                }
            } else {
                sign.setType(Material.SIGN_POST, false);
                if (direction != null) {
                    Utilities.setSignRotation(sign.getState(), direction);
                }
            }
        } else if (sign.getType() != Material.WALL_SIGN && sign.getType() != Material.SIGN_POST) {
            if (sign.getRelative(BlockFace.DOWN).getType().isSolid()) {
                sign.setType(Material.SIGN_POST, false);
            } else {
                bf = Utilities.chooseSignRotation(sign);
                org.bukkit.material.Sign sgntmp = new org.bukkit.material.Sign(Material.WALL_SIGN);
                sgntmp.setFacingDirection(bf);
                sign.setTypeIdAndData(Material.WALL_SIGN.getId(), sgntmp.getData(), false);
            }
        }
        BlockState signState = sign.getState();
        Utilities.setSignLines((Sign)signState, text.toArray(4));
    }

    private static enum Type {
        AUTOMATIC,
        SIGN_POST,
        WALL_SIGN;

    }
}

