/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AdvancementHelper {
    private NamespacedKey id = new NamespacedKey((Plugin)NMSHandler.getJavaPlugin(), UUID.randomUUID().toString());
    private String icon;
    private String title;
    private String description;
    private String frame;
    private boolean announce;
    private boolean toast;

    public AdvancementHelper(String title, String description, Material icon, String frame, boolean announce, boolean toast) {
        this.title = title;
        this.description = description;
        this.icon = NMSHandler.getInstance().getItemHelper().getVanillaName(new ItemStack(icon));
        this.frame = frame;
        this.announce = announce;
        this.toast = toast;
    }

    public void showTo(final List<Player> players) {
        this.add();
        this.grant(players);
        new BukkitRunnable(){

            public void run() {
                AdvancementHelper.this.revoke(players);
                AdvancementHelper.this.remove();
            }
        }.runTaskLater((Plugin)NMSHandler.getJavaPlugin(), 20L);
    }

    private void add() {
        try {
            Bukkit.getUnsafe().loadAdvancement(this.id, this.getJson());
        }
        catch (IllegalArgumentException e) {
            dB.echoError("Error registering advancement!");
        }
    }

    private void remove() {
        Bukkit.getUnsafe().removeAdvancement(this.id);
        Bukkit.getServer().reloadData();
    }

    private void grant(List<Player> players) {
        Advancement advancement = Bukkit.getAdvancement((NamespacedKey)this.id);
        for (Player player : players) {
            AdvancementProgress progress = player.getAdvancementProgress(advancement);
            if (progress.isDone()) continue;
            for (String criteria : progress.getRemainingCriteria()) {
                progress.awardCriteria(criteria);
            }
        }
    }

    private void revoke(List<Player> players) {
        Advancement advancement = Bukkit.getAdvancement((NamespacedKey)this.id);
        for (Player player : players) {
            AdvancementProgress progress = player.getAdvancementProgress(advancement);
            if (!progress.isDone()) continue;
            for (String criteria : progress.getAwardedCriteria()) {
                progress.revokeCriteria(criteria);
            }
        }
    }

    private String getJson() {
        JsonObject json = new JsonObject();
        JsonObject icon = new JsonObject();
        icon.addProperty("item", this.icon);
        JsonObject display = new JsonObject();
        display.add("icon", (JsonElement)icon);
        display.addProperty("title", this.title);
        display.addProperty("description", this.description);
        display.addProperty("background", "minecraft:textures/gui/advancements/backgrounds/adventure.png");
        display.addProperty("frame", this.frame);
        display.addProperty("announce_to_chat", Boolean.valueOf(this.announce));
        display.addProperty("show_toast", Boolean.valueOf(this.toast));
        display.addProperty("hidden", Boolean.valueOf(true));
        JsonObject criteria = new JsonObject();
        JsonObject trigger = new JsonObject();
        trigger.addProperty("trigger", "minecraft:impossible");
        criteria.add("impossible", (JsonElement)trigger);
        json.add("criteria", (JsonElement)criteria);
        json.add("display", (JsonElement)display);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)json);
    }
}

