/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.core.ProcedureScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.NaturalOrderComparator;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class dList
extends ArrayList<String>
implements dObject,
dObject.ObjectAttributable {
    public final ArrayList<dObject> objectForms;
    public static final char internal_escape_char = '\u0005';
    public static final String internal_escape = String.valueOf('\u0005');
    private String prefix = "List";
    public String flag = null;
    public static HashMap<String, TagRunnable.ObjectForm> registeredObjectTags = new HashMap();

    @Override
    public boolean add(String addMe) {
        this.objectForms.add(new Element(addMe));
        return super.add(addMe);
    }

    @Override
    public String remove(int index) {
        this.objectForms.remove(index);
        return (String)super.remove(index);
    }

    @Override
    public boolean remove(Object key) {
        int ind = super.indexOf(key);
        if (ind < 0 || ind >= this.size()) {
            return false;
        }
        this.remove(ind);
        return true;
    }

    public boolean addAll(dList inp) {
        this.objectForms.addAll(inp.objectForms);
        return super.addAll(inp);
    }

    public boolean addObject(dObject obj) {
        this.objectForms.add(obj);
        return super.add(obj.toString());
    }

    public void addObject(int index, dObject obj) {
        this.objectForms.add(index, obj);
        super.add(index, obj.toString());
    }

    public dObject getObject(int id) {
        return this.objectForms.get(id);
    }

    public static dList valueOf(String string) {
        return dList.valueOf(string, null);
    }

    @Fetchable(value="li, fl")
    public static dList valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        dList list = DenizenCore.getImplementation().valueOfFlagdList(string);
        if (list != null) {
            return list;
        }
        return new dList(string.startsWith("li@") ? string.substring(3) : string);
    }

    public static dList getListFor(dObject inp) {
        return inp instanceof dList ? (dList)inp : dList.valueOf(inp.toString());
    }

    public static boolean matches(String arg) {
        boolean flag = DenizenCore.getImplementation().matchesFlagdList(arg);
        return flag || arg.contains("|") || arg.contains(internal_escape) || arg.startsWith("li@");
    }

    public dList(Collection<? extends dObject> dObjectList) {
        this.objectForms = new ArrayList<dObject>(dObjectList);
        for (dObject dObject2 : dObjectList) {
            super.add(dObject2.identify());
        }
    }

    public dList() {
        this.objectForms = new ArrayList();
    }

    public dList(String items) {
        if (items != null && items.length() > 0) {
            int brackets = 0;
            int start = 0;
            for (int i = 0; i < items.length(); ++i) {
                char chr = items.charAt(i);
                if (chr == '[') {
                    ++brackets;
                    continue;
                }
                if (chr == ']') {
                    if (brackets <= 0) continue;
                    --brackets;
                    continue;
                }
                if (brackets != 0 || chr != '|' && chr != '\u0005') continue;
                super.add(items.substring(start, i));
                start = i + 1;
            }
            if (start < items.length()) {
                super.add(items.substring(start, items.length()));
            }
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new Element(str));
        }
    }

    public dList(String flag, boolean is_flag, List<String> flag_contents) {
        if (is_flag) {
            this.flag = flag;
        }
        for (String it : flag_contents) {
            super.add(it);
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new Element(str));
        }
    }

    public dList(dList input) {
        this.objectForms = new ArrayList<dObject>(input.objectForms);
        super.ensureCapacity(input.size());
        for (String str : input) {
            super.add(str);
        }
    }

    public dList(List<String> items) {
        if (items != null) {
            for (String it : items) {
                super.add(it);
            }
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new Element(str));
        }
    }

    public dList(Set<? extends Object> items) {
        this.objectForms = new ArrayList();
        if (items != null) {
            for (Object object : items) {
                String strd = object.toString();
                super.add(strd);
                if (object instanceof dObject) {
                    this.objectForms.add((dObject)object);
                    continue;
                }
                this.objectForms.add(new Element(strd));
            }
        }
    }

    public dList(List<String> items, String prefix) {
        for (String element : items) {
            super.add(prefix + element);
        }
        this.objectForms = new ArrayList(this.size());
        for (String str : this) {
            this.objectForms.add(new Element(str));
        }
    }

    public dList addObjects(List<dObject> dObjects) {
        for (dObject obj : dObjects) {
            this.addObject(obj);
        }
        return this;
    }

    public String[] toArray() {
        return this.toArray(this.size());
    }

    public String[] toArray(int arraySize) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            list.add(string);
        }
        return list.toArray(new String[arraySize]);
    }

    public boolean containsObjectsFrom(Class<? extends dObject> dClass) {
        for (dObject testable : this.objectForms) {
            if (!CoreUtilities.canPossiblyBeType(testable, dClass)) continue;
            return true;
        }
        return false;
    }

    public List<String> filter(Enum[] values) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this) {
            for (Enum value : values) {
                if (!value.name().equalsIgnoreCase(string)) continue;
                list.add(string);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    public <T extends dObject> List<T> filter(Class<T> dClass) {
        return this.filter(dClass, null);
    }

    public <T extends dObject> List<T> filter(Class<T> dClass, ScriptEntry entry) {
        ArrayList<T> results = new ArrayList<T>();
        TagContext context = entry == null ? DenizenCore.getImplementation().getTagContext(null) : entry.entryData.getTagContext();
        for (dObject obj : this.objectForms) {
            try {
                T object;
                if (!CoreUtilities.canPossiblyBeType(obj, dClass) || (object = CoreUtilities.asType(obj, dClass, context)) == null) continue;
                results.add(object);
            }
            catch (Exception e) {
                dB.echoError(e);
            }
        }
        return results;
    }

    @Override
    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dList setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return this.flag != null;
    }

    @Override
    public String getObjectType() {
        return "List";
    }

    @Override
    public String identify() {
        if (this.flag != null) {
            return DenizenCore.getImplementation().getLastEntryFromFlag(this.flag);
        }
        return this.identifyList();
    }

    public String identifyList() {
        if (this.isEmpty()) {
            return "li@";
        }
        StringBuilder dScriptArg = new StringBuilder();
        dScriptArg.append("li@");
        for (String item : this) {
            dScriptArg.append(item).append('|');
        }
        return dScriptArg.substring(0, dScriptArg.length() - 1);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public static void registerTags() {
        dList.registerTag("space_separated", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(dList.parseString((dList)object, " ")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("as_string", registeredObjectTags.get("space_separated"));
        dList.registerTag("asstring", registeredObjectTags.get("space_separated"));
        dList.registerTag("separated_by", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList list = (dList)object;
                if (list.isEmpty()) {
                    return new Element("").getObjectAttribute(attribute.fulfill(1));
                }
                String input = attribute.getContext(1);
                return new Element(dList.parseString(list, input)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("comma_separated", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(dList.parseString((dList)object, ", ")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("ascslist", registeredObjectTags.get("comma_separated"));
        dList.registerTag("as_cslist", registeredObjectTags.get("comma_separated"));
        dList.registerTag("unseparated", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(dList.parseString((dList)object, "")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("get_sub_items", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                int index = -1;
                if (aH.matchesInteger(attribute.getContext(1))) {
                    index = attribute.getIntContext(1) - 1;
                }
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                if (index < 0) {
                    return null;
                }
                dList sub_list = new dList();
                for (String item : (dList)object) {
                    String[] strings = item.split(Pattern.quote(split));
                    if (strings.length > index) {
                        sub_list.add(strings[index]);
                        continue;
                    }
                    sub_list.add("null");
                }
                return sub_list.getObjectAttribute(attribute);
            }
        });
        dList.registerTag("map_get", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (((dList)object).isEmpty()) {
                    return new Element("").getObjectAttribute(attribute.fulfill(1));
                }
                String input = attribute.getContext(1);
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                for (String item : (dList)object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[0].equalsIgnoreCase(input)) continue;
                    return new Element(strings[1]).getObjectAttribute(attribute);
                }
                return null;
            }
        });
        dList.registerTag("map_find_key", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String input = attribute.getContext(1);
                attribute.fulfill(1);
                String split = "/";
                if (attribute.startsWith("split_by")) {
                    if (attribute.hasContext(1) && attribute.getContext(1).length() > 0) {
                        split = attribute.getContext(1);
                    }
                    attribute.fulfill(1);
                }
                for (String item : (dList)object) {
                    String[] strings = item.split(Pattern.quote(split), 2);
                    if (strings.length <= 1 || !strings[1].equalsIgnoreCase(input)) continue;
                    return new Element(strings[0]).getObjectAttribute(attribute);
                }
                return null;
            }
        });
        dList.registerTag("size", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((dList)object).size()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("is_empty", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((dList)object).isEmpty()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("insert", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.insert[...] must have a value.");
                    return null;
                }
                dList items = dList.getListFor(attribute.getContextObject(1));
                if ((attribute = attribute.fulfill(1)).startsWith("at") && attribute.hasContext(1)) {
                    dList result = new dList((dList)object);
                    int index = new Element(attribute.getContext(1)).asInt() - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > result.size()) {
                        index = result.size();
                    }
                    for (int i = 0; i < items.size(); ++i) {
                        result.add(index + i, items.get(i));
                    }
                    return result.getObjectAttribute(attribute.fulfill(1));
                }
                dB.echoError("The tag li@list.insert[...] must be followed by .at[#]!");
                return null;
            }
        });
        dList.registerTag("set", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.set[...] must have a value.");
                    return null;
                }
                if (((dList)object).isEmpty()) {
                    return null;
                }
                dList items = dList.getListFor(attribute.getContextObject(1));
                if ((attribute = attribute.fulfill(1)).startsWith("at") && attribute.hasContext(1)) {
                    dList result = new dList((dList)object);
                    int index = aH.getIntegerFrom(attribute.getContext(1)) - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    if (index > result.size() - 1) {
                        index = result.size() - 1;
                    }
                    result.remove(index);
                    for (int i = 0; i < items.size(); ++i) {
                        result.addObject(index + i, items.objectForms.get(i));
                    }
                    return result.getObjectAttribute(attribute.fulfill(1));
                }
                dB.echoError("The tag li@list.set[...] must be followed by .at[#]!");
                return null;
            }
        });
        dList.registerTag("include", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.include[...] must have a value.");
                    return null;
                }
                dList copy = new dList((dList)object);
                copy.addAll(dList.getListFor(attribute.getContextObject(1)));
                return copy.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("exclude", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.exclude[...] must have a value.");
                    return null;
                }
                dList exclusions = dList.getListFor(attribute.getContextObject(1));
                dList copy = new dList((dList)object);
                for (String exclusion : exclusions) {
                    for (int i = 0; i < copy.size(); ++i) {
                        if (!((String)copy.get(i)).equalsIgnoreCase(exclusion)) continue;
                        copy.remove(i--);
                    }
                }
                return copy.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("remove", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.remove[#] must have a value.");
                    return null;
                }
                dList indices = dList.getListFor(attribute.getContextObject(1));
                dList copy = new dList((dList)object);
                for (String index : indices) {
                    int remove = index.equalsIgnoreCase("last") ? copy.size() - 1 : (index.equalsIgnoreCase("first") ? 0 : new Element(index).asInt() - 1);
                    if (remove < 0 || remove >= copy.size()) continue;
                    copy.set(remove, "\u0000");
                }
                for (int i = 0; i < copy.size(); ++i) {
                    if (!((String)copy.get(i)).equals("\u0000")) continue;
                    copy.remove(i--);
                }
                return copy.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("replace", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.replace[...] must have a value.");
                    return null;
                }
                String replace = attribute.getContext(1);
                dObject replacement = null;
                attribute.fulfill(1);
                if (attribute.startsWith("with") && attribute.hasContext(1)) {
                    replacement = attribute.getContextObject(1);
                    attribute.fulfill(1);
                }
                dList obj = (dList)object;
                dList list = new dList();
                if (replace.startsWith("regex:")) {
                    String regex = replace.substring("regex:".length());
                    Pattern tempPat = Pattern.compile(regex);
                    for (int i = 0; i < obj.size(); ++i) {
                        if (tempPat.matcher((CharSequence)obj.get(i)).matches()) {
                            if (replacement == null) continue;
                            list.addObject(replacement);
                            continue;
                        }
                        list.addObject(obj.getObject(i));
                    }
                } else {
                    String lower = CoreUtilities.toLowerCase(replace);
                    for (int i = 0; i < obj.size(); ++i) {
                        if (CoreUtilities.toLowerCase((String)obj.get(i)).equals(lower)) {
                            if (replacement == null) continue;
                            list.addObject(replacement);
                            continue;
                        }
                        list.addObject(obj.getObject(i));
                    }
                }
                return list.getObjectAttribute(attribute);
            }
        });
        dList.registerTag("reverse", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                ArrayList<dObject> objs = new ArrayList<dObject>(((dList)object).objectForms);
                Collections.reverse(objs);
                return new dList((Collection<? extends dObject>)objs).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("deduplicate", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList obj = (dList)object;
                dList list = new dList();
                int size = obj.size();
                for (int i = 0; i < size; ++i) {
                    String entry = (String)obj.get(i);
                    boolean duplicate = false;
                    for (int x = 0; x < i; ++x) {
                        if (!((String)obj.get(x)).equalsIgnoreCase(entry)) continue;
                        duplicate = true;
                        break;
                    }
                    if (duplicate) continue;
                    list.addObject(obj.objectForms.get(i));
                }
                return list.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("get", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.get[...] must have a value.");
                    return null;
                }
                dList list = (dList)object;
                if (list.isEmpty()) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("Can't get from an empty list.");
                    }
                    return null;
                }
                dList indices = dList.getListFor(attribute.getContextObject(1));
                if (indices.size() > 1) {
                    dList results = new dList();
                    for (String index : indices) {
                        int ind = aH.getIntegerFrom(index);
                        if (ind <= 0 || ind > list.size()) continue;
                        results.add((String)list.get(ind - 1));
                    }
                    return results.getObjectAttribute(attribute.fulfill(1));
                }
                if (indices.size() > 0) {
                    int index = aH.getIntegerFrom((String)indices.get(0)) - 1;
                    if (index >= list.size()) {
                        if (!attribute.hasAlternative()) {
                            dB.echoError("Invalid list.get index.");
                        }
                        return null;
                    }
                    if (index < 0) {
                        index = 0;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("to") && attribute.hasContext(1)) {
                        int index2 = attribute.getIntContext(1) - 1;
                        if (index2 >= list.size()) {
                            index2 = list.size() - 1;
                        }
                        if (index2 < 0) {
                            index2 = 0;
                        }
                        dList newList = new dList();
                        for (int i = index; i <= index2; ++i) {
                            newList.addObject(list.objectForms.get(i));
                        }
                        return newList.getObjectAttribute(attribute.fulfill(1));
                    }
                    return CoreUtilities.autoAttribTyped(list.objectForms.get(index), attribute);
                }
                return null;
            }
        });
        dList.registerTag("find_all_partial", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find_all_partial[...] must have a value.");
                    return null;
                }
                dList list = (dList)object;
                String test = attribute.getContext(1).toUpperCase();
                dList positions = new dList();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).toUpperCase().contains(test)) continue;
                    positions.add(String.valueOf(i + 1));
                }
                return positions.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("find_all", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find_all[...] must have a value.");
                    return null;
                }
                dList list = (dList)object;
                dList positions = new dList();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                    positions.add(String.valueOf(i + 1));
                }
                return positions.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("find_partial", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find_partial[...] must have a value.");
                    return null;
                }
                dList list = (dList)object;
                String test = attribute.getContext(1).toUpperCase();
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).toUpperCase().contains(test)) continue;
                    return new Element(i + 1).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(-1).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("find", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.find[...] must have a value.");
                    return null;
                }
                dList list = (dList)object;
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(attribute.getContext(1))) continue;
                    return new Element(i + 1).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(-1).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("count", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.count[...] must have a value.");
                    return null;
                }
                dList list = (dList)object;
                String element = attribute.getContext(1);
                int count = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!((String)list.get(i)).equalsIgnoreCase(element)) continue;
                    ++count;
                }
                return new Element(count).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("sum", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList list = (dList)object;
                double sum = 0.0;
                for (String entry : list) {
                    sum += aH.getDoubleFrom(entry);
                }
                return new Element(sum).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("average", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList list = (dList)object;
                if (list.isEmpty()) {
                    return new Element(0).getObjectAttribute(attribute.fulfill(1));
                }
                double sum = 0.0;
                for (String entry : list) {
                    sum += aH.getDoubleFrom(entry);
                }
                return new Element(sum / (double)list.size()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("first", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList list = (dList)object;
                if (list.isEmpty()) {
                    return null;
                }
                return CoreUtilities.autoAttribTyped(list.objectForms.get(0), attribute.fulfill(1));
            }
        });
        dList.registerTag("last", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList list = (dList)object;
                if (list.isEmpty()) {
                    return null;
                }
                return CoreUtilities.autoAttribTyped(list.objectForms.get(list.size() - 1), attribute.fulfill(1));
            }
        });
        dList.registerTag("numerical", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                ArrayList<String> sortable = new ArrayList<String>((dList)object);
                Collections.sort(sortable, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        double value = new Element(o1).asDouble() - new Element(o2).asDouble();
                        if (value == 0.0) {
                            return 0;
                        }
                        if (value > 0.0) {
                            return 1;
                        }
                        return -1;
                    }
                });
                return new dList((List<String>)sortable).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("alphanumeric", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                ArrayList<String> sortable = new ArrayList<String>((dList)object);
                Collections.sort(sortable, new NaturalOrderComparator());
                return new dList((List<String>)sortable).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("alphabetical", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                ArrayList<String> sortable = new ArrayList<String>((dList)object);
                Collections.sort(sortable, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                return new dList((List<String>)sortable).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("sort_by_number", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(final Attribute attribute, dObject object) {
                dList newlist = new dList((dList)object);
                try {
                    Collections.sort(newlist.objectForms, new Comparator<dObject>(){

                        @Override
                        public int compare(dObject o1, dObject o2) {
                            double r2;
                            dObject or1 = CoreUtilities.autoAttribTyped(o1, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                            dObject or2 = CoreUtilities.autoAttribTyped(o2, new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context));
                            double r1 = aH.getDoubleFrom(or1.toString());
                            double value = r1 - (r2 = aH.getDoubleFrom(or2.toString()));
                            if (value == 0.0) {
                                return 0;
                            }
                            if (value > 0.0) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    return new dList((Collection<? extends dObject>)newlist.objectForms).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                    return newlist.getObjectAttribute(attribute.fulfill(1));
                }
            }
        });
        dList.registerTag("sort", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList obj = new dList((dList)object);
                final ProcedureScriptContainer script = (ProcedureScriptContainer)dScript.valueOf(attribute.getContext(1)).getContainer();
                if (script == null) {
                    dB.echoError("'" + attribute.getContext(1) + "' is not a valid procedure script!");
                    return obj.getObjectAttribute(attribute.fulfill(1));
                }
                final ScriptEntry entry = attribute.getScriptEntry();
                attribute = attribute.fulfill(1);
                dList context = new dList();
                if (attribute.startsWith("context")) {
                    context = dList.getListFor(attribute.getContextObject(1));
                    attribute = attribute.fulfill(1);
                }
                final dList context_send = context;
                ArrayList<String> list = new ArrayList<String>(obj);
                try {
                    Collections.sort(list, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            List<ScriptEntry> entries = script.getBaseEntries(entry == null ? DenizenCore.getImplementation().getEmptyScriptEntryData() : entry.entryData.clone());
                            if (entries.isEmpty()) {
                                return 0;
                            }
                            long id = DetermineCommand.getNewId();
                            ScriptBuilder.addObjectToEntries(entries, "reqid", id);
                            InstantQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId("DLIST_SORT"));
                            queue.addEntries(entries);
                            queue.setReqId(id);
                            int x = 1;
                            dList definitions = new dList();
                            definitions.add(o1);
                            definitions.add(o2);
                            definitions.addAll(context_send);
                            String[] definition_names = null;
                            try {
                                definition_names = script.getString("definitions").split("\\|");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            for (String definition : definitions) {
                                String name = definition_names != null && definition_names.length >= x ? definition_names[x - 1].trim() : String.valueOf(x);
                                queue.addDefinition(name, definition);
                                dB.echoDebug((Debuggable)entries.get(0), "Adding definition %" + name + "% as " + definition);
                                ++x;
                            }
                            queue.start();
                            int res = 0;
                            if (DetermineCommand.hasOutcome(id)) {
                                res = new Element((String)DetermineCommand.getOutcome(id).get(0)).asInt();
                            }
                            if (res < 0) {
                                return -1;
                            }
                            if (res > 0) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                }
                catch (Exception e) {
                    dB.echoError("list.sort[...] tag failed - procedure returned unreasonable response - internal error: " + e.getMessage());
                }
                return new dList((List<String>)list).getObjectAttribute(attribute);
            }
        });
        dList.registerTag("filter", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList newlist = new dList();
                try {
                    for (dObject obj : ((dList)object).objectForms) {
                        Attribute tempAttrib = new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context);
                        tempAttrib.setHadAlternative(true);
                        dObject objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                        if (objs == null || !CoreUtilities.toLowerCase(objs.toString()).equals("true")) continue;
                        newlist.addObject(obj);
                    }
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                }
                return newlist.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("parse", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList newlist = new dList();
                try {
                    for (dObject obj : ((dList)object).objectForms) {
                        Attribute tempAttrib = new Attribute(attribute.getContext(1), attribute.getScriptEntry(), attribute.context);
                        tempAttrib.setHadAlternative(attribute.hasAlternative());
                        dObject objs = CoreUtilities.autoAttribTyped(obj, tempAttrib);
                        if (objs == null) {
                            objs = new Element("null");
                        }
                        newlist.addObject(objs);
                    }
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                }
                return newlist.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("pad_left", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.pad_left[...] must have a value.");
                    return null;
                }
                dObject with = new Element("");
                int length = attribute.getIntContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                    with = attribute.getContextObject(1);
                    attribute = attribute.fulfill(1);
                }
                dList newList = new dList((dList)object);
                while (newList.size() < length) {
                    newList.addObject(with);
                }
                return newList.getObjectAttribute(attribute);
            }
        });
        dList.registerTag("pad_right", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.pad_right[...] must have a value.");
                    return null;
                }
                dObject with = new Element("");
                int length = attribute.getIntContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                    with = attribute.getContextObject(1);
                    attribute = attribute.fulfill(1);
                }
                dList newList = new dList((dList)object);
                while (newList.size() < length) {
                    newList.addObject(with);
                }
                return newList.getObjectAttribute(attribute);
            }
        });
        dList.registerTag("escape_contents", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList escaped = new dList();
                for (String entry : (dList)object) {
                    escaped.add(EscapeTags.Escape(entry));
                }
                return escaped.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("unescape_contents", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList escaped = new dList();
                for (String entry : (dList)object) {
                    escaped.add(EscapeTags.unEscape(entry));
                }
                return escaped.getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains_any_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains_any_case_sensitive[...] must have a value.");
                    return null;
                }
                dList list = dList.getListFor(attribute.getContextObject(1));
                boolean state = false;
                block0: for (String element : (dList)object) {
                    for (String sub_element : list) {
                        if (!element.equals(sub_element)) continue;
                        state = true;
                        break block0;
                    }
                }
                return new Element(state).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains_any", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains_any[...] must have a value.");
                    return null;
                }
                dList list = dList.getListFor(attribute.getContextObject(1));
                boolean state = false;
                block0: for (String element : (dList)object) {
                    for (String sub_element : list) {
                        if (!element.equalsIgnoreCase(sub_element)) continue;
                        state = true;
                        break block0;
                    }
                }
                return new Element(state).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains_case_sensitive[...] must have a value.");
                    return null;
                }
                boolean state = false;
                for (String element : (dList)object) {
                    if (!element.equals(attribute.getContext(1))) continue;
                    state = true;
                    break;
                }
                return new Element(state).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("contains", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag li@list.contains[...] must have a value.");
                    return null;
                }
                dList needed = dList.getListFor(attribute.getContextObject(1));
                int gotten = 0;
                block0: for (String check : needed) {
                    for (String element : (dList)object) {
                        if (!element.equalsIgnoreCase(check)) continue;
                        ++gotten;
                        continue block0;
                    }
                }
                return new Element(gotten == needed.size() && gotten > 0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element("List").getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("random", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList obj = (dList)object;
                if (obj.isEmpty()) {
                    return null;
                }
                if (attribute.hasContext(1)) {
                    int count = Integer.valueOf(attribute.getContext(1));
                    ArrayList<dObject> available = new ArrayList<dObject>();
                    available.addAll(obj.objectForms);
                    dList toReturn = new dList();
                    for (int times = 0; !available.isEmpty() && times < count; ++times) {
                        int random = CoreUtilities.getRandom().nextInt(available.size());
                        toReturn.addObject((dObject)available.get(random));
                        available.remove(random);
                    }
                    return toReturn.getObjectAttribute(attribute.fulfill(1));
                }
                return CoreUtilities.autoAttribTyped(obj.objectForms.get(CoreUtilities.getRandom().nextInt(obj.size())), attribute.fulfill(1));
            }
        });
        dList.registerTag("closest_to", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(CoreUtilities.getClosestOption((dList)object, attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("prefix", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((dList)object).prefix).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("debug", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(object.debug()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        dList.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element("List").getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredObjectTags.put(name, runnable);
    }

    public static void registerTag(String name, final TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        dList.registerTag(name, new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(runnable.run(attribute, object)).getObjectAttribute(attribute);
            }
        });
    }

    private static String parseString(dList obj, String spacer) {
        StringBuilder dScriptArg = new StringBuilder();
        for (String item : obj) {
            dScriptArg.append(item);
            dScriptArg.append(spacer);
        }
        return dScriptArg.toString().substring(0, dScriptArg.length() - spacer.length());
    }

    @Override
    public String getAttribute(Attribute attribute) {
        return CoreUtilities.stringifyNullPass(this.getObjectAttribute(attribute));
    }

    @Override
    public <T extends dObject> T asObjectType(Class<T> type, TagContext context) {
        return null;
    }

    @Override
    public dObject getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.isComplete()) {
            return this;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable.ObjectForm otr = registeredObjectTags.get(attrLow);
        if (otr != null) {
            if (!otr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + otr.name + "': '" + attrLow + "'.");
            }
            return otr.run(attribute, this);
        }
        if (this.flag != null && (attribute.startsWith("as_list") || attribute.startsWith("aslist"))) {
            return new dList(this).getObjectAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this, attrLow)) {
            dObject returned = CoreUtilities.autoAttrib(property, attribute);
            if (returned == null) continue;
            return returned;
        }
        return this.flag != null ? new Element(DenizenCore.getImplementation().getLastEntryFromFlag(this.flag)).getObjectAttribute(attribute) : new Element(this.identifyList()).getObjectAttribute(attribute);
    }
}

