/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.aufdemrand.denizencore.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public abstract class BracedCommand
extends AbstractCommand {
    public static List<BracedData> getBracedCommands(ScriptEntry scriptEntry) {
        if (scriptEntry == null) {
            return null;
        }
        boolean hyperdebug = dB.verbose;
        ArrayList<BracedData> bracedSections = new ArrayList<BracedData>();
        List<BracedData> entryBracedSet = scriptEntry.getBracedSet();
        if (entryBracedSet != null) {
            ArrayList<BracedData> res = new ArrayList<BracedData>(entryBracedSet);
            try {
                for (int i = 0; i < res.size(); ++i) {
                    BracedData newbd = new BracedData();
                    BracedData bd = (BracedData)res.get(i);
                    res.set(i, newbd);
                    newbd.key = bd.key;
                    newbd.value = new ArrayList<ScriptEntry>(bd.value.size());
                    for (ScriptEntry sEntry : bd.value) {
                        ScriptEntry newEntry = sEntry.clone();
                        newEntry.entryData.transferDataFrom(scriptEntry.entryData);
                        newbd.value.add(newEntry);
                    }
                    if (bd.needPatch) {
                        newbd.args = new ArrayList<String>(bd.args.size());
                        for (int x = bd.aStart; x <= bd.aEnd; ++x) {
                            newbd.args.add(scriptEntry.args.get(x));
                        }
                        break;
                    }
                    newbd.args = bd.args;
                }
            }
            catch (Exception e) {
                dB.echoError(scriptEntry.getResidingQueue(), e);
            }
            return res;
        }
        if (scriptEntry.getInsideList() != null) {
            List<Object> contents = scriptEntry.getInsideList();
            List<ScriptEntry> entries = ScriptBuilder.buildScriptEntries(contents, scriptEntry.getScript() == null ? null : scriptEntry.getScript().getContainer(), scriptEntry.entryData);
            BracedData bd = new BracedData();
            bd.key = "base";
            bd.args = new ArrayList<String>();
            bd.value = entries;
            bracedSections.add(bd);
            scriptEntry.setBracedSet(bracedSections);
            return BracedCommand.getBracedCommands(scriptEntry);
        }
        TreeMap commandList = new TreeMap();
        int bracesEntered = 0;
        boolean newCommand = true;
        boolean waitingForDash = false;
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "Starting getBracedCommands...");
        }
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "...with first command name: " + scriptEntry.getCommandName());
        }
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "...with first command arguments: " + scriptEntry.getArguments());
        }
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "Entry found: " + scriptEntry.getCommandName());
        }
        List<String> argList = scriptEntry.getArguments();
        String bracesName = scriptEntry.getCommandName().toUpperCase();
        ArrayList<String> bracesArgs = new ArrayList<String>();
        bracesArgs.add(bracesName);
        int startArg = 0;
        for (int i = 0; i < argList.size(); ++i) {
            String arg = argList.get(i);
            if (!arg.equals("{")) continue;
            startArg = i;
            break;
        }
        int tStart = -1;
        int tEnd = -1;
        boolean tPatchMe = false;
        for (int i = startArg; i < argList.size(); ++i) {
            String arg = argList.get(i);
            if (hyperdebug) {
                dB.echoDebug((Debuggable)scriptEntry, "Arg found: " + arg);
            }
            if (arg.equals("{")) {
                tEnd = ++bracesEntered == 1 && bracedSections.size() != 0 ? i - 1 : -1;
                newCommand = false;
                boolean bl = waitingForDash = bracesEntered == 1;
                if (hyperdebug) {
                    dB.echoDebug((Debuggable)scriptEntry, "Opened brace; " + String.valueOf(bracesEntered) + " now");
                }
                if (bracesEntered <= 1) continue;
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
                continue;
            }
            if (arg.equals("}")) {
                --bracesEntered;
                newCommand = false;
                if (hyperdebug) {
                    dB.echoDebug((Debuggable)scriptEntry, "Closed brace; " + String.valueOf(bracesEntered) + " now");
                }
                if (bracesEntered > 0) {
                    ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
                    continue;
                }
                BracedData bd = new BracedData();
                bd.key = bracesName;
                if (bracedSections.contains(bd)) {
                    dB.echoError(scriptEntry.getResidingQueue(), "You may not have braced commands with the same arguments.");
                    break;
                }
                ArrayList<ScriptEntry> bracesSection = new ArrayList<ScriptEntry>();
                for (ArrayList command : commandList.values()) {
                    try {
                        if (command.isEmpty()) {
                            if (!hyperdebug) continue;
                            dB.echoError(scriptEntry.getResidingQueue(), "Empty command?");
                            continue;
                        }
                        String cmd = (String)command.get(0);
                        if (hyperdebug) {
                            dB.echoDebug((Debuggable)scriptEntry, "Calculating " + cmd);
                        }
                        command.remove(0);
                        String[] args = new String[command.size()];
                        args = command.toArray(args);
                        bracesSection.add(new ScriptEntry(cmd, args, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null));
                        bracesSection.get((int)(bracesSection.size() - 1)).entryData.transferDataFrom(scriptEntry.entryData);
                        if (!hyperdebug) continue;
                        dB.echoDebug((Debuggable)scriptEntry, "Command added: " + cmd + ", with " + String.valueOf(args.length) + " arguments");
                    }
                    catch (ScriptEntryCreationException e) {
                        dB.echoError(scriptEntry.getResidingQueue(), e.getMessage());
                    }
                }
                if (hyperdebug) {
                    dB.echoDebug((Debuggable)scriptEntry, "Adding section " + bracesName);
                }
                bd.args = bracesArgs;
                bd.aStart = tStart;
                bd.aEnd = tEnd;
                bd.needPatch = tStart != -1 && tEnd != -1 && tPatchMe;
                bd.value = bracesSection;
                bracedSections.add(bd);
                bracesName = "";
                bracesArgs = new ArrayList();
                commandList = new TreeMap();
                tEnd = -1;
                tStart = i + 1;
                continue;
            }
            if (newCommand && bracesEntered == 1) {
                commandList.put(commandList.size(), new ArrayList());
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
                newCommand = false;
                if (!hyperdebug) continue;
                dB.echoDebug((Debuggable)scriptEntry, "Treating as new command");
                continue;
            }
            if (arg.equals("-") && bracesEntered == 1) {
                newCommand = true;
                waitingForDash = false;
                if (!hyperdebug) continue;
                dB.echoDebug((Debuggable)scriptEntry, "Assuming following is a new command");
                continue;
            }
            if (bracesEntered == 0) {
                bracesName = bracesName + arg + " ";
                bracesArgs.add(arg);
                if (arg.indexOf(37) == -1) continue;
                tPatchMe = true;
                continue;
            }
            if (waitingForDash) {
                dB.echoError(scriptEntry.getResidingQueue(), "Malformed braced section! Missing a - symbol!");
                break;
            }
            newCommand = false;
            ((ArrayList)commandList.get(commandList.lastKey())).add(arg);
            if (!hyperdebug) continue;
            dB.echoDebug((Debuggable)scriptEntry, "Adding to the command");
        }
        scriptEntry.setBracedSet(bracedSections);
        return BracedCommand.getBracedCommands(scriptEntry);
    }

    public static class BracedData {
        public String key;
        public List<String> args;
        public List<ScriptEntry> value;
        public int aStart;
        public int aEnd;
        public boolean needPatch;

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof BracedData) {
                return this.key.equals(((BracedData)o).key);
            }
            return false;
        }
    }
}

