/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class CommandExecuter {
    private static final Pattern definition_pattern = Pattern.compile("%(.+?)%");
    public static ScriptQueue currentQueue;

    public static String parseDefsRaw(ScriptEntry scriptEntry, String arg) {
        if (arg.indexOf(37) == -1) {
            return arg;
        }
        Matcher m = definition_pattern.matcher(arg);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String def = m.group(1);
            boolean dynamic = false;
            if (def.startsWith("|")) {
                def = def.substring(1, def.length() - 1);
                dynamic = true;
            }
            String defval = scriptEntry.getResidingQueue().getDefinition(def);
            String definition = dynamic ? scriptEntry.getResidingQueue().getDefinition(def) : TagManager.escapeOutput(scriptEntry.getResidingQueue().getDefinition(def));
            if (defval == null) {
                dB.echoError(scriptEntry.getResidingQueue(), "Unknown definition %" + m.group(1) + "%.");
                dB.log("(Attempted: " + scriptEntry.toString() + ")");
                definition = "null";
            }
            dB.echoDebug((Debuggable)scriptEntry, "Filled definition %" + m.group(1) + "% with '" + definition + "'.");
            m.appendReplacement(sb, Matcher.quoteReplacement(definition));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public boolean execute(ScriptEntry scriptEntry) {
        AbstractCommand command;
        if (DenizenCore.getImplementation().shouldDebug(scriptEntry)) {
            StringBuilder output = new StringBuilder();
            output.append(scriptEntry.getCommandName());
            if (scriptEntry.getOriginalArguments() == null) {
                dB.echoError(scriptEntry.getResidingQueue(), "Original Arguments null for " + scriptEntry.getCommandName());
            } else {
                for (String arg : scriptEntry.getOriginalArguments()) {
                    output.append(" \"").append(arg).append("\"");
                }
            }
            DenizenCore.getImplementation().debugQueueExecute(scriptEntry, scriptEntry.getResidingQueue().id, output.toString());
            DenizenCore.getImplementation().debugCommandHeader(scriptEntry);
        }
        if ((command = scriptEntry.internal.actualCommand) == null) {
            scriptEntry.internal.actualCommand = command = DenizenCore.getCommandRegistry().get(scriptEntry.internal.command);
            if (command == null || command.getOptions().REQUIRED_ARGS > scriptEntry.getArguments().size()) {
                scriptEntry.broken = true;
            }
        }
        if (scriptEntry.broken) {
            dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Executing command: " + scriptEntry.getCommandName());
            if (command == null) {
                dB.echoError(scriptEntry.getResidingQueue(), scriptEntry.getCommandName() + " is an invalid dCommand! Are you sure it loaded?");
            } else {
                dB.echoError(scriptEntry.getResidingQueue(), scriptEntry.toString() + " cannot be executed! Is the number of arguments given correct?");
            }
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            return false;
        }
        currentQueue = scriptEntry.getResidingQueue();
        String saveName = null;
        try {
            scriptEntry.generateAHArgs();
            boolean genned = false;
            if (scriptEntry.internal.actualCommand.shouldPreParse() && scriptEntry.internal.hasInstantTags) {
                scriptEntry.regenerateArgsCur();
                genned = true;
                TagManager.fillArgumentsObjects(scriptEntry.processed_arguments, scriptEntry.args, scriptEntry.args_cur, scriptEntry.aHArgs, true, DenizenCore.getImplementation().getTagContextFor(scriptEntry, true), scriptEntry.internal.processArgs);
            }
            if (scriptEntry.internal.hasOldDefs) {
                if (!genned) {
                    scriptEntry.regenerateArgsCur();
                    genned = true;
                }
                for (int argId : scriptEntry.internal.processArgs) {
                    String arg = scriptEntry.args.get(argId);
                    if (arg.indexOf(37) == -1) continue;
                    String parsed = CommandExecuter.parseDefsRaw(scriptEntry, arg);
                    scriptEntry.setArgument(argId, parsed);
                    aH.Argument aharg = new aH.Argument(parsed);
                    aH.Argument oldaharg = scriptEntry.aHArgs.get(argId);
                    aharg.needsFill = oldaharg.needsFill || oldaharg.hasSpecialPrefix;
                    aharg.hasSpecialPrefix = false;
                    scriptEntry.aHArgs.set(argId, aharg);
                    ScriptEntry.Argument argse = scriptEntry.args_cur.get(argId);
                    argse.value = TagManager.genChain(parsed, scriptEntry);
                    argse.prefix = null;
                }
            }
            for (aH.Argument arg : scriptEntry.internal.preprocArgs) {
                if (DenizenCore.getImplementation().handleCustomArgs(scriptEntry, arg, false) || !arg.matchesOnePrefix("save")) continue;
                saveName = TagManager.tag(arg.getValue(), DenizenCore.getImplementation().getTagContext(scriptEntry));
                dB.echoDebug((Debuggable)scriptEntry, "...remembering this script entry as '" + saveName + "'!");
            }
            if (scriptEntry.internal.actualCommand.shouldPreParse()) {
                TagManager.fillArgumentsObjects(scriptEntry.processed_arguments, scriptEntry.args, genned ? scriptEntry.args_cur : scriptEntry.internal.args_ref, scriptEntry.aHArgs, false, DenizenCore.getImplementation().getTagContextFor(scriptEntry, false), scriptEntry.internal.processArgs);
                aH.specialInterpretTrickStrings = scriptEntry.args;
                aH.specialInterpretTrickObjects = scriptEntry.aHArgs;
            }
            command.parseArgs(scriptEntry);
        }
        catch (InvalidArgumentsException e) {
            dB.echoError(scriptEntry.getResidingQueue(), "Woah! Invalid arguments were specified!");
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                dB.log("+> MESSAGE follows: '" + e.getMessage() + "'");
            }
            dB.log("Usage: " + command.getUsageHint());
            dB.log("(Attempted: " + scriptEntry.toString() + ")");
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            scriptEntry.setFinished(true);
            currentQueue = null;
            return false;
        }
        catch (Exception e) {
            dB.echoError(scriptEntry.getResidingQueue(), "Woah! An exception has been called with this command (while preparing it)!");
            dB.echoError(scriptEntry.getResidingQueue(), e);
            dB.log("(Attempted: " + scriptEntry.toString() + ")");
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            scriptEntry.setFinished(true);
            currentQueue = null;
            return false;
        }
        try {
            command.execute(scriptEntry);
            if (saveName != null) {
                scriptEntry.getResidingQueue().holdScriptEntry(saveName, scriptEntry);
            }
            currentQueue = null;
            return true;
        }
        catch (Exception e) {
            dB.echoError(scriptEntry.getResidingQueue(), "Woah!! An exception has been called with this command (while executing it)!");
            dB.echoError(scriptEntry.getResidingQueue(), e);
            dB.log("(Attempted: " + scriptEntry.toString() + ")");
            dB.echoDebug((Debuggable)scriptEntry, dB.DebugElement.Footer);
            scriptEntry.setFinished(true);
            currentQueue = null;
            return false;
        }
    }
}

