/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.queues.core;

import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.Delayable;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.scheduling.AsyncSchedulable;
import net.aufdemrand.denizencore.utilities.scheduling.RepeatingSchedulable;
import net.aufdemrand.denizencore.utilities.scheduling.Schedulable;

public class TimedQueue
extends ScriptQueue
implements Delayable {
    private Schedulable schedulable;
    private long ticks;
    protected boolean paused = false;
    protected long delay_ticks = 0L;

    public static TimedQueue getQueue(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null!");
        }
        TimedQueue scriptQueue = TimedQueue._queueExists(id) ? (TimedQueue)ScriptQueue._queues.get(id) : new TimedQueue(id, Duration.valueOf(DenizenCore.getImplementation().scriptQueueSpeed()));
        return scriptQueue;
    }

    @Override
    public void delayFor(Duration duration) {
        this.delay_ticks = System.currentTimeMillis() + duration.getMillis();
    }

    @Override
    public boolean isDelayed() {
        return this.delay_ticks > System.currentTimeMillis();
    }

    public TimedQueue(String id, long ticks) {
        super(id);
        this.ticks = ticks;
    }

    public TimedQueue(String id, Duration timing) {
        super(id);
        this.ticks = timing.getTicks();
    }

    @Override
    public boolean isInstantSpeed() {
        return this.ticks <= 0L;
    }

    public Duration getSpeed() {
        return new Duration(this.ticks);
    }

    @Override
    public Delayable setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public TimedQueue setSpeed(long ticks) {
        this.ticks = ticks;
        return this;
    }

    @Override
    protected void onStart() {
        this.revolve();
        if (this.script_entries.isEmpty()) {
            return;
        }
        Schedulable schedulable = new RepeatingSchedulable(new Runnable(){

            @Override
            public void run() {
                TimedQueue.this.revolve();
            }
        }, (float)(this.ticks <= 0L ? 1L : this.ticks) / 20.0f);
        if (this.run_async) {
            schedulable = new AsyncSchedulable(schedulable);
        }
        this.schedulable = schedulable;
        DenizenCore.schedule(schedulable);
    }

    @Override
    public String getName() {
        return "TimedQueue";
    }

    @Override
    protected void onStop() {
        if (this.schedulable != null) {
            this.schedulable.cancel();
        }
    }

    @Override
    protected boolean shouldRevolve() {
        if (this.paused) {
            return false;
        }
        return !this.isDelayed();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("speed")) {
            return this.getSpeed().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Timed").getAttribute(attribute.fulfill(1));
        }
        return super.getAttribute(attribute);
    }
}

