/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.abstracts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.nms.interfaces.Effect;
import net.aufdemrand.denizen.nms.interfaces.Particle;

public abstract class ParticleHelper {
    private final Map<String, Effect> effects = new HashMap<String, Effect>();
    private final List<Effect> visualEffects = new ArrayList<Effect>();
    private final Map<String, Particle> particles = new HashMap<String, Particle>();
    private final List<Particle> visibleParticles = new ArrayList<Particle>();

    protected void register(String name, Effect effect) {
        this.effects.put(name.toUpperCase(), effect);
        if (effect.isVisual()) {
            this.visualEffects.add(effect);
        }
    }

    protected void register(String name, Particle particle) {
        this.particles.put(name.toUpperCase(), particle);
        if (particle.isVisible()) {
            this.visibleParticles.add(particle);
        }
    }

    public boolean hasEffect(String name) {
        return this.effects.containsKey(name.toUpperCase());
    }

    public boolean hasParticle(String name) {
        return this.particles.containsKey(name.toUpperCase());
    }

    public Effect getEffect(String name) {
        return this.effects.get(name.toUpperCase());
    }

    public Particle getParticle(String name) {
        return this.particles.get(name.toUpperCase());
    }

    public List<Particle> getVisibleParticles() {
        return this.visibleParticles;
    }

    public List<Effect> getVisualEffects() {
        return this.visualEffects;
    }
}

