/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.helpers;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import net.aufdemrand.denizen.nms.impl.blocks.BlockData_v1_9_R2;
import net.aufdemrand.denizen.nms.impl.jnbt.CompoundTag_v1_9_R2;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.nms.interfaces.BlockHelper;
import net.aufdemrand.denizen.nms.util.PlayerProfile;
import net.aufdemrand.denizen.nms.util.ReflectionHelper;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.minecraft.server.v1_9_R2.Block;
import net.minecraft.server.v1_9_R2.BlockPosition;
import net.minecraft.server.v1_9_R2.Item;
import net.minecraft.server.v1_9_R2.ItemBlock;
import net.minecraft.server.v1_9_R2.TileEntity;
import net.minecraft.server.v1_9_R2.TileEntityFlowerPot;
import net.minecraft.server.v1_9_R2.TileEntitySkull;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_9_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_9_R2.block.CraftSkull;
import org.bukkit.craftbukkit.v1_9_R2.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class BlockHelper_v1_9_R2
implements BlockHelper {
    @Override
    public int idFor(Material mat) {
        return mat.getId();
    }

    @Override
    public MaterialData getFlowerpotContents(org.bukkit.block.Block block) {
        TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        net.minecraft.server.v1_9_R2.ItemStack is = new net.minecraft.server.v1_9_R2.ItemStack(flowerPot.d());
        return new MaterialData(CraftItemStack.asBukkitCopy((net.minecraft.server.v1_9_R2.ItemStack)is).getType(), (byte)flowerPot.e());
    }

    @Override
    public void setFlowerpotContents(org.bukkit.block.Block block, MaterialData data) {
        TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        net.minecraft.server.v1_9_R2.ItemStack contents = CraftItemStack.asNMSCopy((ItemStack)data.toItemStack());
        if (contents == null) {
            flowerPot.a(null, 0);
        } else {
            flowerPot.a(contents.getItem(), contents.getData());
        }
        block.getState().update();
    }

    @Override
    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((CraftSkull)skull).getTileEntity().getGameProfile();
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    @Override
    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        TileEntitySkull tileEntity = ((CraftSkull)skull).getTileEntity();
        tileEntity.setSkullType(SkullType.PLAYER.ordinal());
        tileEntity.setGameProfile(gameProfile);
        skull.getBlock().getState().update();
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        TileEntity tileEntity = ((CraftBlockState)block.getState()).getTileEntity();
        if (tileEntity == null) {
            return null;
        }
        return CompoundTag_v1_9_R2.fromNMSTag(tileEntity.E_());
    }

    @Override
    public void setNbtData(org.bukkit.block.Block block, CompoundTag compoundTag) {
        TileEntity tileEntity = ((CraftBlockState)block.getState()).getTileEntity();
        if (tileEntity == null) {
            return;
        }
        tileEntity.a(((CompoundTag_v1_9_R2)compoundTag).toNMSTag());
        tileEntity.update();
    }

    @Override
    public BlockData getBlockData(Material material, byte data) {
        return new BlockData_v1_9_R2(material, data);
    }

    @Override
    public BlockData getBlockData(org.bukkit.block.Block block) {
        return new BlockData_v1_9_R2(block);
    }

    @Override
    public BlockData getBlockData(String compressedString) {
        return BlockData_v1_9_R2.fromCompressedString(compressedString);
    }

    private static Block getBlockFrom(Material material) {
        net.minecraft.server.v1_9_R2.ItemStack is = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(material));
        if (is == null) {
            return null;
        }
        Item item = is.getItem();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        return ((ItemBlock)item).d();
    }

    @Override
    public boolean hasBlock(Material material) {
        return BlockHelper_v1_9_R2.getBlockFrom(material) != null;
    }

    @Override
    public boolean setBlockResistance(Material material, float resistance) {
        Block block = BlockHelper_v1_9_R2.getBlockFrom(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(Block.class, "durability", block, Float.valueOf(resistance));
        return true;
    }

    @Override
    public float getBlockResistance(Material material) {
        Block block = BlockHelper_v1_9_R2.getBlockFrom(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(Block.class, "durability", block)).floatValue();
    }

    @Override
    public boolean isSafeBlock(Material material) {
        switch (material) {
            case LEVER: 
            case WOOD_BUTTON: 
            case STONE_BUTTON: 
            case REDSTONE_WIRE: 
            case SAPLING: 
            case SIGN_POST: 
            case WALL_SIGN: 
            case SNOW: 
            case TORCH: 
            case DETECTOR_RAIL: 
            case ACTIVATOR_RAIL: 
            case RAILS: 
            case POWERED_RAIL: 
            case NETHER_WARTS: 
            case NETHER_STALK: 
            case VINE: 
            case SUGAR_CANE_BLOCK: 
            case CROPS: 
            case LONG_GRASS: 
            case RED_MUSHROOM: 
            case BROWN_MUSHROOM: 
            case DEAD_BUSH: 
            case REDSTONE_TORCH_OFF: 
            case REDSTONE_TORCH_ON: 
            case AIR: 
            case YELLOW_FLOWER: 
            case RED_ROSE: {
                return true;
            }
        }
        return false;
    }
}

