/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.text.StringHolder;

public class ScriptHelper {
    public static YamlConfiguration _yamlScripts = null;
    private static boolean hadError = false;
    private static HashMap<String, String> scriptSources = new HashMap();
    private static HashMap<String, String> scriptOriginalNames = new HashMap();

    public static void reloadScripts() {
        String concatenated = ScriptHelper._concatenateCoreScripts();
        try {
            _yamlScripts = YamlConfiguration.load(concatenated);
        }
        catch (Exception e) {
            hadError = true;
            DenizenCore.getImplementation().debugError("Could not load scripts!");
            DenizenCore.getImplementation().debugException(e);
            _yamlScripts = YamlConfiguration.load("scripts_failed_to_load:\n  type: yaml data\n");
        }
        DenizenCore.getImplementation().buildCoreContainers(_yamlScripts);
    }

    public static YamlConfiguration _gs() {
        return ScriptHelper.getScripts();
    }

    private static YamlConfiguration getScripts() {
        if (_yamlScripts == null) {
            ScriptHelper.reloadScripts();
        }
        return _yamlScripts;
    }

    public static boolean hadError() {
        return hadError;
    }

    public static void resetError() {
        hadError = false;
    }

    public static void setHadError() {
        hadError = true;
    }

    static void handleListing(YamlConfiguration config, List<String> list) {
        for (StringHolder str : config.getKeys(false)) {
            String up = str.str.toUpperCase();
            if (list.contains(up)) {
                hadError = true;
                dB.echoError("There is more than one script named '" + up + "'!");
                continue;
            }
            list.add(up);
        }
    }

    public static String getSource(String script) {
        return scriptSources.get(script.toUpperCase());
    }

    public static String getOriginalName(String script) {
        return scriptOriginalNames.get(script.toUpperCase());
    }

    public static String ClearComments(String filename, String input, boolean trackSources) {
        StringBuilder result = new StringBuilder(input.length());
        String[] lines = input.replace("\t", "    ").replace("\r", "").split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            String trimStart = lines[i].replaceAll("^[\\s\\t]+", "");
            if (trackSources && !line.startsWith("#") && trimStart.length() == lines[i].length() && line.endsWith(":") && line.length() > 1) {
                String name = line.substring(0, line.length() - 1).replace('\"', '\'').replace("'", "");
                scriptSources.put(name.toUpperCase(), filename);
                scriptOriginalNames.put(name.toUpperCase(), name);
                result.append(name.toUpperCase() + ":\n");
                continue;
            }
            if (!line.startsWith("#")) {
                if ((line.startsWith("}") || line.startsWith("{") || line.startsWith("else")) && !line.endsWith(":")) {
                    result.append(' ').append(lines[i].replace('\u0000', ' ').replace(": ", "<&co>").replace("#", "<&ns>")).append("\n");
                    continue;
                }
                String liner = lines[i].replace('\u0000', ' ');
                if (!line.endsWith(":") && line.startsWith("-")) {
                    liner = liner.replace(": ", "<&co> ");
                    liner = liner.replace("#", "<&ns>");
                }
                result.append(liner.replace('\u0000', ' ')).append("\n");
                continue;
            }
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YamlConfiguration loadConfig(String filename, InputStream resource) throws IOException {
        try {
            String script = ScriptHelper.ClearComments(filename, ScriptHelper.convertStreamToString(resource), true);
            YamlConfiguration yamlConfiguration = YamlConfiguration.load(script);
            return yamlConfiguration;
        }
        finally {
            resource.close();
        }
    }

    private static String _concatenateCoreScripts() {
        scriptSources.clear();
        try {
            File file = null;
            file = DenizenCore.getImplementation().getScriptFolder();
            if (!file.exists()) {
                dB.echoError("No script folder found, please create one.");
                hadError = true;
                return "";
            }
            List<File> files = CoreUtilities.listDScriptFiles(file);
            if (files.size() > 0) {
                StringBuilder sb = new StringBuilder();
                ArrayList<String> scriptNames = new ArrayList<String>();
                dB.log("Processing outside scripts... ");
                for (YamlConfiguration outsideConfig : DenizenCore.getImplementation().getOutsideScripts()) {
                    try {
                        dB.log("Processing unnamed script...");
                        sb.append(outsideConfig.saveToString()).append("\r\n");
                    }
                    catch (Exception e) {
                        dB.echoError("Woah! Error parsing outside scripts!");
                        hadError = true;
                    }
                }
                for (File f : files) {
                    String fileName = f.getAbsolutePath().substring(file.getAbsolutePath().length());
                    dB.log("Processing '" + fileName + "'... ");
                    try {
                        String saved;
                        YamlConfiguration yaml = ScriptHelper.loadConfig(f.getAbsolutePath(), new FileInputStream(f));
                        String string = saved = yaml != null ? yaml.saveToString() : null;
                        if (saved != null && saved.length() > 0) {
                            ScriptHelper.handleListing(yaml, scriptNames);
                            sb.append(saved).append("\r\n");
                            continue;
                        }
                        dB.echoError("Woah! Error parsing " + fileName + "! This script has been skipped. No internal error - is the file empty?");
                        hadError = true;
                    }
                    catch (Exception e) {
                        dB.echoError("Woah! Error parsing " + fileName + "!");
                        hadError = true;
                        dB.echoError(e);
                    }
                }
                dB.echoApproval("All scripts loaded!");
                return sb.toString();
            }
            dB.echoError("Woah! No scripts in /plugins/Denizen/scripts/ to load!");
            hadError = true;
        }
        catch (Exception e) {
            dB.echoError("Woah! No script folder found in /plugins/Denizen/scripts/");
            hadError = true;
            dB.echoError(e);
        }
        return "";
    }
}

