/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class DetermineCommand
extends AbstractCommand {
    public static String DETERMINE_NONE = "none";
    private static Map<Long, dList> cache = new ConcurrentHashMap<Long, dList>(8, 0.9f, 1);
    public static long uniqueId = 0L;

    public static long getNewId() {
        if (uniqueId == Long.MAX_VALUE) {
            uniqueId = 0L;
        }
        return uniqueId++;
    }

    public static boolean hasOutcome(long id) {
        return cache.containsKey(id) && !cache.get(id).isEmpty();
    }

    public static dList getOutcome(long id) {
        dList outcome = cache.get(id);
        cache.remove(id);
        return outcome;
    }

    public static String readOutcome(long id) {
        return cache.get(id).isEmpty() ? DETERMINE_NONE : (String)cache.get(id).get(0);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("passive", "passively")) {
                scriptEntry.addObject("passively", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("outcome")) {
                scriptEntry.addObject("outcome", arg.hasPrefix() ? new Element(arg.raw_value) : arg.object);
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("passively", new Element(false));
        scriptEntry.defaultObject("outcome", new Element(DETERMINE_NONE));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Object outcomeObj = scriptEntry.getdObject("outcome");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), outcomeObj.debug() + scriptEntry.getElement("passively").debug());
        }
        Boolean passively = scriptEntry.getElement("passively").asBoolean();
        Long uniqueId = (Long)scriptEntry.getObject("reqid");
        if (uniqueId == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Cannot use determine in this queue!");
            return;
        }
        dList strs = cache.get(uniqueId);
        if (strs == null) {
            strs = new dList();
            cache.put(uniqueId, strs);
        }
        strs.addObject((dObject)outcomeObj);
        if (!passively.booleanValue()) {
            scriptEntry.getResidingQueue().clear();
        }
    }
}

