/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.impl.jnbt.CompoundTag_v1_11_R1;
import net.aufdemrand.denizen.nms.interfaces.EntityHelper;
import net.aufdemrand.denizen.nms.util.BoundingBox;
import net.aufdemrand.denizen.nms.util.Utilities;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.minecraft.server.v1_11_R1.AxisAlignedBB;
import net.minecraft.server.v1_11_R1.Block;
import net.minecraft.server.v1_11_R1.BlockPosition;
import net.minecraft.server.v1_11_R1.DataWatcherRegistry;
import net.minecraft.server.v1_11_R1.EntityHuman;
import net.minecraft.server.v1_11_R1.EntityInsentient;
import net.minecraft.server.v1_11_R1.EntityLiving;
import net.minecraft.server.v1_11_R1.EntityPlayer;
import net.minecraft.server.v1_11_R1.EntityTracker;
import net.minecraft.server.v1_11_R1.EntityTrackerEntry;
import net.minecraft.server.v1_11_R1.EnumHand;
import net.minecraft.server.v1_11_R1.EnumMoveType;
import net.minecraft.server.v1_11_R1.GenericAttributes;
import net.minecraft.server.v1_11_R1.MovingObjectPosition;
import net.minecraft.server.v1_11_R1.NBTTagCompound;
import net.minecraft.server.v1_11_R1.NavigationAbstract;
import net.minecraft.server.v1_11_R1.PathEntity;
import net.minecraft.server.v1_11_R1.Vec3D;
import net.minecraft.server.v1_11_R1.World;
import net.minecraft.server.v1_11_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_11_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftPlayer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityHelper_v1_11_R1
extends EntityHelper {
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();

    @Override
    public int getBodyArrows(Entity entity) {
        return (Integer)((CraftEntity)entity).getHandle().getDataWatcher().get(DataWatcherRegistry.b.a(10));
    }

    @Override
    public void setBodyArrows(Entity entity, int numArrows) {
        ((CraftEntity)entity).getHandle().getDataWatcher().set(DataWatcherRegistry.b.a(10), (Object)numArrows);
    }

    @Override
    public Entity getFishHook(PlayerFishEvent event) {
        return event.getHook();
    }

    @Override
    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Block.getById((int)location.getBlock().getType().getId()).interact((World)((CraftWorld)location.getWorld()).getHandle(), pos, ((CraftWorld)location.getWorld()).getHandle().getType(pos), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.MAIN_HAND, null, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public Entity getEntity(org.bukkit.World world, UUID uuid) {
        net.minecraft.server.v1_11_R1.Entity entity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    @Override
    public boolean isBreeding(Animals entity) {
        return ((CraftAnimals)entity).getHandle().isInLove();
    }

    @Override
    public void setBreeding(Animals entity, boolean breeding) {
        if (breeding) {
            ((CraftAnimals)entity).getHandle().c((EntityHuman)null);
        } else {
            ((CraftAnimals)entity).getHandle().resetLove();
        }
    }

    @Override
    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    @Override
    public CompoundTag getNbtData(Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().c(compound);
        return CompoundTag_v1_11_R1.fromNMSTag(compound);
    }

    @Override
    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().f(((CompoundTag_v1_11_R1)compoundTag).toNMSTag());
    }

    @Override
    public void setSilent(Entity entity, boolean silent) {
        entity.setSilent(silent);
    }

    @Override
    public boolean isSilent(Entity entity) {
        return entity.isSilent();
    }

    @Override
    public ItemStack getItemInHand(LivingEntity entity) {
        return entity.getEquipment().getItemInMainHand();
    }

    @Override
    public void setItemInHand(LivingEntity entity, ItemStack itemStack) {
        entity.getEquipment().setItemInMainHand(itemStack);
    }

    @Override
    public ItemStack getItemInOffHand(LivingEntity entity) {
        return entity.getEquipment().getItemInOffHand();
    }

    @Override
    public void setItemInOffHand(LivingEntity entity, ItemStack itemStack) {
        entity.getEquipment().setItemInOffHand(itemStack);
    }

    @Override
    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    @Override
    public void stopWalking(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().o();
    }

    @Override
    public void toggleAI(Entity entity, boolean hasAI) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).setAI(!hasAI);
    }

    @Override
    public boolean isAIDisabled(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return true;
        }
        return ((EntityInsentient)nmsEntity).hasAI();
    }

    @Override
    public double getSpeed(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).b();
    }

    @Override
    public void setSpeed(Entity entity, double speed) {
        net.minecraft.server.v1_11_R1.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
    }

    @Override
    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander) {
        if (target == null || follower == null) {
            return;
        }
        net.minecraft.server.v1_11_R1.Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation(targetLocation, follower.getLocation(), maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        follower.teleport(Utilities.getWalkableLocationNear(targetLocation, locationNearInt));
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation(targetLocation, follower.getLocation(), lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.o();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    @Override
    public void walkTo(final Entity entity, Location location, double speed, final Runnable callback) {
        PathEntity path;
        if (entity == null || location == null) {
            return;
        }
        net.minecraft.server.v1_11_R1.Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        final boolean aiDisabled = this.isAIDisabled(entity);
        if (aiDisabled) {
            this.toggleAI(entity, true);
            nmsEntity.onGround = true;
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ())) != null) {
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).b();
            nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            new BukkitRunnable(){

                public void run() {
                    if (entityNavigation.n() || path.b()) {
                        if (callback != null) {
                            callback.run();
                        }
                        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(oldSpeed);
                        if (aiDisabled) {
                            EntityHelper_v1_11_R1.this.toggleAI(entity, false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    @Override
    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            this.ensurePlayerHiding();
            pl.hidePlayer((Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            EntityTracker tracker = ((WorldServer)craftPlayer.getHandle().world).tracker;
            net.minecraft.server.v1_11_R1.Entity other = ((CraftEntity)entity).getHandle();
            EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
            }
        }
    }

    @Override
    public void sendShowPacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            EntityTracker tracker = ((WorldServer)craftPlayer.getHandle().world).tracker;
            net.minecraft.server.v1_11_R1.Entity other = ((CraftEntity)entity).getHandle();
            EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    @Override
    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = this.normalizeYaw(yaw - 180.0f);
            }
            this.look(entity, yaw, pitch);
        } else {
            net.minecraft.server.v1_11_R1.Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    @Override
    public float getBaseYaw(Entity entity) {
        net.minecraft.server.v1_11_R1.Entity handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aO;
    }

    @Override
    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.server.v1_11_R1.Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.yaw = yaw;
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aO = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.aN = yaw;
                }
                livingHandle.aP = yaw;
            }
            handle.pitch = pitch;
        }
    }

    private static MovingObjectPosition rayTrace(org.bukkit.World world, Vector start, Vector end) {
        return ((CraftWorld)world).getHandle().rayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()));
    }

    @Override
    public boolean canTrace(org.bukkit.World world, Vector start, Vector end) {
        return EntityHelper_v1_11_R1.rayTrace(world, start, end) == null;
    }

    @Override
    public EntityHelper.MapTraceResult mapTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        Vector startVec = start.toVector();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        Vector endVec = startVec.clone().add(new Vector(nx, -ny, nz).multiply(range));
        MovingObjectPosition l = EntityHelper_v1_11_R1.rayTrace(start.getWorld(), startVec, endVec);
        if (l == null || l.pos == null) {
            return null;
        }
        Vector finalVec = new Vector(l.pos.x, l.pos.y, l.pos.z);
        EntityHelper.MapTraceResult mtr = new EntityHelper.MapTraceResult();
        switch (l.direction) {
            case NORTH: {
                mtr.angle = BlockFace.NORTH;
                break;
            }
            case SOUTH: {
                mtr.angle = BlockFace.SOUTH;
                break;
            }
            case EAST: {
                mtr.angle = BlockFace.EAST;
                break;
            }
            case WEST: {
                mtr.angle = BlockFace.WEST;
            }
        }
        Vector hit = finalVec.clone().subtract(endVec.clone().subtract(startVec).normalize().multiply(0.072));
        mtr.hitLocation = new Location(start.getWorld(), hit.getX(), hit.getY(), hit.getZ());
        return mtr;
    }

    @Override
    public Location rayTrace(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelper_v1_11_R1.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.pos != null) {
            return new Location(start.getWorld(), l.pos.x, l.pos.y, l.pos.z);
        }
        return null;
    }

    @Override
    public Location getImpactNormal(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelper_v1_11_R1.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.direction != null) {
            return new Location(start.getWorld(), (double)l.direction.getAdjacentX(), (double)l.direction.getAdjacentY(), (double)l.direction.getAdjacentZ());
        }
        return null;
    }

    @Override
    public void faceLocation(Entity from, Location at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location origin = from instanceof LivingEntity ? ((LivingEntity)from).getEyeLocation() : from.getLocation().getBlock().getLocation().add(0.5, 0.5, 0.5);
        Location rotated = this.faceLocation(origin, at);
        this.rotate(from, rotated.getYaw(), rotated.getPitch());
    }

    @Override
    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(EnumMoveType.SELF, vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public void teleport(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().setPosition(vector.getX(), vector.getY(), vector.getZ());
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        AxisAlignedBB boundingBox = ((CraftEntity)entity).getHandle().getBoundingBox();
        Vector position = new Vector(boundingBox.a, boundingBox.b, boundingBox.c);
        Vector size = new Vector(boundingBox.d, boundingBox.e, boundingBox.f);
        return new BoundingBox(position, size);
    }

    @Override
    public void setBoundingBox(Entity entity, BoundingBox boundingBox) {
        Vector low = boundingBox.getLow();
        Vector high = boundingBox.getHigh();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(low.getX(), low.getY(), low.getZ(), high.getX(), high.getY(), high.getZ()));
    }

    @Override
    public boolean isChestedHorse(Entity horse) {
        return horse instanceof ChestedHorse;
    }

    @Override
    public boolean isCarryingChest(Entity horse) {
        return horse instanceof ChestedHorse && ((ChestedHorse)horse).isCarryingChest();
    }

    @Override
    public void setCarryingChest(Entity horse, boolean carrying) {
        if (horse instanceof ChestedHorse) {
            ((ChestedHorse)horse).setCarryingChest(carrying);
        }
    }
}

