/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.impl.packets;

import java.lang.reflect.Field;
import java.util.Map;
import net.aufdemrand.denizen.nms.interfaces.packets.PacketOutChat;
import net.aufdemrand.denizen.nms.util.ReflectionHelper;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_13_R2.ChatComponentText;
import net.minecraft.server.v1_13_R2.ChatMessageType;
import net.minecraft.server.v1_13_R2.IChatBaseComponent;
import net.minecraft.server.v1_13_R2.PacketPlayOutChat;

public class PacketOutChat_v1_13_R2
implements PacketOutChat {
    private PacketPlayOutChat internal;
    private String message;
    private String rawJson;
    private boolean bungee;
    private ChatMessageType position;
    private static final Field MESSAGE;
    private static final Field POSITION;

    public PacketOutChat_v1_13_R2(PacketPlayOutChat internal) {
        this.internal = internal;
        try {
            IChatBaseComponent baseComponent = (IChatBaseComponent)MESSAGE.get(internal);
            if (baseComponent != null) {
                this.message = baseComponent.getString();
                this.rawJson = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)baseComponent);
            } else {
                this.message = BaseComponent.toPlainText((BaseComponent[])internal.components);
                this.rawJson = ComponentSerializer.toString((BaseComponent[])internal.components);
                this.bungee = true;
            }
            this.position = (ChatMessageType)POSITION.get(internal);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    @Override
    public int getPosition() {
        return this.position.ordinal();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getRawJson() {
        return this.rawJson;
    }

    @Override
    public void setPosition(int position) {
        try {
            POSITION.set(this.internal, position);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    @Override
    public void setMessage(String message) {
        try {
            if (!this.bungee) {
                MESSAGE.set(this.internal, new ChatComponentText(message));
            } else {
                this.internal.components = new BaseComponent[]{new TextComponent(message)};
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    @Override
    public void setRawJson(String rawJson) {
        try {
            if (!this.bungee) {
                MESSAGE.set(this.internal, IChatBaseComponent.ChatSerializer.a((String)rawJson));
            } else {
                this.internal.components = ComponentSerializer.parse((String)rawJson);
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    static {
        Map<String, Field> fields = ReflectionHelper.getFields(PacketPlayOutChat.class);
        MESSAGE = fields.get("a");
        POSITION = fields.get("b");
    }
}

