/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.interfaces;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.aufdemrand.denizen.nms.util.BoundingBox;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class EntityHelper {
    public static UUID DEFAULT_HIDE = new UUID(0L, 0L);
    public static Map<UUID, Set<UUID>> hiddenEntitiesEntPl = new HashMap<UUID, Set<UUID>>();
    public static Map<UUID, Set<UUID>> hiddenEntitiesPlEnt = new HashMap<UUID, Set<UUID>>();
    public static EnforcePlayerHides EPH = null;
    public static Set<UUID> hiddenByDefaultPlayers = new HashSet<UUID>();

    public void setRiptide(Entity entity, boolean state) {
        dB.echoError("Riptide control not available on this server version.");
    }

    public void setCarriedItem(Enderman entity, ItemStack item) {
        entity.setCarriedMaterial(item.getData());
    }

    public abstract int getBodyArrows(Entity var1);

    public abstract void setBodyArrows(Entity var1, int var2);

    public abstract Entity getFishHook(PlayerFishEvent var1);

    public abstract void forceInteraction(Player var1, Location var2);

    public abstract Entity getEntity(World var1, UUID var2);

    public abstract boolean isBreeding(Animals var1);

    public abstract void setBreeding(Animals var1, boolean var2);

    public abstract void setTarget(Creature var1, LivingEntity var2);

    public abstract CompoundTag getNbtData(Entity var1);

    public abstract void setNbtData(Entity var1, CompoundTag var2);

    public abstract void setSilent(Entity var1, boolean var2);

    public abstract boolean isSilent(Entity var1);

    public abstract ItemStack getItemInHand(LivingEntity var1);

    public abstract void setItemInHand(LivingEntity var1, ItemStack var2);

    public abstract ItemStack getItemInOffHand(LivingEntity var1);

    public abstract void setItemInOffHand(LivingEntity var1, ItemStack var2);

    public abstract void stopFollowing(Entity var1);

    public abstract void stopWalking(Entity var1);

    public abstract void toggleAI(Entity var1, boolean var2);

    public abstract boolean isAIDisabled(Entity var1);

    public abstract double getSpeed(Entity var1);

    public abstract void setSpeed(Entity var1, double var2);

    public abstract void follow(Entity var1, Entity var2, double var3, double var5, double var7, boolean var9);

    public abstract void walkTo(Entity var1, Location var2, double var3, Runnable var5);

    public void ensurePlayerHiding() {
        if (EPH == null) {
            Plugin pl = Bukkit.getPluginManager().getPlugin("Denizen");
            EPH = new EnforcePlayerHides();
            EntityHelper.EPH.denizenPlugin = pl;
            Bukkit.getPluginManager().registerEvents((Listener)EPH, pl);
        }
    }

    public boolean addHide(UUID player, UUID entity) {
        Set<UUID> hidden = hiddenEntitiesEntPl.get(entity);
        if (hidden == null) {
            hidden = new HashSet<UUID>();
            hiddenEntitiesEntPl.put(entity, hidden);
        }
        if (player.equals(DEFAULT_HIDE)) {
            for (UUID pl : hidden) {
                Set<UUID> plHid = hiddenEntitiesPlEnt.get(pl);
                if (plHid == null) continue;
                plHid.remove(entity);
            }
            hidden.clear();
        } else {
            Set<UUID> plHid = hiddenEntitiesPlEnt.get(player);
            if (plHid == null) {
                plHid = new HashSet<UUID>();
                hiddenEntitiesPlEnt.put(player, plHid);
            }
            plHid.add(entity);
        }
        return hidden.add(player);
    }

    public void hideEntity(Player player, Entity entity, boolean keepInTabList) {
        if (player == null) {
            this.addHide(DEFAULT_HIDE, entity.getUniqueId());
            if (entity instanceof Player) {
                hiddenByDefaultPlayers.add(entity.getUniqueId());
            }
            for (Player pl : Bukkit.getOnlinePlayers()) {
                this.sendHidePacket(pl, entity);
            }
            return;
        }
        if (this.isHiddenByDefault(entity)) {
            EntityHelper.removeHide(player.getUniqueId(), entity.getUniqueId());
        } else {
            this.addHide(player.getUniqueId(), entity.getUniqueId());
        }
        this.sendHidePacket(player, entity);
    }

    public static boolean removeHide(UUID player, UUID entity) {
        Set<UUID> hidden = hiddenEntitiesEntPl.get(entity);
        if (hidden == null) {
            return false;
        }
        boolean toRet = hidden.remove(player);
        if (player.equals(DEFAULT_HIDE)) {
            for (UUID pl : hidden) {
                Set<UUID> plHid = hiddenEntitiesPlEnt.get(pl);
                if (plHid == null) continue;
                plHid.remove(entity);
            }
            hidden.clear();
        } else {
            Set<UUID> plHid = hiddenEntitiesPlEnt.get(player);
            if (plHid != null) {
                plHid.remove(entity);
            }
        }
        return toRet;
    }

    public void unhideEntity(Player player, Entity entity) {
        if (player == null) {
            EntityHelper.removeHide(DEFAULT_HIDE, entity.getUniqueId());
            if (entity instanceof Player) {
                hiddenByDefaultPlayers.remove(entity.getUniqueId());
            }
            for (Player pl : Bukkit.getOnlinePlayers()) {
                this.sendShowPacket(pl, entity);
            }
            return;
        }
        if (this.isHiddenByDefault(entity)) {
            this.addHide(player.getUniqueId(), entity.getUniqueId());
        } else {
            EntityHelper.removeHide(player.getUniqueId(), entity.getUniqueId());
        }
        this.sendShowPacket(player, entity);
    }

    public boolean isHiddenByDefault(Entity ent) {
        Set<UUID> hiding = hiddenEntitiesEntPl.get(ent.getUniqueId());
        return hiding != null && hiding.contains(DEFAULT_HIDE);
    }

    public boolean isHidden(Player player, Entity entity) {
        if (this.isHiddenByDefault(entity)) {
            Set<UUID> hiding = hiddenEntitiesEntPl.get(entity.getUniqueId());
            return hiding == null || !hiding.contains(player.getUniqueId());
        }
        Set<UUID> hiding = hiddenEntitiesEntPl.get(entity.getUniqueId());
        return hiding != null && hiding.contains(player.getUniqueId());
    }

    public abstract void sendHidePacket(Player var1, Entity var2);

    public abstract void sendShowPacket(Player var1, Entity var2);

    public abstract void rotate(Entity var1, float var2, float var3);

    public abstract float getBaseYaw(Entity var1);

    public abstract void look(Entity var1, float var2, float var3);

    public abstract boolean canTrace(World var1, Vector var2, Vector var3);

    public abstract MapTraceResult mapTrace(LivingEntity var1, double var2);

    public abstract Location rayTrace(Location var1, Vector var2, double var3);

    public abstract Location getImpactNormal(Location var1, Vector var2, double var3);

    public Location eyeTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        return this.rayTrace(start, new Vector(nx, -ny, nz), range);
    }

    public Location faceLocation(Location from, Location at) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        Location newLocation = from.clone();
        newLocation.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(direction.getX(), direction.getZ())));
        newLocation.setPitch(90.0f - (float)Math.toDegrees(Math.acos(direction.getY())));
        return newLocation;
    }

    public abstract void faceLocation(Entity var1, Location var2);

    public void faceEntity(Entity entity, Entity target) {
        this.faceLocation(entity, target.getLocation());
    }

    public boolean isFacingLocation(Location from, Location at, float yawLimitDegrees, float pitchLimitDegrees) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        float pitch = 90.0f - (float)Math.toDegrees(Math.acos(direction.getY()));
        if (from.getPitch() > pitch + pitchLimitDegrees || from.getPitch() < pitch - pitchLimitDegrees) {
            return false;
        }
        return this.isFacingLocation(from, at, yawLimitDegrees);
    }

    public boolean isFacingLocation(Location from, Location at, float degreeLimit) {
        double currentYaw = this.normalizeYaw(from.getYaw());
        double requiredYaw = this.normalizeYaw(this.getYaw(at.toVector().subtract(from.toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    public boolean isFacingLocation(Entity from, Location at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at, degreeLimit);
    }

    public boolean isFacingEntity(Entity from, Entity at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at.getLocation(), degreeLimit);
    }

    public float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = (float)((double)yaw + 360.0);
        }
        return yaw;
    }

    public float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    public String getCardinal(float yaw) {
        if (0.0f <= (yaw = this.normalizeYaw(yaw)) && (double)yaw < 22.5) {
            return "south";
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return "southwest";
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return "west";
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return "northwest";
        }
        if (157.5 <= (double)yaw && (double)yaw < 202.5) {
            return "north";
        }
        if (202.5 <= (double)yaw && (double)yaw < 247.5) {
            return "northeast";
        }
        if (247.5 <= (double)yaw && (double)yaw < 292.5) {
            return "east";
        }
        if (292.5 <= (double)yaw && (double)yaw < 337.5) {
            return "southeast";
        }
        if (337.5 <= (double)yaw && (double)yaw < 360.0) {
            return "south";
        }
        return null;
    }

    public abstract void move(Entity var1, Vector var2);

    public abstract void teleport(Entity var1, Vector var2);

    public abstract BoundingBox getBoundingBox(Entity var1);

    public abstract void setBoundingBox(Entity var1, BoundingBox var2);

    public abstract boolean isChestedHorse(Entity var1);

    public abstract boolean isCarryingChest(Entity var1);

    public abstract void setCarryingChest(Entity var1, boolean var2);

    public static class MapTraceResult {
        public Location hitLocation;
        public BlockFace angle;
    }

    public class EnforcePlayerHides
    implements Listener {
        public Plugin denizenPlugin;

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            for (UUID id : hiddenByDefaultPlayers) {
                Entity pTarget = Bukkit.getEntity((UUID)id);
                if (pTarget == null || !(pTarget instanceof Player)) continue;
                event.getPlayer().hidePlayer((Player)pTarget);
            }
            final Player pl = event.getPlayer();
            final Set<UUID> hides = hiddenEntitiesPlEnt.get(pl.getUniqueId());
            if (hides == null || hides.isEmpty()) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    if (pl.isOnline()) {
                        for (UUID id : hides) {
                            Entity ent = Bukkit.getEntity((UUID)id);
                            if (ent == null) continue;
                            EntityHelper.this.sendHidePacket(pl, ent);
                        }
                    }
                }
            }.runTaskLater(this.denizenPlugin, 5L);
        }
    }
}

