/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.abstracts.ImprovedOfflinePlayer;
import net.aufdemrand.denizen.nms.abstracts.Sidebar;
import net.aufdemrand.denizen.objects.EntityFormObject;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.properties.entity.EntityHealth;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;
import net.aufdemrand.denizen.scripts.commands.player.SidebarCommand;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.packets.ItemChangeMessage;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Achievement;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.map.MapView;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.BlockIterator;

public class dPlayer
implements dObject,
Adjustable,
EntityFormObject {
    static Map<String, UUID> playerNames = new HashMap<String, UUID>();
    OfflinePlayer offlinePlayer = null;
    private String prefix = "Player";

    public static dPlayer mirrorBukkitPlayer(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        return new dPlayer(player);
    }

    public static void notePlayer(OfflinePlayer player) {
        if (player.getName() == null) {
            dB.echoError("Null player " + player.toString());
            return;
        }
        if (!playerNames.containsKey(CoreUtilities.toLowerCase(player.getName()))) {
            playerNames.put(CoreUtilities.toLowerCase(player.getName()), player.getUniqueId());
        }
    }

    public static boolean isNoted(OfflinePlayer player) {
        return playerNames.containsValue(player.getUniqueId());
    }

    public static Map<String, UUID> getAllPlayers() {
        return playerNames;
    }

    public static dPlayer valueOf(String string) {
        return dPlayer.valueOf(string, null);
    }

    @Fetchable(value="p")
    public static dPlayer valueOf(String string, TagContext context) {
        return dPlayer.valueOfInternal(string, context == null || context.debug);
    }

    static dPlayer valueOfInternal(String string, boolean announce) {
        if (string == null) {
            return null;
        }
        if ((string = string.replace("p@", "").replace("P@", "")).indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(string);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null) {
                    return new dPlayer(player);
                }
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
        }
        if (playerNames.containsKey(CoreUtilities.toLowerCase(string))) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerNames.get(CoreUtilities.toLowerCase(string)));
            if (announce) {
                dB.echoError("Warning: loading player by name - use the UUID instead (or use tag server.match_player)! Player named '" + player.getName() + "' has UUID: " + player.getUniqueId());
            }
            return new dPlayer(player);
        }
        if (announce) {
            dB.log("Minor: Invalid Player! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (CoreUtilities.toLowerCase(arg).startsWith("p@")) {
            return true;
        }
        if ((arg = arg.replace("p@", "").replace("P@", "")).indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(arg);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null && player.hasPlayedBefore()) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean playerNameIsValid(String name) {
        return playerNames.containsKey(CoreUtilities.toLowerCase(name));
    }

    public dPlayer(OfflinePlayer player) {
        this.offlinePlayer = player;
    }

    public dPlayer(UUID uuid) {
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public dPlayer(Player player) {
        this((OfflinePlayer)player);
        if (dEntity.isNPC((Entity)player)) {
            throw new IllegalStateException("NPCs are not allowed as dPlayer objects!");
        }
    }

    public boolean isValid() {
        return this.getPlayerEntity() != null || this.getOfflinePlayer() != null;
    }

    public Player getPlayerEntity() {
        if (this.offlinePlayer == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)this.offlinePlayer.getUniqueId());
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public ImprovedOfflinePlayer getNBTEditor() {
        return NMSHandler.getInstance().getPlayerHelper().getOfflineData(this.getOfflinePlayer());
    }

    @Override
    public dEntity getDenizenEntity() {
        return new dEntity((Entity)this.getPlayerEntity());
    }

    public dNPC getSelectedNPC() {
        NPC npc;
        if (Depends.citizens != null && CitizensAPI.hasImplementation() && (npc = CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)this.getPlayerEntity())) != null) {
            return dNPC.mirrorCitizensNPC(npc);
        }
        return null;
    }

    public String getName() {
        if (this.offlinePlayer == null) {
            return null;
        }
        return this.offlinePlayer.getName();
    }

    public String getSaveName() {
        if (this.offlinePlayer == null) {
            return "00.UNKNOWN";
        }
        String baseID = this.offlinePlayer.getUniqueId().toString().toUpperCase().replace("-", "");
        return baseID.substring(0, 2) + "." + baseID;
    }

    public dLocation getLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getLocation());
        }
        return new dLocation(this.getNBTEditor().getLocation());
    }

    public int getRemainingAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getRemainingAir();
        }
        return this.getNBTEditor().getRemainingAir();
    }

    public int getMaximumAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getMaximumAir();
        }
        return 300;
    }

    public double getHealth() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getHealth();
        }
        return this.getNBTEditor().getHealthFloat();
    }

    public double getMaxHealth() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getMaxHealth();
        }
        return this.getNBTEditor().getMaxHealth();
    }

    public int getFoodLevel() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getFoodLevel();
        }
        return this.getNBTEditor().getFoodLevel();
    }

    public dLocation getEyeLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getEyeLocation());
        }
        return null;
    }

    public PlayerInventory getBukkitInventory() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getInventory();
        }
        return this.getNBTEditor().getInventory();
    }

    public dInventory getInventory() {
        if (this.isOnline()) {
            return dInventory.mirrorBukkitInventory((Inventory)this.getPlayerEntity().getInventory());
        }
        return new dInventory(this.getNBTEditor());
    }

    public CraftingInventory getBukkitWorkbench() {
        if (this.isOnline() && (this.getPlayerEntity().getOpenInventory().getType() == InventoryType.WORKBENCH || this.getPlayerEntity().getOpenInventory().getType() == InventoryType.CRAFTING)) {
            return (CraftingInventory)this.getPlayerEntity().getOpenInventory().getTopInventory();
        }
        return null;
    }

    public dInventory getWorkbench() {
        CraftingInventory workbench;
        if (this.isOnline() && (workbench = this.getBukkitWorkbench()) != null) {
            return new dInventory((Inventory)workbench, (InventoryHolder)this.getPlayerEntity());
        }
        return null;
    }

    public Inventory getBukkitEnderChest() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getEnderChest();
        }
        return this.getNBTEditor().getEnderChest();
    }

    public dInventory getEnderChest() {
        if (this.isOnline()) {
            return new dInventory(this.getPlayerEntity().getEnderChest(), (InventoryHolder)this.getPlayerEntity());
        }
        return new dInventory(this.getNBTEditor(), true);
    }

    public World getWorld() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getWorld();
        }
        return this.getLocation().getWorld();
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().decrementStatistic(statistic, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().decrementStatistic(statistic, entity, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().decrementStatistic(statistic, material, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().incrementStatistic(statistic, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().incrementStatistic(statistic, entity, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().incrementStatistic(statistic, material, amount);
        }
    }

    public void setStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().setStatistic(statistic, amount);
        }
    }

    public void setStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().setStatistic(statistic, entity, amount);
        }
    }

    public void setStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().setStatistic(statistic, material, amount);
        }
    }

    public boolean isOnline() {
        return this.getPlayerEntity() != null;
    }

    public void setBedSpawnLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().setBedSpawnLocation(location);
        } else {
            this.getNBTEditor().setBedSpawnLocation(location, this.getNBTEditor().isSpawnForced());
        }
    }

    public void setLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().teleport(location);
        } else {
            this.getNBTEditor().setLocation(location);
        }
    }

    public void setMaximumAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setMaximumAir(air);
        } else {
            dB.echoError("Cannot set the maximum air of an offline player!");
        }
    }

    public void setRemainingAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setRemainingAir(air);
        } else {
            this.getNBTEditor().setRemainingAir(air);
        }
    }

    public void setHealth(double health) {
        if (this.isOnline()) {
            this.getPlayerEntity().setHealth(health);
        } else {
            this.getNBTEditor().setHealthFloat((float)health);
        }
    }

    public void setMaxHealth(double maxHealth) {
        if (this.isOnline()) {
            this.getPlayerEntity().setMaxHealth(maxHealth);
        } else {
            this.getNBTEditor().setMaxHealth(maxHealth);
        }
    }

    public void setFoodLevel(int foodLevel) {
        if (this.isOnline()) {
            this.getPlayerEntity().setFoodLevel(foodLevel);
        } else {
            this.getNBTEditor().setFoodLevel(foodLevel);
        }
    }

    public void setLevel(int level) {
        if (this.isOnline()) {
            this.getPlayerEntity().setLevel(level);
        } else {
            this.getNBTEditor().setLevel(level);
        }
    }

    public void setFlySpeed(float speed) {
        if (this.isOnline()) {
            this.getPlayerEntity().setFlySpeed(speed);
        } else {
            this.getNBTEditor().setFlySpeed(speed);
        }
    }

    public void setGameMode(GameMode mode) {
        if (this.isOnline()) {
            this.getPlayerEntity().setGameMode(mode);
        } else {
            this.getNBTEditor().setGameMode(mode);
        }
    }

    public boolean hasChunkLoaded(Chunk chunk) {
        return NMSHandler.getInstance().getPlayerHelper().hasChunkLoaded(this.getPlayerEntity(), chunk);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dPlayer setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identifySimple() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "Player";
    }

    @Override
    public String identify() {
        return "p@" + this.offlinePlayer.getUniqueId().toString();
    }

    @Override
    public String identifySimple() {
        return "p@" + this.offlinePlayer.getName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        Location target;
        Sidebar sidebar;
        String returned;
        BanEntry ban;
        dMaterial mat;
        if (attribute == null) {
            return null;
        }
        if (this.offlinePlayer == null) {
            return null;
        }
        if (attribute.startsWith("is_player")) {
            return new Element(true).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(true).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history_list")) {
            return new dList(PlayerTags.playerChatHistory.get(this.getPlayerEntity().getUniqueId())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history")) {
            int x = 1;
            if (attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1))) {
                x = attribute.getIntContext(1);
            }
            if (!PlayerTags.playerChatHistory.containsKey(this.getPlayerEntity().getUniqueId())) {
                return null;
            }
            List<String> messages = PlayerTags.playerChatHistory.get(this.getPlayerEntity().getUniqueId());
            if (messages.size() < x || x < 1) {
                return null;
            }
            return new Element(messages.get(x - 1)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag") && attribute.hasContext(1)) {
            String flag_name = attribute.getContext(1);
            if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.playerHasFlag(this, flag_name)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.playerHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(2));
            }
            if (FlagManager.playerHasFlag(this, flag_name)) {
                FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(this, flag_name);
                return new dList(flag.toString(), true, flag.values()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("has_flag") && attribute.hasContext(1)) {
            String flag_name = attribute.getContext(1);
            return new Element(FlagManager.playerHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_flags")) {
            dList allFlags = new dList(DenizenAPI.getCurrentInstance().flagManager().listPlayerFlags(this));
            dList searchFlags = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                searchFlags = new dList();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(search.substring(6), 2);
                        for (String flag : allFlags) {
                            if (!pattern.matcher(flag).matches()) continue;
                            searchFlags.add(flag);
                        }
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String flag : allFlags) {
                        if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                        searchFlags.add(flag);
                    }
                }
                DenizenAPI.getCurrentInstance().flagManager().shrinkPlayerFlags(this, searchFlags);
            } else {
                DenizenAPI.getCurrentInstance().flagManager().shrinkPlayerFlags(this, allFlags);
            }
            return searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("current_step")) {
            String outcome = "null";
            if (attribute.hasContext(1)) {
                try {
                    outcome = DenizenAPI.getCurrentInstance().getSaves().getString("Players." + this.getName() + ".Scripts." + dScript.valueOf(attribute.getContext(1)).getName() + ".Current Step");
                }
                catch (Exception e) {
                    outcome = "null";
                }
            }
            return new Element(outcome).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("money")) {
            if (Depends.economy != null) {
                if (attribute.startsWith("money.currency_singular")) {
                    return new Element(Depends.economy.currencyNameSingular()).getAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("money.currency")) {
                    return new Element(Depends.economy.currencyNamePlural()).getAttribute(attribute.fulfill(2));
                }
                return new Element(Depends.economy.getBalance(this.getOfflinePlayer())).getAttribute(attribute.fulfill(1));
            }
            if (!attribute.hasAlternative()) {
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            }
            return null;
        }
        if (attribute.startsWith("target")) {
            BlockIterator bi;
            int range = 50;
            int attribs = 1;
            if (attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                attribs = 2;
                range = attribute.getIntContext(2);
            }
            List entities = this.getPlayerEntity().getNearbyEntities((double)range, (double)range, (double)range);
            ArrayList<LivingEntity> possibleTargets = new ArrayList<LivingEntity>();
            if (!attribute.hasContext(1)) {
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    possibleTargets.add((LivingEntity)entity);
                }
            } else {
                dList list = dList.getListFor(attribute.getContextObject(1));
                block13: for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    for (dObject obj : list.objectForms) {
                        boolean valid = false;
                        dEntity filterEntity = null;
                        if (obj instanceof dEntity) {
                            filterEntity = (dEntity)obj;
                        } else if (CoreUtilities.toLowerCase(obj.toString()).equals("npc")) {
                            valid = dEntity.isCitizensNPC(entity);
                        } else {
                            filterEntity = dEntity.getEntityFor(obj, attribute.context);
                            if (filterEntity == null) {
                                dB.echoError("Trying to filter 'player.target[...]' tag with invalid input: " + obj.toString());
                                continue;
                            }
                        }
                        if (!valid && filterEntity != null) {
                            valid = filterEntity.isGeneric() ? filterEntity.getBukkitEntityType().equals((Object)entity.getType()) : filterEntity.getUUID().equals(entity.getUniqueId());
                        }
                        if (!valid) continue;
                        possibleTargets.add((LivingEntity)entity);
                        continue block13;
                    }
                }
            }
            try {
                bi = new BlockIterator((LivingEntity)this.getPlayerEntity(), range);
            }
            catch (IllegalStateException e) {
                return null;
            }
            while (bi.hasNext()) {
                Block b = bi.next();
                int bx = b.getX();
                int by = b.getY();
                int bz = b.getZ();
                if (b.getType().isSolid()) break;
                for (LivingEntity possibleTarget : possibleTargets) {
                    Location l = possibleTarget.getLocation();
                    double ex = l.getX();
                    double ey = l.getY();
                    double ez = l.getZ();
                    if (!((double)bx - 0.5 <= ex) || !(ex <= (double)bx + 1.5) || !((double)bz - 0.5 <= ez) || !(ez <= (double)bz + 1.5) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                    return new dEntity((Entity)possibleTarget).getDenizenObject().getAttribute(attribute.fulfill(attribs));
                }
            }
            return null;
        }
        if (attribute.startsWith("list_effects")) {
            dList effects = new dList();
            for (PotionEffect effect : this.getPlayerEntity().getActivePotionEffects()) {
                effects.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "t");
            }
            return effects.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list")) {
            dB.echoError("DO NOT USE PLAYER.LIST AS A TAG, please use <server.list_online_players> and related tags!");
            ArrayList<String> players = new ArrayList<String>();
            if (attribute.startsWith("list.online")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.add(player.getName());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("list.offline")) {
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    if (player.isOnline()) continue;
                    players.add("p@" + player.getUniqueId().toString());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                players.add("p@" + player.getUniqueId().toString());
            }
            return new dList((List<String>)players).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name") && !this.isOnline()) {
            return new Element(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid") && !this.isOnline()) {
            return new Element(this.offlinePlayer.getUniqueId().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Player").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("save_name")) {
            return new Element(this.getSaveName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("bed_spawn")) {
            if (this.getOfflinePlayer().getBedSpawnLocation() == null) {
                return null;
            }
            return new dLocation(this.getOfflinePlayer().getBedSpawnLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location") && !this.isOnline()) {
            return this.getLocation().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world") && !this.isOnline()) {
            return new dWorld(this.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1) && attribute.startsWith("item_cooldown") && (mat = new Element(attribute.getContext(1)).asType(dMaterial.class, attribute.context)) != null) {
            return new Duration((long)this.getPlayerEntity().getCooldown(mat.getMaterial())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("first_played")) {
            if ((attribute = attribute.fulfill(1)).startsWith("milliseconds") || attribute.startsWith("in_milliseconds")) {
                return new Element(this.getOfflinePlayer().getFirstPlayed()).getAttribute(attribute.fulfill(1));
            }
            return new Duration(this.getOfflinePlayer().getFirstPlayed() / 50L).getAttribute(attribute);
        }
        if (attribute.startsWith("has_played_before")) {
            return new Element(true).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("absorption_health")) {
            return new Element(NMSHandler.getInstance().getPlayerHelper().getAbsorption(this.getPlayerEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.is_scaled")) {
            return new Element(this.getPlayerEntity().isHealthScaled()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.scale")) {
            return new Element(this.getPlayerEntity().getHealthScale()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("exhaustion")) {
            return new Element(this.getPlayerEntity().getExhaustion()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("oxygen.max")) {
            return new Duration((long)this.getMaximumAir()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("oxygen")) {
            return new Duration((long)this.getRemainingAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.formatted")) {
            return EntityHealth.getHealthFormatted(new dEntity((Entity)this.getPlayerEntity()), attribute);
        }
        if (attribute.startsWith("health.percentage")) {
            double maxHealth = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHealth = attribute.getIntContext(2);
            }
            return new Element(this.getPlayerEntity().getHealth() / maxHealth * 100.0).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.max")) {
            return new Element(this.getMaxHealth()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.matches("health")) {
            return new Element(this.getHealth()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_banned")) {
            ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(this.getName());
            if (ban == null) {
                return new Element(false).getAttribute(attribute.fulfill(1));
            }
            if (ban.getExpiration() == null) {
                return new Element(true).getAttribute(attribute.fulfill(1));
            }
            return new Element(ban.getExpiration().after(new Date())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_online")) {
            return new Element(this.isOnline()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_op")) {
            return new Element(this.getOfflinePlayer().isOp()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_whitelisted")) {
            return new Element(this.getOfflinePlayer().isWhitelisted()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_played")) {
            if ((attribute = attribute.fulfill(1)).startsWith("milliseconds") || attribute.startsWith("in_milliseconds")) {
                if (this.isOnline()) {
                    return new Element(System.currentTimeMillis()).getAttribute(attribute.fulfill(1));
                }
                return new Element(this.getOfflinePlayer().getLastPlayed()).getAttribute(attribute.fulfill(1));
            }
            if (this.isOnline()) {
                return new Duration(System.currentTimeMillis() / 50L).getAttribute(attribute);
            }
            return new Duration(this.getOfflinePlayer().getLastPlayed() / 50L).getAttribute(attribute);
        }
        if (attribute.startsWith("groups")) {
            if (Depends.permissions == null) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                }
                return null;
            }
            dList list = new dList();
            for (String group : Depends.permissions.getGroups()) {
                if (!Depends.permissions.playerInGroup(null, this.offlinePlayer, group)) continue;
                list.add(group);
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ban_info")) {
            attribute.fulfill(1);
            ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(this.getName());
            if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                return null;
            }
            if (attribute.startsWith("expiration") && ban.getExpiration() != null) {
                return new Duration(ban.getExpiration().getTime() / 50L).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("reason")) {
                return new Element(ban.getReason()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("created")) {
                return new Duration(ban.getCreated().getTime() / 50L).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("source")) {
                return new Element(ban.getSource()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("in_group")) {
            if (Depends.permissions == null) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                }
                return null;
            }
            String group = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                return new Element(Depends.permissions.playerInGroup((World)null, this.getName(), group)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                return new Element(Depends.permissions.playerInGroup(attribute.getContext(2), this.getName(), group)).getAttribute(attribute.fulfill(2));
            }
            if (this.isOnline()) {
                return new Element(Depends.permissions.playerInGroup(this.getPlayerEntity(), group)).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("permission") || attribute.startsWith("has_permission")) {
            String permission = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                return new Element(Depends.permissions.has((World)null, this.getName(), permission)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                return new Element(Depends.permissions.has(attribute.getContext(2), this.getName(), permission)).getAttribute(attribute.fulfill(2));
            }
            if (this.isOnline()) {
                return new Element(this.getPlayerEntity().hasPermission(permission)).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("inventory")) {
            return this.getInventory().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enderchest")) {
            return this.getEnderChest().getAttribute(attribute.fulfill(1));
        }
        if (!this.isOnline()) {
            returned = CoreUtilities.autoPropertyTag(this, attribute);
            if (returned != null) {
                return returned;
            }
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("open_inventory")) {
            return dInventory.mirrorBukkitInventory(this.getPlayerEntity().getOpenInventory().getTopInventory()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("selected_trade_index") && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.getPlayerEntity().getOpenInventory().getTopInventory() instanceof MerchantInventory) {
            return new Element(((MerchantInventory)this.getPlayerEntity().getOpenInventory().getTopInventory()).getSelectedRecipeIndex() + 1).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_on_cursor")) {
            return new dItem(this.getPlayerEntity().getItemOnCursor()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_in_hand.slot")) {
            return new Element(this.getPlayerEntity().getInventory().getHeldItemSlot() + 1).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("sidebar.lines")) {
            sidebar = SidebarCommand.getSidebar(this);
            if (sidebar == null) {
                return null;
            }
            return new dList(sidebar.getLines()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("sidebar.title")) {
            sidebar = SidebarCommand.getSidebar(this);
            if (sidebar == null) {
                return null;
            }
            return new Element(sidebar.getTitle()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("sidebar.scores")) {
            sidebar = SidebarCommand.getSidebar(this);
            if (sidebar == null) {
                return null;
            }
            dList scores = new dList();
            for (int score : sidebar.getScores()) {
                scores.add(String.valueOf(score));
            }
            return scores.getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("sidebar.start")) {
            sidebar = SidebarCommand.getSidebar(this);
            if (sidebar == null) {
                return null;
            }
            return new Element(sidebar.getStart()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("sidebar.increment")) {
            sidebar = SidebarCommand.getSidebar(this);
            if (sidebar == null) {
                return null;
            }
            return new Element(sidebar.getIncrement()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("skin_blob")) {
            return new Element(NMSHandler.getInstance().getProfileEditor().getPlayerSkinBlob(this.getPlayerEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("selected_npc") && this.getPlayerEntity().hasMetadata("selected")) {
            return this.getSelectedNPC().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity") && !attribute.startsWith("entity_")) {
            return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ip") || attribute.startsWith("host_name")) {
            if ((attribute = attribute.fulfill(1)).startsWith("address_only")) {
                return new Element(this.getPlayerEntity().getAddress().toString()).getAttribute(attribute.fulfill(1));
            }
            String host = this.getPlayerEntity().getAddress().getHostName();
            if (attribute.startsWith("address")) {
                return new Element(this.getPlayerEntity().getAddress().toString()).getAttribute(attribute.fulfill(1));
            }
            return new Element(host).getAttribute(attribute);
        }
        if (attribute.startsWith("name.display")) {
            return new Element(this.getPlayerEntity().getDisplayName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name.list")) {
            return new Element(this.getPlayerEntity().getPlayerListName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("nameplate")) {
            return new Element(NMSHandler.getInstance().getProfileEditor().getPlayerName(this.getPlayerEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_finished")) {
            FinishCommand.class.toString();
            dB.echoError("The 'FINISH' command is deprecated. Use flags instead!");
        }
        if (attribute.startsWith("has_failed")) {
            FailCommand.class.toString();
            dB.echoError("The 'FAIL' command is deprecated. Use flags instead!");
        }
        if (attribute.startsWith("compass_target") && (target = this.getPlayerEntity().getCompassTarget()) != null) {
            return new dLocation(target).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chunk_loaded") && attribute.hasContext(1)) {
            dChunk chunk = dChunk.valueOf(attribute.getContext(1));
            if (chunk == null) {
                return null;
            }
            return new Element(this.hasChunkLoaded(chunk.getChunk())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_fly") || attribute.startsWith("allowed_flight")) {
            return new Element(this.getPlayerEntity().getAllowFlight()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fly_speed")) {
            return new Element(this.getPlayerEntity().getFlySpeed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("food_level.formatted")) {
            int foodLevel;
            double maxHunger = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHunger = attribute.getIntContext(2);
            }
            if ((double)(foodLevel = this.getFoodLevel()) / maxHunger < 0.1) {
                return new Element("starving").getAttribute(attribute.fulfill(2));
            }
            if ((double)foodLevel / maxHunger < 0.4) {
                return new Element("famished").getAttribute(attribute.fulfill(2));
            }
            if ((double)foodLevel / maxHunger < 0.75) {
                return new Element("parched").getAttribute(attribute.fulfill(2));
            }
            if ((double)foodLevel / maxHunger < 1.0) {
                return new Element("hungry").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("saturation")) {
            return new Element(this.getPlayerEntity().getSaturation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("food_level")) {
            return new Element(this.getFoodLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode")) {
            if ((attribute = attribute.fulfill(1)).startsWith("id")) {
                return new Element(this.getPlayerEntity().getGameMode().getValue()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getPlayerEntity().getGameMode().name()).getAttribute(attribute);
        }
        if (attribute.startsWith("is_blocking")) {
            return new Element(this.getPlayerEntity().isBlocking()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ping")) {
            return new Element(NMSHandler.getInstance().getPlayerHelper().getPing(this.getPlayerEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flying")) {
            return new Element(this.getPlayerEntity().isFlying()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sleeping")) {
            return new Element(this.getPlayerEntity().isSleeping()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sneaking")) {
            return new Element(this.getPlayerEntity().isSneaking()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sprinting")) {
            return new Element(this.getPlayerEntity().isSprinting()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_achievement")) {
            Achievement ach = Achievement.valueOf((String)attribute.getContext(1).toUpperCase());
            return new Element(this.getPlayerEntity().hasAchievement(ach)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("statistic")) {
            Statistic statistic = Statistic.valueOf((String)attribute.getContext(1).toUpperCase());
            if (statistic == null) {
                return null;
            }
            if (attribute.getAttribute(2).startsWith("qualifier")) {
                dObject obj = ObjectFetcher.pickObjectFor(attribute.getContext(2), attribute.context);
                try {
                    if (obj instanceof dMaterial) {
                        return new Element(this.getPlayerEntity().getStatistic(statistic, ((dMaterial)obj).getMaterial())).getAttribute(attribute.fulfill(2));
                    }
                    if (obj instanceof dEntity) {
                        return new Element(this.getPlayerEntity().getStatistic(statistic, ((dEntity)obj).getBukkitEntityType())).getAttribute(attribute.fulfill(2));
                    }
                    return null;
                }
                catch (Exception e) {
                    dB.echoError("Invalid statistic: " + statistic + " for this player!");
                    return null;
                }
            }
            try {
                return new Element(this.getPlayerEntity().getStatistic(statistic)).getAttribute(attribute.fulfill(1));
            }
            catch (Exception e) {
                dB.echoError("Invalid statistic: " + statistic + " for this player!");
                return null;
            }
        }
        if (attribute.startsWith("time_asleep")) {
            return new Duration(this.getPlayerEntity().getSleepTicks() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time")) {
            return new Element(this.getPlayerEntity().getPlayerTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("walk_speed")) {
            return new Element(this.getPlayerEntity().getWalkSpeed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("weather")) {
            if (this.getPlayerEntity().getPlayerWeather() != null) {
                return new Element(this.getPlayerEntity().getPlayerWeather().name()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("xp.level")) {
            return new Element(this.getPlayerEntity().getLevel()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.to_next_level")) {
            return new Element(this.getPlayerEntity().getExpToLevel()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.total")) {
            return new Element(this.getPlayerEntity().getTotalExperience()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp")) {
            return new Element(this.getPlayerEntity().getExp() * 100.0f).getAttribute(attribute.fulfill(1));
        }
        if (Depends.chat != null) {
            if (attribute.startsWith("chat_prefix")) {
                String prefix = Depends.chat.getPlayerPrefix(this.getWorld().getName(), this.getOfflinePlayer());
                if (prefix == null) {
                    return null;
                }
                return new Element(prefix).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("chat_suffix")) {
                String suffix = Depends.chat.getPlayerSuffix(this.getWorld().getName(), this.getOfflinePlayer());
                if (suffix == null) {
                    return null;
                }
                return new Element(suffix).getAttribute(attribute.fulfill(1));
            }
        }
        if ((returned = CoreUtilities.autoPropertyTag(this, attribute)) != null) {
            return returned;
        }
        return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to a player!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String name;
        String[] split;
        if (mechanism.matches("respawn")) {
            NMSHandler.getInstance().getPacketHelper().respawn(this.getPlayerEntity());
        }
        if (mechanism.matches("vision")) {
            if (mechanism.hasValue() && mechanism.requireEnum(false, (Enum<?>[])EntityType.values())) {
                NMSHandler.getInstance().getPacketHelper().setVision(this.getPlayerEntity(), EntityType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else {
                NMSHandler.getInstance().getPacketHelper().forceSpectate(this.getPlayerEntity(), (Entity)this.getPlayerEntity());
            }
        }
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            this.setLevel(mechanism.getValue().asInt());
        }
        if (mechanism.matches("item_slot") && mechanism.requireInteger()) {
            if (this.isOnline()) {
                this.getPlayerEntity().getInventory().setHeldItemSlot(mechanism.getValue().asInt() - 1);
            } else {
                this.getNBTEditor().setItemInHand(mechanism.getValue().asInt() - 1);
            }
        }
        if (mechanism.matches("item_on_cursor") && mechanism.requireObject(dItem.class)) {
            this.getPlayerEntity().setItemOnCursor(mechanism.valueAsType(dItem.class).getItemStack());
        }
        if (mechanism.matches("award_achievement") && mechanism.requireEnum(false, (Enum<?>[])Achievement.values())) {
            this.getPlayerEntity().awardAchievement(Achievement.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("absorption_health") && mechanism.requireFloat()) {
            NMSHandler.getInstance().getPlayerHelper().setAbsorption(this.getPlayerEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("fake_absorption_health") && mechanism.requireFloat()) {
            NMSHandler.getInstance().getPacketHelper().setFakeAbsorption(this.getPlayerEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("health_scale") && mechanism.requireDouble()) {
            this.getPlayerEntity().setHealthScale(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("scale_health") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setHealthScaled(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("max_health") && mechanism.requireDouble()) {
            this.setMaxHealth(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("health") && mechanism.requireDouble()) {
            this.setHealth(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("resource_pack") || mechanism.matches("texture_pack")) {
            this.getPlayerEntity().setResourcePack(mechanism.getValue().asString());
        }
        if (mechanism.matches("saturation") && mechanism.requireFloat()) {
            this.getPlayerEntity().setSaturation(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("send_map") && mechanism.requireInteger()) {
            MapView map = Bukkit.getServer().getMap((short)mechanism.getValue().asInt());
            if (map != null) {
                this.getPlayerEntity().sendMap(map);
            } else {
                dB.echoError("No map found for ID " + mechanism.getValue().asInt() + "!");
            }
        }
        if (mechanism.matches("food_level") && mechanism.requireInteger()) {
            this.setFoodLevel(mechanism.getValue().asInt());
        }
        if (mechanism.matches("bed_spawn_location") && mechanism.requireObject(dLocation.class)) {
            this.setBedSpawnLocation(mechanism.valueAsType(dLocation.class));
        }
        if (mechanism.matches("can_fly") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setAllowFlight(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fly_speed") && mechanism.requireFloat()) {
            this.setFlySpeed(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("flying") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setFlying(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("sprinting") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setSprinting(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("gamemode") && mechanism.requireEnum(false, (Enum<?>[])GameMode.values())) {
            this.setGameMode(GameMode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("kick")) {
            this.getPlayerEntity().kickPlayer(mechanism.getValue().asString());
        }
        if (mechanism.matches("weather") && mechanism.requireEnum(false, (Enum<?>[])WeatherType.values())) {
            this.getPlayerEntity().setPlayerWeather(WeatherType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("reset_weather")) {
            this.getPlayerEntity().resetPlayerWeather();
        }
        if (mechanism.matches("player_list_name")) {
            this.getPlayerEntity().setPlayerListName(mechanism.getValue().asString());
        }
        if (mechanism.matches("display_name")) {
            this.getPlayerEntity().setDisplayName(mechanism.getValue().asString());
            return;
        }
        if (mechanism.matches("show_workbench") && mechanism.requireObject(dLocation.class)) {
            this.getPlayerEntity().openWorkbench((Location)mechanism.valueAsType(dLocation.class), true);
            return;
        }
        if (mechanism.matches("location") && mechanism.requireObject(dLocation.class)) {
            this.setLocation(mechanism.valueAsType(dLocation.class));
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getPlayerEntity().setPlayerTime((long)mechanism.getValue().asInt(), true);
        }
        if (mechanism.matches("freeze_time")) {
            if (mechanism.requireInteger("Invalid integer specified. Assuming current world time.")) {
                this.getPlayerEntity().setPlayerTime((long)mechanism.getValue().asInt(), false);
            } else {
                this.getPlayerEntity().setPlayerTime(this.getPlayerEntity().getWorld().getTime(), false);
            }
        }
        if (mechanism.matches("reset_time")) {
            this.getPlayerEntity().resetPlayerTime();
        }
        if (mechanism.matches("walk_speed") && mechanism.requireFloat()) {
            this.getPlayerEntity().setWalkSpeed(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("exhaustion") && mechanism.requireFloat()) {
            this.getPlayerEntity().setExhaustion(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("show_entity") && mechanism.requireObject(dEntity.class)) {
            NMSHandler.getInstance().getEntityHelper().unhideEntity(this.getPlayerEntity(), mechanism.valueAsType(dEntity.class).getBukkitEntity());
        }
        if (mechanism.matches("hide_entity")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (split.length > 0 && new Element(split[0]).matchesType(dEntity.class)) {
                    dEntity entity = mechanism.valueAsType(dEntity.class);
                    if (!entity.isSpawned()) {
                        dB.echoError("Can't hide the unspawned entity '" + split[0] + "'!");
                    } else if (split.length > 1 && new Element(split[1]).isBoolean()) {
                        NMSHandler.getInstance().getEntityHelper().hideEntity(this.getPlayerEntity(), entity.getBukkitEntity(), new Element(split[1]).asBoolean());
                    } else {
                        NMSHandler.getInstance().getEntityHelper().hideEntity(this.getPlayerEntity(), entity.getBukkitEntity(), false);
                    }
                } else {
                    dB.echoError("'" + split[0] + "' is not a valid entity!");
                }
            } else {
                dB.echoError("Must specify an entity to hide!");
            }
        }
        if (mechanism.matches("show_boss_bar")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (split.length == 2 && new Element(split[0]).isDouble()) {
                    NMSHandler.getInstance().getPlayerHelper().showSimpleBossBar(this.getPlayerEntity(), split[1], new Element(split[0]).asDouble() * 0.005);
                } else {
                    NMSHandler.getInstance().getPlayerHelper().showSimpleBossBar(this.getPlayerEntity(), split[0], 1.0);
                }
            } else {
                NMSHandler.getInstance().getPlayerHelper().removeSimpleBossBar(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_experience")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (split.length > 0 && new Element(split[0]).isFloat()) {
                    if (split.length > 1 && new Element(split[1]).isInt()) {
                        NMSHandler.getInstance().getPacketHelper().showExperience(this.getPlayerEntity(), new Element(split[0]).asFloat(), new Element(split[1]).asInt());
                    } else {
                        NMSHandler.getInstance().getPacketHelper().showExperience(this.getPlayerEntity(), new Element(split[0]).asFloat(), this.getPlayerEntity().getLevel());
                    }
                } else {
                    dB.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                NMSHandler.getInstance().getPacketHelper().resetExperience(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_health")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]", 3);
                if (split.length > 0 && new Element(split[0]).isFloat()) {
                    if (split.length > 1 && new Element(split[1]).isInt()) {
                        if (split.length > 2 && new Element(split[2]).isFloat()) {
                            NMSHandler.getInstance().getPacketHelper().showHealth(this.getPlayerEntity(), new Element(split[0]).asFloat(), new Element(split[1]).asInt(), new Element(split[2]).asFloat());
                        } else {
                            NMSHandler.getInstance().getPacketHelper().showHealth(this.getPlayerEntity(), new Element(split[0]).asFloat(), new Element(split[1]).asInt(), this.getPlayerEntity().getSaturation());
                        }
                    } else {
                        NMSHandler.getInstance().getPacketHelper().showHealth(this.getPlayerEntity(), new Element(split[0]).asFloat(), this.getPlayerEntity().getFoodLevel(), this.getPlayerEntity().getSaturation());
                    }
                } else {
                    dB.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                NMSHandler.getInstance().getPacketHelper().resetHealth(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_equipment") && !mechanism.getValue().asString().isEmpty()) {
            split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]", 3);
            if (split.length > 0 && new Element(split[0]).matchesType(dEntity.class)) {
                String slot;
                String string = slot = split.length > 1 ? split[1].toUpperCase() : null;
                if (split.length > 1 && (new Element(slot).matchesEnum((Enum[])EquipmentSlot.values()) || slot.equals("MAIN_HAND") || slot.equals("BOOTS"))) {
                    if (split.length > 2 && new Element(split[2]).matchesType(dItem.class)) {
                        if (slot.equals("MAIN_HAND")) {
                            slot = "HAND";
                        } else if (slot.equals("BOOTS")) {
                            slot = "FEET";
                        }
                        NMSHandler.getInstance().getPacketHelper().showEquipment(this.getPlayerEntity(), new Element(split[0]).asType(dEntity.class, mechanism.context).getLivingEntity(), EquipmentSlot.valueOf((String)slot), new Element(split[2]).asType(dItem.class, mechanism.context).getItemStack());
                    } else if (split.length > 2) {
                        dB.echoError("'" + split[2] + "' is not a valid dItem!");
                    }
                } else if (split.length > 1) {
                    dB.echoError("'" + split[1] + "' is not a valid slot; must be HAND, OFF_HAND, BOOTS, LEGS, CHEST, or HEAD!");
                } else {
                    NMSHandler.getInstance().getPacketHelper().resetEquipment(this.getPlayerEntity(), new Element(split[0]).asType(dEntity.class, mechanism.context).getLivingEntity());
                }
            } else {
                dB.echoError("'" + split[0] + "' is not a valid dEntity!");
            }
        }
        if (mechanism.matches("fov_multiplier")) {
            if (mechanism.hasValue() && mechanism.requireFloat()) {
                NMSHandler.getInstance().getPacketHelper().setFieldOfView(this.getPlayerEntity(), mechanism.getValue().asFloat());
            } else {
                NMSHandler.getInstance().getPacketHelper().setFieldOfView(this.getPlayerEntity(), Float.NaN);
            }
        }
        if (mechanism.matches("item_message")) {
            ItemChangeMessage.sendMessage(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("show_endcredits")) {
            NMSHandler.getInstance().getPlayerHelper().showEndCredits(this.getPlayerEntity());
        }
        if (mechanism.matches("show_demo")) {
            NMSHandler.getInstance().getPacketHelper().showDemoScreen(this.getPlayerEntity());
        }
        if (mechanism.matches("spectate") && mechanism.requireObject(dEntity.class)) {
            NMSHandler.getInstance().getPacketHelper().forceSpectate(this.getPlayerEntity(), mechanism.valueAsType(dEntity.class).getBukkitEntity());
        }
        if (mechanism.matches("open_book")) {
            NMSHandler.getInstance().getPacketHelper().openBook(this.getPlayerEntity(), EquipmentSlot.HAND);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && mechanism.matches("open_offhand_book")) {
            NMSHandler.getInstance().getPacketHelper().openBook(this.getPlayerEntity(), EquipmentSlot.OFF_HAND);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && mechanism.matches("show_book") && mechanism.requireObject(dItem.class)) {
            dItem book = mechanism.valueAsType(dItem.class);
            if (!book.getItemStack().hasItemMeta() || !(book.getItemStack().getItemMeta() instanceof BookMeta)) {
                dB.echoError("show_book mechanism must have a book as input.");
                return;
            }
            NMSHandler.getInstance().getPacketHelper().showEquipment(this.getPlayerEntity(), (LivingEntity)this.getPlayerEntity(), EquipmentSlot.OFF_HAND, book.getItemStack());
            NMSHandler.getInstance().getPacketHelper().openBook(this.getPlayerEntity(), EquipmentSlot.OFF_HAND);
            NMSHandler.getInstance().getPacketHelper().showEquipment(this.getPlayerEntity(), (LivingEntity)this.getPlayerEntity(), EquipmentSlot.OFF_HAND, this.getPlayerEntity().getEquipment().getItemInOffHand());
        }
        if (mechanism.matches("edit_sign") && mechanism.requireObject(dLocation.class) && !NMSHandler.getInstance().getPacketHelper().showSignEditor(this.getPlayerEntity(), mechanism.valueAsType(dLocation.class))) {
            dB.echoError("Can't edit non-sign materials!");
        }
        if (mechanism.matches("tab_list_info")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (split.length > 0) {
                    String header = split[0];
                    String footer = "";
                    if (split.length > 1) {
                        footer = split[1];
                    }
                    NMSHandler.getInstance().getPacketHelper().showTabListHeaderFooter(this.getPlayerEntity(), header, footer);
                } else {
                    dB.echoError("Must specify a header and footer to show!");
                }
            } else {
                NMSHandler.getInstance().getPacketHelper().resetTabListHeaderFooter(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("sign_update")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (dLocation.matches(split[0]) && split.length > 1) {
                    dList lines = dList.valueOf(split[1]);
                    this.getPlayerEntity().sendSignChange((Location)dLocation.valueOf(split[0]), lines.toArray(4));
                } else {
                    dB.echoError("Must specify a valid location and at least one sign line!");
                }
            } else {
                dB.echoError("Must specify a valid location and at least one sign line!");
            }
        }
        if (mechanism.matches("banner_update") && mechanism.getValue().asString().length() > 0) {
            split = mechanism.getValue().asString().split("[\\|" + dList.internal_escape + "]");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (split.length > 2) {
                for (int i = 2; i > split.length; ++i) {
                    String string = split[i];
                    try {
                        List<String> splitList = CoreUtilities.split(string, '/', 2);
                        patterns.add(new Pattern(DyeColor.valueOf((String)splitList.get(0).toUpperCase()), PatternType.valueOf((String)splitList.get(1).toUpperCase())));
                        continue;
                    }
                    catch (Exception e) {
                        dB.echoError("Could not apply pattern to banner: " + string);
                    }
                }
            }
            if (dLocation.matches(split[0]) && split.length > 1) {
                DyeColor base;
                dLocation location = dLocation.valueOf(split[0]);
                try {
                    base = DyeColor.valueOf((String)split[1].toUpperCase());
                }
                catch (Exception e) {
                    dB.echoError("Could not apply base color to banner: " + split[1]);
                    return;
                }
                NMSHandler.getInstance().getPacketHelper().showBannerUpdate(this.getPlayerEntity(), location, base, patterns);
            } else {
                dB.echoError("Must specify a valid location and a base color!");
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1) && mechanism.matches("stop_sound")) {
            if (!mechanism.hasValue()) {
                this.getPlayerEntity().stopSound("");
            } else {
                try {
                    this.getPlayerEntity().stopSound("", SoundCategory.valueOf((String)mechanism.getValue().asString().toUpperCase()));
                }
                catch (Exception e) {
                    dB.echoError("Invalid SoundCategory. Must specify a valid name.");
                }
            }
        }
        if (mechanism.matches("action_bar")) {
            NMSHandler.getInstance().getPacketHelper().sendActionBarMessage(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("update_advancements") && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1)) {
            NMSHandler.getInstance().getAdvancementHelper().update(this.getPlayerEntity());
        }
        if (mechanism.matches("name")) {
            name = mechanism.getValue().asString();
            if (name.length() > 16) {
                dB.echoError("Must specify a name with no more than 16 characters.");
            } else {
                NMSHandler.getInstance().getProfileEditor().setPlayerName(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin")) {
            name = mechanism.getValue().asString();
            if (name.length() > 16) {
                dB.echoError("Must specify a name with no more than 16 characters.");
            } else {
                NMSHandler.getInstance().getProfileEditor().setPlayerSkin(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin_blob")) {
            NMSHandler.getInstance().getProfileEditor().setPlayerSkinBlob(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("is_whitelisted") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setWhitelisted(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("is_op") && mechanism.requireBoolean()) {
            this.getOfflinePlayer().setOp(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("money") && mechanism.requireDouble() && Depends.economy != null) {
            double bal = Depends.economy.getBalance(this.getOfflinePlayer());
            double goal = mechanism.getValue().asDouble();
            if (goal > bal) {
                Depends.economy.depositPlayer(this.getOfflinePlayer(), goal - bal);
            } else if (bal > goal) {
                Depends.economy.withdrawPlayer(this.getOfflinePlayer(), bal - goal);
            }
        }
        if (Depends.chat != null) {
            if (mechanism.matches("chat_prefix")) {
                Depends.chat.setPlayerPrefix(this.getPlayerEntity(), mechanism.getValue().asString());
            }
            if (mechanism.matches("chat_suffix")) {
                Depends.chat.setPlayerSuffix(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (!mechanism.fulfilled() && this.isOnline()) {
            new dEntity((Entity)this.getPlayerEntity()).adjust(mechanism);
        }
    }
}

