/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;

public class EntityFramed
implements Property {
    public static final String[] handledTags = new String[]{"framed_item_rotation", "framed_item", "has_framed_item"};
    public static final String[] handledMechs = new String[]{"framed"};
    dEntity item_frame;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntityType() == EntityType.ITEM_FRAME;
    }

    public static EntityFramed getFrom(dObject entity) {
        if (!EntityFramed.describes(entity)) {
            return null;
        }
        return new EntityFramed((dEntity)entity);
    }

    private EntityFramed(dEntity item) {
        this.item_frame = item;
    }

    public boolean hasItem() {
        return this.getItemFrameEntity().getItem() != null && this.getItemFrameEntity().getItem().getType() != Material.AIR;
    }

    public ItemFrame getItemFrameEntity() {
        return (ItemFrame)this.item_frame.getBukkitEntity();
    }

    public void setItem(dItem item) {
        this.getItemFrameEntity().setItem(item.getItemStack());
    }

    public dItem getItem() {
        return new dItem(this.getItemFrameEntity().getItem());
    }

    @Override
    public String getPropertyString() {
        if (this.hasItem()) {
            return this.getItem().identify() + (this.getItemFrameEntity().getRotation() == Rotation.NONE ? "" : '|' + CoreUtilities.toLowerCase(this.getItemFrameEntity().getRotation().name()));
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "framed";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("framed_item_rotation")) {
            return new Element(CoreUtilities.toLowerCase(this.getItemFrameEntity().getRotation().name())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("framed_item")) {
            return this.getItem().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_framed_item")) {
            return new Element(this.hasItem()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("framed")) {
            dList list = mechanism.valueAsType(dList.class);
            if (list.size() == 0) {
                dB.echoError("Missing value for 'framed' mechanism!");
                return;
            }
            if (new Element((String)list.get(0)).matchesType(dItem.class)) {
                this.setItem(new Element((String)list.get(0)).asType(dItem.class, mechanism.context));
            } else {
                dB.echoError("Invalid item '" + (String)list.get(0) + "'");
            }
            if (list.size() > 1 && new Element((String)list.get(1)).matchesEnum((Enum[])Rotation.values())) {
                this.getItemFrameEntity().setRotation(Rotation.valueOf((String)((String)list.get(1)).toUpperCase()));
            }
        }
    }
}

