/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.List;
import java.util.stream.Collectors;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemCanDestroy
implements Property {
    public static final String[] handledTags = new String[]{"can_destroy"};
    public static final String[] handledMechs = new String[]{"can_destroy"};
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemCanDestroy getFrom(dObject item) {
        if (!ItemCanDestroy.describes(item)) {
            return null;
        }
        return new ItemCanDestroy((dItem)item);
    }

    private ItemCanDestroy(dItem item) {
        this.item = item;
    }

    private dList getMaterials() {
        ItemStack itemStack = this.item.getItemStack();
        List<Material> materials = CustomNBT.getNBTMaterials(itemStack, "CanDestroy");
        if (materials != null && !materials.isEmpty()) {
            dList list = new dList();
            for (Material material : materials) {
                list.addObject(dMaterial.getMaterialFrom(material));
            }
            return list;
        }
        return null;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        dList materials;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("can_destroy") && (materials = this.getMaterials()) != null) {
            return materials.getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        dList materials = this.getMaterials();
        return materials != null ? materials.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "can_destroy";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("can_destroy")) {
            if (this.item.getMaterial().getMaterial() == Material.AIR) {
                dB.echoError("Cannot apply NBT to AIR!");
                return;
            }
            ItemStack itemStack = this.item.getItemStack();
            if (mechanism.hasValue()) {
                List<Material> materials = mechanism.valueAsType(dList.class).filter(dMaterial.class, mechanism.context).stream().map(dMaterial::getMaterial).collect(Collectors.toList());
                itemStack = CustomNBT.setNBTMaterials(itemStack, "CanDestroy", materials);
            } else {
                itemStack = CustomNBT.clearNBT(itemStack, "CanDestroy");
            }
            this.item.setItemStack(itemStack);
        }
    }
}

