/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.SlowWarning;

public class LocationTags {
    public SlowWarning locationShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'location' instead of 'l' as a root tag.");

    public LocationTags(Denizen denizen) {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                LocationTags.this.locationTags(event);
            }
        }, "location", "l");
    }

    public void locationTags(ReplaceableTagEvent event) {
        if (!event.matches("location", "l") || event.replaced()) {
            return;
        }
        if (event.matches("l")) {
            this.locationShorthand.warn(event.getScriptEntry());
        }
        dLocation loc = null;
        String context = event.getNameContext();
        if (event.hasNameContext() && dLocation.matches(context)) {
            loc = dLocation.valueOf(context);
        } else if (event.getScriptEntry().hasObject("location")) {
            loc = (dLocation)event.getScriptEntry().getObject("location");
        }
        if (loc == null) {
            return;
        }
        Attribute attribute = event.getAttributes();
        event.setReplaced(loc.getAttribute(attribute.fulfill(1)));
    }
}

