/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.util.HashMap;
import java.util.function.Consumer;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.core.UtilTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class AdjustCommand
extends AbstractCommand {
    public static HashMap<String, Consumer<Mechanism>> specialAdjustables = new HashMap();

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("object")) {
                if (arg.object instanceof dList) {
                    scriptEntry.addObject("object", arg.object);
                    continue;
                }
                if (arg.object instanceof Element) {
                    scriptEntry.addObject("object", dList.valueOf(arg.raw_value));
                    continue;
                }
                scriptEntry.addObject("object", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("mechanism")) {
                if (arg.hasPrefix()) {
                    scriptEntry.addObject("mechanism", new Element(arg.getPrefix().getValue()));
                    scriptEntry.addObject("mechanism_value", arg.asElement());
                    continue;
                }
                scriptEntry.addObject("mechanism", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("object")) {
            throw new InvalidArgumentsException("You must specify an object!");
        }
        if (!scriptEntry.hasObject("mechanism")) {
            throw new InvalidArgumentsException("You must specify a mechanism!");
        }
    }

    public dObject adjust(dObject object, Element mechanismName, Element value, ScriptEntry entry) {
        Mechanism mechanism = new Mechanism(mechanismName, value, entry.entryData.getTagContext());
        return this.adjust(object, mechanism, entry);
    }

    public dObject adjust(dObject object, Mechanism mechanism, ScriptEntry entry) {
        String objectString = object.toString();
        String lowerObjectString = CoreUtilities.toLowerCase(objectString);
        Consumer<Mechanism> specialAdjustable = specialAdjustables.get(lowerObjectString);
        if (specialAdjustable != null) {
            specialAdjustable.accept(mechanism);
            return object;
        }
        if (lowerObjectString.startsWith("def:")) {
            String defName = lowerObjectString.substring("def:".length());
            dObject def = entry.getResidingQueue().getDefinitionObject(defName);
            if (def == null) {
                dB.echoError("Invalid definition name '" + defName + "', cannot adjust");
                return object;
            }
            def = this.adjust(def, mechanism, entry);
            entry.getResidingQueue().addDefinition(defName, def);
            return def;
        }
        if (object instanceof Element && (object = ObjectFetcher.pickObjectFor(objectString, entry.entryData.getTagContext())) instanceof Element) {
            dB.echoError("Unable to determine what object to adjust (missing object notation?), for: " + objectString);
            return object;
        }
        if (!(object instanceof Adjustable)) {
            dB.echoError("'" + objectString + "' is not an adjustable object type.");
            return object;
        }
        ((Adjustable)object).safeAdjust(mechanism);
        return object;
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element mechanism = scriptEntry.getElement("mechanism");
        Element value = scriptEntry.getElement("mechanism_value");
        dList objects = (dList)scriptEntry.getdObject("object");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), objects.debug() + mechanism.debug() + (value == null ? "" : value.debug()));
        }
        dList result = new dList();
        for (dObject object : objects.objectForms) {
            object = this.adjust(object, mechanism, value, scriptEntry);
            if (objects.size() == 1) {
                scriptEntry.addObject("result", object);
            }
            result.addObject(object);
        }
        scriptEntry.addObject("result_list", result);
    }

    static {
        specialAdjustables.put("system", UtilTags::adjustSystem);
    }
}

