/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.core.ContextTags;
import net.aufdemrand.denizencore.tags.core.DefinitionTags;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.tags.core.ListTags;
import net.aufdemrand.denizencore.tags.core.ProcedureScriptTags;
import net.aufdemrand.denizencore.tags.core.QueueTags;
import net.aufdemrand.denizencore.tags.core.ScriptTags;
import net.aufdemrand.denizencore.tags.core.UtilTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class TagManager {
    public static HashMap<String, TagRunnable.RootForm> handlers = new HashMap();
    public static List<OldTagRunner> oldRunners = new ArrayList<OldTagRunner>();
    static HashMap<String, List<ParseableTagPiece>> preCalced = new HashMap();

    public void registerCoreTags() {
        new ListTags();
        new QueueTags();
        new ScriptTags();
        new ContextTags();
        new DefinitionTags();
        new EscapeTags();
        new ProcedureScriptTags();
        new UtilTags();
    }

    public static void registerTagEvents(Object o) {
        for (Method method : o.getClass().getMethods()) {
            if (!method.isAnnotationPresent(TagEvents.class)) continue;
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1 || parameters[0] != ReplaceableTagEvent.class) {
                dB.echoError("Class " + o.getClass().getCanonicalName() + " has a method " + method.getName() + " that is targeted at the event manager but has invalid parameters.");
                break;
            }
            TagManager.registerMethod(method, o);
        }
    }

    public static void registerMethod(Method method, Object o) {
        try {
            method.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "run", MethodType.methodType(OldTagRunner.class, o.getClass()), MethodType.methodType(Void.TYPE, ReplaceableTagEvent.class), lookup.unreflect(method), MethodType.methodType(Void.TYPE, ReplaceableTagEvent.class));
            OldTagRunner runner = site.getTarget().invoke(o);
            oldRunners.add(runner);
        }
        catch (Throwable ex) {
            dB.echoError(ex);
        }
    }

    public static void registerTagHandler(TagRunnable.RootForm run, String ... names) {
        if (names.length == 1) {
            run.name = names[0];
            handlers.put(run.name, run);
        } else {
            for (String name : names) {
                TagRunnable.RootForm rtemp = run.clone();
                rtemp.name = name;
                handlers.put(rtemp.name, rtemp);
            }
        }
    }

    public static void fireEvent(ReplaceableTagEvent event) {
        if (dB.verbose) {
            dB.log("Tag fire: " + event.raw_tag + ", " + event.isInstant() + ", " + event.getAttributes().attributes[0].rawKey.contains("@") + ", " + event.hasAlternative() + "...");
        }
        if (event.getAttributes().attributes[0].rawKey.contains("@")) {
            TagManager.fetchObject(event);
            return;
        }
        TagRunnable.RootForm handler = handlers.get(event.getName());
        if (handler != null) {
            try {
                if (dB.verbose) {
                    dB.log("Tag handle: " + event.raw_tag + " " + handler.name + "...");
                }
                handler.run(event);
                if (event.replaced()) {
                    if (dB.verbose) {
                        dB.log("Tag handle success: " + event.getReplaced());
                    }
                    return;
                }
            }
            catch (Throwable ex) {
                dB.echoError(ex);
            }
        }
        for (OldTagRunner runner : oldRunners) {
            try {
                runner.run(event);
                if (!event.replaced()) continue;
                if (dB.verbose) {
                    dB.log("Tag alt-handle success: " + event.getReplaced());
                }
                return;
            }
            catch (Throwable ex) {
                dB.echoError(ex);
            }
        }
        if (dB.verbose) {
            dB.log("Tag unhandled!");
        }
    }

    public static String cleanOutput(String input) {
        if (input == null) {
            return null;
        }
        char[] data = input.toCharArray();
        block7: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\u0001': {
                    data[i] = 60;
                    continue block7;
                }
                case '\u0002': {
                    data[i] = 62;
                    continue block7;
                }
                case '\u0007': {
                    data[i] = 91;
                    continue block7;
                }
                case '\t': {
                    data[i] = 93;
                    continue block7;
                }
                case '\u0005': {
                    data[i] = 124;
                    continue block7;
                }
            }
        }
        return new String(data);
    }

    public static String cleanOutputFully(String input) {
        if (input == null) {
            return null;
        }
        char[] data = input.toCharArray();
        block9: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\u0001': {
                    data[i] = 60;
                    continue block9;
                }
                case '\u0002': {
                    data[i] = 62;
                    continue block9;
                }
                case '\u2011': {
                    data[i] = 59;
                    continue block9;
                }
                case '\u0007': {
                    data[i] = 91;
                    continue block9;
                }
                case '\t': {
                    data[i] = 93;
                    continue block9;
                }
                case '\u0005': {
                    data[i] = 124;
                    continue block9;
                }
                case '\u00a0': {
                    data[i] = 32;
                    continue block9;
                }
            }
        }
        return new String(data);
    }

    public static String escapeOutput(String input) {
        if (input == null) {
            return null;
        }
        char[] data = input.toCharArray();
        block7: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '<': {
                    data[i] = '\u0001';
                    continue block7;
                }
                case '>': {
                    data[i] = 2;
                    continue block7;
                }
                case '[': {
                    data[i] = 7;
                    continue block7;
                }
                case ']': {
                    data[i] = 9;
                    continue block7;
                }
                case '|': {
                    data[i] = 5;
                    continue block7;
                }
            }
        }
        return new String(data);
    }

    public static void fetchObject(ReplaceableTagEvent event) {
        block8: {
            String object_type = CoreUtilities.toLowerCase(CoreUtilities.split(event.getAttributes().attributes[0].rawKey, '@').get(0));
            Class object_class = ObjectFetcher.getObjectClass(object_type);
            if (object_class == null) {
                if (!event.hasAlternative()) {
                    dB.echoError("Invalid object type! Could not fetch '" + object_type + "'!");
                    event.setReplaced("null");
                }
                return;
            }
            try {
                String tagObjectFull;
                String string = tagObjectFull = event.hasNameContext() ? event.getAttributes().attributes[0].rawKey + '[' + event.getNameContext() + ']' : event.getAttributes().attributes[0].rawKey;
                if (!ObjectFetcher.checkMatch(object_class, tagObjectFull)) {
                    if (!event.hasAlternative()) {
                        dB.echoDebug((Debuggable)event.getScriptEntry(), "Returning null. '" + event.getAttributes().attributes[0].rawKey + "' is an invalid " + object_class.getSimpleName() + ".");
                        event.setReplaced("null");
                    }
                    return;
                }
                Object arg = ObjectFetcher.getObjectFrom(object_class, tagObjectFull, DenizenCore.getImplementation().getTagContext(event.getScriptEntry()));
                if (arg == null) {
                    if (!event.hasAlternative()) {
                        dB.echoError((event.hasNameContext() ? event.getAttributes().attributes[0].rawKey + '[' + event.getNameContext() + ']' : event.getAttributes().attributes[0].rawKey) + " is an invalid dObject!");
                        event.setReplaced("null");
                    }
                    return;
                }
                Attribute attribute = event.getAttributes();
                event.setReplacedObject(CoreUtilities.autoAttrib(arg, attribute.fulfill(1)));
            }
            catch (Exception e) {
                dB.echoError("Uh oh! Report this to the Denizen developers! Err: TagManagerObjectReflection");
                dB.echoError(e);
                if (event.hasAlternative()) break block8;
                event.setReplaced("null");
            }
        }
    }

    public static void executeWithTimeLimit(final ReplaceableTagEvent event, int seconds) {
        DenizenCore.getImplementation().preTagExecute();
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Future<?> future = executor.submit(new Runnable(){

            @Override
            public void run() {
                TagManager.fireEvent(event);
            }
        });
        executor.shutdown();
        try {
            future.get(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            dB.echoError("Tag filling was interrupted!");
        }
        catch (ExecutionException e) {
            dB.echoError(e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            dB.echoError("Tag filling timed out!");
        }
        executor.shutdownNow();
    }

    public static String readSingleTag(String str, TagContext context) {
        ReplaceableTagEvent event = new ReplaceableTagEvent(str, context);
        if (event.isInstant() != context.instant) {
            return String.valueOf('\u0001') + str.replace('<', '\u0001').replace('>', '\u0002') + String.valueOf('\u0002');
        }
        return TagManager.escapeOutput(TagManager.readSingleTagObject(context, event).toString());
    }

    public static dObject readSingleTagObject(ParseableTagPiece tag, TagContext context) {
        if (tag.tagData.isInstant != context.instant) {
            return new Element("<" + tag.content + ">");
        }
        ReplaceableTagEvent event = new ReplaceableTagEvent(tag.tagData, tag.content, context);
        return TagManager.readSingleTagObject(context, event);
    }

    public static dObject readSingleTagObject(TagContext context, ReplaceableTagEvent event) {
        int tT = DenizenCore.getImplementation().getTagTimeout();
        if (dB.verbose) {
            dB.log("Tag read: " + event.raw_tag + ", " + event.isInstant() + ", " + tT + "...");
        }
        if (tT <= 0 || !DenizenCore.getImplementation().shouldDebug(context) && !DenizenCore.getImplementation().tagTimeoutWhenSilent()) {
            TagManager.fireEvent(event);
        } else {
            TagManager.executeWithTimeLimit(event, tT);
        }
        if (!event.replaced() && event.hasAlternative()) {
            event.setReplacedObject(event.getAlternative());
        }
        if (context.debug) {
            DenizenCore.getImplementation().debugTagFill(context, event.toString(), event.getReplaced());
        }
        if (!event.replaced()) {
            dB.echoError(context.entry != null ? context.entry.getResidingQueue() : null, "Tag <" + event.toString() + "> is invalid!");
            return new Element(event.raw_tag);
        }
        return event.getReplacedObj();
    }

    public static dObject parseChainObject(List<ParseableTagPiece> pieces, TagContext context, boolean repush) {
        if (dB.verbose) {
            dB.log("Tag parse chain: " + pieces + "...");
        }
        if (pieces.size() < 2) {
            if (pieces.size() == 0) {
                return new Element("");
            }
            ParseableTagPiece pzero = pieces.get(0);
            if (pzero.isTag) {
                dObject objt = TagManager.readSingleTagObject(pzero, context);
                if (repush) {
                    ParseableTagPiece piece = new ParseableTagPiece();
                    piece.objResult = objt;
                    pieces.set(0, piece);
                }
                return objt;
            }
            if (pzero.objResult != null) {
                return pzero.objResult;
            }
            return new Element(pieces.get((int)0).content);
        }
        StringBuilder helpy = new StringBuilder();
        for (int i = 0; i < pieces.size(); ++i) {
            ParseableTagPiece p = pieces.get(i);
            if (p.isError) {
                dB.echoError(context.entry != null ? context.entry.getResidingQueue() : null, p.content);
                continue;
            }
            if (p.isTag) {
                dObject objt = TagManager.readSingleTagObject(p, context);
                if (repush) {
                    ParseableTagPiece piece = new ParseableTagPiece();
                    piece.objResult = objt;
                    pieces.set(i, piece);
                }
                helpy.append(objt.toString());
                continue;
            }
            if (p.objResult != null) {
                helpy.append(p.objResult.toString());
                continue;
            }
            helpy.append(p.content);
        }
        return new Element(helpy.toString());
    }

    public static String tag(String arg, TagContext context) {
        return TagManager.cleanOutput(TagManager.tagObject(arg, context).toString());
    }

    public static List<ParseableTagPiece> genChain(String arg, ScriptEntry entry) {
        return TagManager.genChain(arg, DenizenCore.getImplementation().getTagContext(entry));
    }

    public static List<ParseableTagPiece> genChain(String arg, TagContext context) {
        if (arg == null) {
            return null;
        }
        List<ParseableTagPiece> pieces = preCalced.get(arg = TagManager.cleanOutput(arg));
        if (pieces != null) {
            return pieces;
        }
        pieces = new ArrayList<ParseableTagPiece>();
        if (arg.indexOf(62) == -1 || arg.length() < 3) {
            ParseableTagPiece txt = new ParseableTagPiece();
            txt.content = arg;
            pieces.add(txt);
            return pieces;
        }
        int[] positions = new int[2];
        positions[0] = -1;
        TagManager.locateTag(arg, positions);
        if (positions[0] == -1) {
            ParseableTagPiece txt = new ParseableTagPiece();
            txt.content = arg;
            pieces.add(txt);
            return pieces;
        }
        String orig = arg;
        while (positions[0] != -1) {
            ParseableTagPiece preText = null;
            if (positions[0] > 0) {
                preText = new ParseableTagPiece();
                preText.content = arg.substring(0, positions[0]);
                pieces.add(preText);
            }
            String tagToProc = arg.substring(positions[0] + 1, positions[1]);
            ParseableTagPiece midTag = new ParseableTagPiece();
            midTag.content = tagToProc;
            midTag.isTag = true;
            midTag.tagData = new ReplaceableTagEvent((String)tagToProc, (TagContext)context).mainRef;
            pieces.add(midTag);
            if (dB.verbose) {
                dB.log("Tag: " + (preText == null ? "<null>" : preText.content) + " ||| " + midTag.content);
            }
            arg = arg.substring(positions[1] + 1);
            TagManager.locateTag(arg, positions);
        }
        if (arg.indexOf(60) != -1) {
            ParseableTagPiece errorNote = new ParseableTagPiece();
            errorNote.isError = true;
            errorNote.content = "Potential issue: inconsistent tag marks in command! (issue snippet: " + arg + "; from: " + orig + ")";
            pieces.add(errorNote);
        }
        if (arg.length() > 0) {
            ParseableTagPiece postText = new ParseableTagPiece();
            postText.content = arg;
            pieces.add(postText);
        }
        if (dB.verbose) {
            dB.log("Tag chainify complete: " + arg);
        }
        return pieces;
    }

    public static dObject tagObject(String arg, TagContext context) {
        return TagManager.parseChainObject(TagManager.genChain(arg, context), context, false);
    }

    public static int findColonNotTagNorSpace(String arg) {
        if (arg.indexOf(58) == -1) {
            return -1;
        }
        char[] arr = arg.toCharArray();
        int bracks = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '<') {
                ++bracks;
                continue;
            }
            if (arr[i] == '>') {
                --bracks;
                continue;
            }
            if (arr[i] == ':' && bracks == 0) {
                return i;
            }
            if (arr[i] != ' ' || bracks != 0) continue;
            return -1;
        }
        return -1;
    }

    private static void locateTag(String arg, int[] holder) {
        int first;
        holder[0] = first = arg.indexOf(60);
        if (first == -1) {
            return;
        }
        int len = arg.length();
        if (first + 1 < len && arg.charAt(first + 1) == '-') {
            TagManager.locateTag(arg.substring(0, first) + '\u0001' + arg.substring(first + 1), holder);
            return;
        }
        int bracks = 1;
        for (int i = first + 1; i < len; ++i) {
            if (arg.charAt(i) == '<') {
                ++bracks;
                continue;
            }
            if (arg.charAt(i) != '>' || --bracks != 0) continue;
            holder[1] = i;
            return;
        }
        holder[0] = -1;
    }

    public static List<dObject> fillArgumentsObjects(List<String> args, TagContext context) {
        if (dB.verbose) {
            dB.log("Fill argument objects (old): " + args + ", " + context.instant + "...");
        }
        ArrayList<dObject> filledArgs = new ArrayList<dObject>();
        int nested_level = 0;
        if (args != null) {
            for (String argument : args) {
                if (argument.equals("{")) {
                    ++nested_level;
                }
                if (argument.equals("}")) {
                    --nested_level;
                }
                if (nested_level < 1) {
                    filledArgs.add(TagManager.tagObject(argument, context));
                    continue;
                }
                filledArgs.add(new Element(argument));
            }
        }
        return filledArgs;
    }

    public static void fillArgumentsObjects(List<dObject> args, List<String> strArgs, List<ScriptEntry.Argument> pieceHelp, List<aH.Argument> aHArgs, boolean repush, TagContext context, int[] targets) {
        if (dB.verbose) {
            dB.log("Fill argument objects: " + args + ", " + context.instant + ", " + targets.length + "...");
        }
        for (int argId : targets) {
            aH.Argument aharg = aHArgs.get(argId);
            if (!aharg.needsFill && !aharg.hasSpecialPrefix) continue;
            ScriptEntry.Argument piece = pieceHelp.get(argId);
            if (piece.prefix != null) {
                if (piece.prefix.aHArg.needsFill) {
                    aharg.prefix = TagManager.parseChainObject(piece.prefix.value, context, repush).toString();
                    aharg.lower_prefix = CoreUtilities.toLowerCase(aharg.prefix);
                }
                if (aharg.needsFill) {
                    aharg.object = TagManager.parseChainObject(piece.value, context, repush);
                }
                String fullx = aharg.prefix + ":" + aharg.object.toString();
                args.set(argId, new Element(fullx));
                strArgs.set(argId, fullx);
                continue;
            }
            dObject created = TagManager.parseChainObject(piece.value, context, repush);
            args.set(argId, created);
            strArgs.set(argId, created.toString());
            aharg.object = created;
            aharg.prefix = null;
            aharg.lower_prefix = null;
        }
    }

    public static List<String> fillArguments(List<String> args, TagContext context) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        int nested_level = 0;
        if (args != null) {
            for (String argument : args) {
                if (argument.equals("{")) {
                    ++nested_level;
                }
                if (argument.equals("}")) {
                    --nested_level;
                }
                if (nested_level < 1) {
                    filledArgs.add(TagManager.tag(argument, context));
                    continue;
                }
                filledArgs.add(argument);
            }
        }
        return filledArgs;
    }

    public static List<String> fillArguments(String[] args, TagContext context) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        if (args != null) {
            for (String argument : args) {
                filledArgs.add(TagManager.tag(argument, context));
            }
        }
        return filledArgs;
    }

    public static class ParseableTagPiece {
        public String content;
        public dObject objResult = null;
        public boolean isTag = false;
        public boolean isError = false;
        public ReplaceableTagEvent.ReferenceData tagData = null;

        public String toString() {
            return "(" + this.isError + ", " + this.isTag + ", " + (this.isTag ? this.tagData.isInstant + ", " + this.tagData.rawTag : "") + ", " + this.content + "," + this.objResult + ")";
        }
    }

    @FunctionalInterface
    public static interface OldTagRunner {
        public void run(ReplaceableTagEvent var1);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TagEvents {
    }
}

