/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.util.BlockIterator;

public class ProjectileHitsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ProjectileHitsScriptEvent instance;
    public dEntity projectile;
    public dEntity shooter;
    public dLocation location;
    private dMaterial material;
    public ProjectileHitEvent event;

    public ProjectileHitsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("hits") || cmd.equals("shoots");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        String pTest = "";
        if (cmd.equals("hits")) {
            pTest = path.eventArgLowerAt(0);
        } else if (cmd.equals("shoots") && path.eventArgLowerAt(3).equals("with")) {
            pTest = path.eventArgLowerAt(4);
        }
        if (!(pTest.isEmpty() || pTest.equals("projectile") || this.tryEntity(this.projectile, pTest))) {
            return false;
        }
        if (!this.tryMaterial(this.material, path.eventArgLowerAt(2))) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "ProjectileHits";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.shooter != null && this.shooter.isPlayer() ? dEntity.getPlayerFrom((Entity)this.event.getEntity()) : null, this.shooter != null && this.shooter.isCitizensNPC() ? dEntity.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("projectile")) {
            return this.projectile.getDenizenObject();
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("shooter") && this.shooter != null) {
            return this.shooter.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onProjectileHits(ProjectileHitEvent event) {
        this.projectile = new dEntity((Entity)event.getEntity());
        if (this.projectile.getLocation() == null) {
            return;
        }
        if (Double.isNaN(this.projectile.getLocation().getDirection().normalize().getX())) {
            return;
        }
        Block block = null;
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
            block = event.getHitBlock();
        } else {
            try {
                BlockIterator bi = new BlockIterator(this.projectile.getLocation().getWorld(), this.projectile.getLocation().toVector(), this.projectile.getLocation().getDirection().normalize(), 0.0, 4);
                while (bi.hasNext() && (block = bi.next()).getType() != Material.AIR) {
                }
            }
            catch (IllegalStateException ex) {
                return;
            }
        }
        if (block == null) {
            return;
        }
        this.material = new dMaterial(block);
        this.shooter = this.projectile.getShooter();
        this.location = new dLocation(block.getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

