/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalCreateScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PortalCreateScriptEvent instance;
    public dWorld world;
    public Element reason;
    public dList blocks;
    public PortalCreateEvent event;

    public PortalCreateScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("portal created");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String rCheck;
        String string = rCheck = path.eventArgLowerAt(2).equals("because") ? path.eventArgLowerAt(3) : path.eventArgLowerAt(5);
        if (rCheck.length() > 0 && !rCheck.equals(CoreUtilities.toLowerCase(this.reason.asString()))) {
            return false;
        }
        return this.runInCheck(path, dLocation.valueOf((String)this.blocks.get(0)));
    }

    @Override
    public String getName() {
        return "PortalCreate";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        if (name.equals("blocks")) {
            return this.blocks;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPortalCreate(PortalCreateEvent event) {
        this.world = new dWorld(event.getWorld());
        this.reason = new Element(event.getReason().toString());
        this.blocks = new dList();
        for (Block block : event.getBlocks()) {
            this.blocks.add(new dLocation(block.getLocation()).identify());
        }
        this.event = event;
        this.fire((Event)event);
    }
}

