/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.HashMap;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.abstracts.ModernBlockData;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.properties.material.MaterialAge;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.blocks.OldMaterialsHelper;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.material.MaterialData;

public class dMaterial
implements dObject,
Adjustable {
    private String forcedIdentity = null;
    private String forcedIdentityLow = null;
    public static TagContext noDebugContext = new BukkitTagContext(null, null, false, null, false, null);
    private Material material;
    private Byte data = 0;
    private ModernBlockData modernData;
    String prefix = "material";
    public static HashMap<String, TagRunnable> registeredTags = new HashMap();

    public dMaterial forceIdentifyAs(String string) {
        this.forcedIdentity = string;
        this.forcedIdentityLow = CoreUtilities.toLowerCase(string);
        return this;
    }

    public static dMaterial valueOf(String string) {
        return dMaterial.valueOf(string, null);
    }

    @Fetchable(value="m")
    public static dMaterial valueOf(String string, TagContext context) {
        Material m;
        if (ObjectFetcher.DESCRIBED_PATTERN.matcher(string).matches()) {
            return ObjectFetcher.getObjectFrom(dMaterial.class, string, context);
        }
        if ((string = string.toUpperCase()).startsWith("M@")) {
            string = string.substring("M@".length());
        }
        if (string.equals("RANDOM")) {
            return OldMaterialsHelper.getMaterialFrom(Material.values()[CoreUtilities.getRandom().nextInt(Material.values().length)]);
        }
        int index = string.indexOf(44);
        if (index < 0) {
            index = string.indexOf(58);
        }
        int data = 0;
        if (index >= 0) {
            data = aH.getIntegerFrom(string.substring(index + 1));
            string = string.substring(0, index);
        }
        if ((m = Material.getMaterial((String)string)) == null && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && (m = Material.getMaterial((String)string, (boolean)true)) != null) {
            m = Bukkit.getUnsafe().fromLegacy(m);
            if (context == null || context.debug) {
                net.aufdemrand.denizen.utilities.debugging.dB.log("'" + string + "' is a legacy (pre-1.13) material name. It is now '" + m.name() + "'.");
            }
        }
        if (m != null) {
            if (index >= 0) {
                if (context == null || context.debug) {
                    net.aufdemrand.denizen.utilities.debugging.dB.log("Material ID and data magic number support is deprecated and WILL be removed in a future release. Use relevant properties instead.");
                }
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                return new dMaterial(m);
            }
            return OldMaterialsHelper.getMaterialFrom(m, data);
        }
        dMaterial mat = OldMaterialsHelper.all_dMaterials.get(string);
        if (mat != null) {
            if ((context == null || context.debug) && index >= 0) {
                net.aufdemrand.denizen.utilities.debugging.dB.log("Material ID and data magic number support is deprecated and WILL be removed in a future release. Use relevant properties instead.");
            }
            if (data == 0) {
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                    return new dMaterial(mat.material);
                }
                return mat;
            }
            return OldMaterialsHelper.getMaterialFrom(mat.material, data);
        }
        int matid = aH.getIntegerFrom(string);
        if (matid != 0) {
            if (context != noDebugContext) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("Material ID and data magic number support is deprecated and WILL be removed in a future release. Use material names instead.");
            }
            if ((m = OldMaterialsHelper.getLegacyMaterial(matid)) != null) {
                return OldMaterialsHelper.getMaterialFrom(m, data);
            }
        }
        return null;
    }

    public static dMaterial quickOfNamed(String string) {
        Material m;
        int index = (string = string.toUpperCase()).indexOf(44);
        if (index < 0) {
            index = string.indexOf(58);
        }
        int data = 0;
        if (index >= 0) {
            data = aH.getIntegerFrom(string.substring(index + 1));
            string = string.substring(0, index);
        }
        if ((m = Material.getMaterial((String)string)) != null) {
            return OldMaterialsHelper.getMaterialFrom(m, data);
        }
        dMaterial mat = OldMaterialsHelper.all_dMaterials.get(string);
        if (mat != null) {
            if (data == 0) {
                return mat;
            }
            return OldMaterialsHelper.getMaterialFrom(mat.material, data);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return dMaterial.valueOf(arg, noDebugContext) != null;
    }

    public boolean equals(Object object) {
        if (object instanceof dMaterial) {
            return this.getMaterial() == ((dMaterial)object).getMaterial() && this.getData((byte)0) == ((dMaterial)object).getData((byte)0);
        }
        dMaterial parsed = dMaterial.valueOf(object.toString());
        return this.equals(parsed);
    }

    public boolean matchesBlock(Block b) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            return this.getMaterial() == b.getType();
        }
        return this.matchesMaterialData(b.getType().getNewData(b.getData()));
    }

    public dMaterial(Material material, int data) {
        this.material = material;
        this.data = data < 0 ? null : Byte.valueOf((byte)data);
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && material.isBlock()) {
            this.modernData = new ModernBlockData(material);
        }
    }

    public dMaterial(Material material) {
        this(material, 0);
    }

    public dMaterial(BlockState state) {
        this.material = state.getType();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            this.modernData = new ModernBlockData(state);
        } else {
            this.data = state.getRawData();
        }
    }

    public dMaterial(BlockData block) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            this.modernData = block.modern();
            this.material = this.modernData.getMaterial();
        } else {
            this.material = block.getMaterial();
            this.data = block.getData();
        }
    }

    public dMaterial(Block block) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            this.modernData = new ModernBlockData(block);
            this.material = this.modernData.getMaterial();
        } else {
            this.material = block.getType();
            this.data = block.getData();
        }
    }

    public dMaterial(ModernBlockData data) {
        this.modernData = data;
        this.material = data.getMaterial();
    }

    public boolean hasModernData() {
        return this.modernData != null;
    }

    public ModernBlockData getModernData() {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
            return this.modernData;
        }
        throw new IllegalStateException("Modern block data handler is not available prior to MC 1.13.");
    }

    public void setModernData(ModernBlockData data) {
        this.modernData = data;
    }

    public Material getMaterial() {
        return this.material;
    }

    public BlockData getNmsBlockData() {
        if (this.modernData != null) {
            return NMSHandler.getInstance().getBlockHelper().getBlockData(this.modernData);
        }
        return NMSHandler.getInstance().getBlockHelper().getBlockData(this.getMaterial(), this.getData((byte)0));
    }

    public String name() {
        return this.material.name();
    }

    public byte getData(byte fallback) {
        if (this.data == null) {
            return fallback;
        }
        return this.data;
    }

    public Byte getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean matchesMaterialData(MaterialData data) {
        if (this.hasData()) {
            return this.material == data.getItemType() && this.data.byteValue() == data.getData();
        }
        return this.material == data.getItemType();
    }

    public MaterialData getMaterialData() {
        return new MaterialData(this.material, this.data != null ? this.data : (byte)0);
    }

    public boolean isStructure() {
        if (this.material == Material.CHORUS_PLANT) {
            return true;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && (this.material == Material.RED_MUSHROOM_BLOCK || this.material == Material.BROWN_MUSHROOM_BLOCK)) {
            return true;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12_R1)) {
            if (this.material == Material.RED_MUSHROOM || this.material == Material.BROWN_MUSHROOM) {
                return true;
            }
            String name = this.material.name();
            return name.equals("SAPLING") || name.equals("HUGE_MUSHROOM_1") || name.equals("HUGE_MUSHROOM_2");
        }
        return false;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "Material";
    }

    @Override
    public String identify() {
        return "m@" + this.identifyNoIdentifier();
    }

    public String identifyFull() {
        return "m@" + this.identifyFullNoIdentifier();
    }

    @Override
    public String identifySimple() {
        return "m@" + this.identifySimpleNoIdentifier();
    }

    public String identifyNoPropertiesNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12_R1) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String identifyNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12_R1) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name()) + PropertyParser.getPropertiesString(this);
    }

    public String identifySimpleNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    public String identifyFullNoIdentifier() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow + (this.getData() != null ? "," + this.getData() : "");
        }
        if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_12_R1) && this.getData() != null && this.getData() > 0) {
            return CoreUtilities.toLowerCase(this.material.name()) + "," + this.getData();
        }
        return CoreUtilities.toLowerCase(this.material.name()) + PropertyParser.getPropertiesString(this);
    }

    public String toString() {
        return this.identify();
    }

    public String realName() {
        if (this.forcedIdentity != null) {
            return this.forcedIdentityLow;
        }
        return CoreUtilities.toLowerCase(this.material.name());
    }

    @Override
    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        dMaterial.registerTag("id", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("Material ID and data magic number support is deprecated and WILL be removed in a future release. Use material names instead.");
                return new Element(((dMaterial)object).material.getId()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("data", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (attribute.context == null || attribute.context.debug) {
                    net.aufdemrand.denizen.utilities.debugging.dB.log("Material ID and data magic number support is deprecated and WILL be removed in a future release. Use relevant properties instead.");
                }
                return new Element(((dMaterial)object).getData()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_ageable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(MaterialAge.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_plant", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(MaterialAge.describes(object)).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("has_gravity", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.hasGravity()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_block", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isBlock()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_burnable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isBurnable()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_edible", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isEdible()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_flammable", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isFlammable()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_occluding", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isOccluding()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_record", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isRecord()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_solid", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isSolid()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_transparent", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.isTransparent()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("max_durability", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.getMaxDurability()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("block_resistance", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dMaterial material = (dMaterial)object;
                if (!NMSHandler.getInstance().getBlockHelper().hasBlock(material.getMaterial())) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("Provided material does not have a placeable block.");
                    return null;
                }
                return new Element(NMSHandler.getInstance().getBlockHelper().getBlockResistance(material.getMaterial())).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("hardness", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dMaterial material = (dMaterial)object;
                if (!material.getMaterial().isBlock()) {
                    net.aufdemrand.denizen.utilities.debugging.dB.echoError("Provided material does not have a placeable block.");
                    return null;
                }
                return new Element(material.getMaterial().getHardness()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("max_stack_size", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.getMaxStackSize()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("is_made_of", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dMaterial compared = dMaterial.valueOf(attribute.getContext(1));
                return new Element(compared != null && ((dMaterial)object).material == compared.getMaterial()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("bukkit_enum", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).material.name()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("name", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element(((dMaterial)object).forcedIdentity != null ? ((dMaterial)object).forcedIdentityLow : CoreUtilities.toLowerCase(((dMaterial)object).material.name())).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("full", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                if (((dMaterial)object).hasData()) {
                    return new Element(((dMaterial)object).identifyFull()).getAttribute(attribute.fulfill(1));
                }
                return new Element(((dMaterial)object).identify()).getAttribute(attribute.fulfill(1));
            }
        });
        dMaterial.registerTag("item", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                dMaterial material = (dMaterial)object;
                dItem item = new dItem(material, 1);
                attribute = attribute.fulfill(1);
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2)) {
                    if (!attribute.isComplete()) {
                        String tag = attribute.getAttribute(1);
                        String returned = CoreUtilities.autoPropertyTag(object, attribute);
                        if (returned != null) {
                            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Usage of outdated 'material.item." + tag + "' tag should be replaced by 'material." + tag + "' (with '.item' removed).");
                            return returned;
                        }
                    }
                    if (item.getItemStack().hasItemMeta() && item.getItemStack().getItemMeta() instanceof BlockStateMeta) {
                        ((BlockStateMeta)item.getItemStack().getItemMeta()).setBlockState(material.modernData.getBlockState());
                    }
                }
                return item.getAttribute(attribute);
            }
        });
        dMaterial.registerTag("type", new TagRunnable(){

            @Override
            public String run(Attribute attribute, dObject object) {
                return new Element("Material").getAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredTags.put(name, runnable);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable tr = registeredTags.get(attrLow);
        if (tr != null) {
            if (!tr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + tr.name + "': '" + attrLow + "'.");
            }
            return tr.run(attribute, this);
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute.fulfill(0));
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (!mechanism.isProperty && mechanism.matches("block_resistance") && mechanism.requireFloat() && !NMSHandler.getInstance().getBlockHelper().setBlockResistance(this.material, mechanism.getValue().asFloat())) {
            net.aufdemrand.denizen.utilities.debugging.dB.echoError("Provided material does not have a placeable block.");
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

