/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.debugging;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.CommandExecuter;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class dB {
    public static boolean showDebug = true;
    public static boolean showStackTraces = true;
    public static boolean showColor = true;
    public static boolean debugOverride = false;
    public static boolean showSources = false;
    public static List<String> filter = new ArrayList<String>();
    public static boolean shouldTrim = true;
    public static boolean record = false;
    public static StringBuilder Recording = new StringBuilder();
    static long depthCorrectError = 0L;
    private static boolean throwErrorEvent = true;
    private static final Map<Class<?>, String> classNameCache = new WeakHashMap();
    private static boolean canGetClass = true;

    public static void toggle() {
        showDebug = !showDebug;
    }

    public static Consumer<String> getDebugSender(Debuggable caller) {
        if (caller == null) {
            caller = CommandExecuter.currentQueue;
        }
        if (caller instanceof TagContext && ((TagContext)caller).entry != null) {
            caller = ((TagContext)caller).entry;
        }
        if (caller instanceof ScriptEntry && ((ScriptEntry)caller).getResidingQueue() != null) {
            caller = ((ScriptEntry)caller).getResidingQueue();
        }
        if (caller instanceof ScriptQueue) {
            return ((ScriptQueue)caller).debugOutput;
        }
        return null;
    }

    public static void report(Debuggable caller, String name, String report) {
        if (!showDebug || !dB.shouldDebug(caller)) {
            return;
        }
        dB.echo("<Y>+> <G>Executing '<Y>" + name + "<G>': " + dB.trimMessage(report), caller);
        if (caller instanceof ScriptEntry && ((BukkitScriptEntryData)((ScriptEntry)caller).entryData).hasPlayer() && FlagManager.playerHasFlag(((BukkitScriptEntryData)((ScriptEntry)caller).entryData).getPlayer(), "show_command_reports")) {
            String message = "<Y>+> <G>Executing '<Y>" + name + "<G>': " + dB.trimMessage(report);
            ((BukkitScriptEntryData)((ScriptEntry)caller).entryData).getPlayer().getPlayerEntity().sendRawMessage(message.replace("<Y>", ChatColor.YELLOW.toString()).replace("<G>", ChatColor.DARK_GRAY.toString()).replace("<A>", ChatColor.AQUA.toString()).replace("<R>", ChatColor.DARK_RED.toString()).replace("<W>", ChatColor.WHITE.toString()));
        }
    }

    public static void echoDebug(Debuggable caller, dB.DebugElement element) {
        if (!showDebug || !dB.shouldDebug(caller)) {
            return;
        }
        dB.echoDebug(caller, element, null);
    }

    public static void echoDebug(Debuggable caller, dB.DebugElement element, String string) {
        if (!showDebug || !dB.shouldDebug(caller)) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(string).append(" ---------+");
            }
        }
        dB.echo(sb.toString(), caller);
    }

    public static void echoDebug(Debuggable caller, String message) {
        if (!showDebug || !dB.shouldDebug(caller)) {
            return;
        }
        dB.echo(ChatColor.LIGHT_PURPLE + " " + ChatColor.WHITE + dB.trimMessage(message), caller);
        if (net.aufdemrand.denizencore.utilities.debugging.dB.verbose && caller != null) {
            dB.echo(ChatColor.GRAY + "(Verbose) Caller = " + caller, caller);
        }
    }

    public static void echoApproval(String message) {
        if (!showDebug) {
            return;
        }
        dB.finalOutputDebugText(ChatColor.LIGHT_PURPLE + " " + ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + message, null);
    }

    public static void echoError(String message) {
        dB.echoError(null, message);
    }

    public static void echoError(ScriptQueue source, String message) {
        if (source == null) {
            source = CommandExecuter.currentQueue;
        }
        dScript script = null;
        if (source != null && source.getEntries().size() > 0 && source.getEntries().get(0).getScript() != null) {
            script = source.getEntries().get(0).getScript();
        } else if (source != null && source.getLastEntryExecuted() != null && source.getLastEntryExecuted().getScript() != null) {
            script = source.getLastEntryExecuted().getScript();
        }
        if (throwErrorEvent) {
            throwErrorEvent = false;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("message", new Element(message));
            if (source != null) {
                context.put("queue", source);
            }
            if (script != null) {
                context.put("script", script);
            }
            ArrayList<String> events = new ArrayList<String>();
            events.add("script generates error");
            if (script != null) {
                events.add(script.identifySimple() + " generates error");
            }
            ScriptEntry entry = source != null ? source.getLastEntryExecuted() : null;
            List<String> Determinations = OldEventManager.doEvents(events, entry != null ? entry.entryData : new BukkitScriptEntryData(null, null), context, true);
            throwErrorEvent = true;
            for (String Determination : Determinations) {
                if (!Determination.equalsIgnoreCase("CANCELLED")) continue;
                return;
            }
        }
        if (!showDebug) {
            return;
        }
        String fullMessage = ChatColor.LIGHT_PURPLE + " " + ChatColor.RED + "ERROR" + (script != null ? " in script '" + script.getName() + "'" : "") + (source != null ? " in queue '" + source.id + "'" : "") + "! " + ChatColor.WHITE + message;
        if (script != null && !script.getContainer().shouldDebug()) {
            fullMessage = fullMessage + ChatColor.GRAY + " ... " + ChatColor.RED + "Enable debug on the script for more information.";
        }
        dB.finalOutputDebugText(fullMessage, source);
        if (net.aufdemrand.denizencore.utilities.debugging.dB.verbose && depthCorrectError == 0L) {
            ++depthCorrectError;
            try {
                throw new RuntimeException("Verbose info for above error");
            }
            catch (Throwable e) {
                dB.echoError(source, e);
                --depthCorrectError;
            }
        }
    }

    public static void echoError(Throwable ex) {
        dB.echoError(null, ex);
    }

    public static void echoError(ScriptQueue source, Throwable ex) {
        if (source == null) {
            source = CommandExecuter.currentQueue;
        }
        if (throwErrorEvent) {
            throwErrorEvent = false;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            Throwable thrown = ex;
            if (ex.getCause() != null) {
                thrown = ex.getCause();
            }
            context.put("message", new Element(thrown.getMessage()));
            context.put("type", new Element(thrown.getClass().getSimpleName()));
            context.put("queue", source);
            ScriptEntry entry = source != null ? source.getLastEntryExecuted() : null;
            List<String> Determinations = OldEventManager.doEvents(Arrays.asList("server generates exception"), entry == null ? new BukkitScriptEntryData(null, null) : entry.entryData, context);
            throwErrorEvent = true;
            for (String Determination : Determinations) {
                if (!Determination.equalsIgnoreCase("CANCELLED")) continue;
                return;
            }
        }
        if (!showDebug) {
            return;
        }
        boolean wasThrown = throwErrorEvent;
        throwErrorEvent = false;
        if (!showStackTraces) {
            dB.echoError(source, "Exception! Enable '/denizen debug -s' for the nitty-gritty.");
        } else {
            dB.echoError(source, "Internal exception was thrown!");
            StringBuilder errorMesage = new StringBuilder();
            String prefix = "[Error Continued] ";
            boolean first = true;
            while (ex != null) {
                errorMesage.append(prefix + (first ? "" : "Caused by: ") + ex.toString() + "\n");
                for (StackTraceElement ste : ex.getStackTrace()) {
                    errorMesage.append(prefix + ste.toString() + "\n");
                }
                if (ex.getCause() == ex) break;
                ex = ex.getCause();
                first = false;
            }
            dScript script = null;
            if (source != null && source.getEntries().size() > 0 && source.getEntries().get(0).getScript() != null) {
                script = source.getEntries().get(0).getScript();
            }
            dB.finalOutputDebugText(ChatColor.LIGHT_PURPLE + " " + ChatColor.RED + "ERROR" + (script != null ? " in script '" + script.getName() + "'" : "") + (source != null ? " in queue '" + source.id + "'" : "") + "! " + ChatColor.WHITE + errorMesage.toString(), source, false);
        }
        throwErrorEvent = wasThrown;
    }

    public static void log(String message) {
        if (!showDebug) {
            return;
        }
        String callerName = "<JVM-Block>";
        try {
            if (canGetClass) {
                Class[] classes = new SecurityManagerTrick().getClassContext();
                Class caller = classes.length > 2 ? classes[2] : dB.class;
                callerName = classNameCache.get(caller);
                if (callerName == null) {
                    callerName = caller.getSimpleName();
                    classNameCache.put(caller, callerName);
                }
                callerName = callerName.length() > 16 ? callerName.substring(0, 12) + "..." : callerName;
            }
        }
        catch (Throwable ex) {
            canGetClass = false;
        }
        dB.finalOutputDebugText(ChatColor.YELLOW + "+> [" + callerName + "] " + ChatColor.WHITE + dB.trimMessage(message), null);
    }

    public static void log(dB.DebugElement element, String string) {
        if (!showDebug) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(string).append(" ---------+");
                break;
            }
        }
        dB.finalOutputDebugText(sb.toString(), null);
    }

    private static String trimMessage(String message) {
        if (!shouldTrim) {
            return message;
        }
        int trimSize = Settings.trimLength();
        if (message.length() > trimSize) {
            message = message.substring(0, trimSize - 1) + "... * snip! *";
        }
        return message;
    }

    public static boolean shouldDebug(Debuggable caller) {
        boolean should_send;
        block7: {
            if (debugOverride) {
                return true;
            }
            if (!showDebug) {
                return false;
            }
            should_send = true;
            if (caller != null) {
                try {
                    if (filter.isEmpty()) {
                        should_send = caller.shouldDebug();
                        break block7;
                    }
                    should_send = false;
                    for (String criteria : filter) {
                        if (!caller.shouldFilter(criteria)) continue;
                        should_send = true;
                        break;
                    }
                }
                catch (Exception e) {
                    should_send = true;
                }
            }
        }
        return should_send;
    }

    private static void echo(String string, Debuggable caller) {
        if (dB.shouldDebug(caller)) {
            if (showSources && caller != null) {
                ScriptEntry sent;
                String callerId = caller instanceof ScriptContainer ? "Script:" + ((ScriptContainer)caller).getName() : (caller instanceof ScriptEntry ? (((ScriptEntry)caller).getScript() != null ? "Command:" + ((ScriptEntry)caller).getCommandName() + " in Script:" + ((ScriptEntry)caller).getScript().getName() : "Command:" + ((ScriptEntry)caller).getCommandName()) : (caller instanceof ScriptQueue ? (((ScriptQueue)caller).script != null ? "Queue:" + ((ScriptQueue)caller).id + " running Script:" + ((ScriptQueue)caller).script.getName() : "Queue:" + ((ScriptQueue)caller).id) : (caller instanceof TagContext ? (((TagContext)caller).entry != null ? ((sent = ((TagContext)caller).entry).getScript() != null ? "Tag in Command:" + sent.getCommandName() + " in Script:" + sent.getScript().getName() : "Tag in Command:" + sent.getCommandName()) : (((TagContext)caller).script != null ? "Tag in Script:" + ((TagContext)caller).script.getName() : "Tag:" + caller.toString())) : caller.toString())));
                dB.finalOutputDebugText(ChatColor.DARK_GRAY + "[Src:" + ChatColor.GRAY + callerId + ChatColor.DARK_GRAY + "]" + ChatColor.WHITE + string, caller);
            } else {
                dB.finalOutputDebugText(string, caller);
            }
        }
    }

    static void finalOutputDebugText(String message, Debuggable caller) {
        dB.finalOutputDebugText(message, caller, true);
    }

    static void finalOutputDebugText(String message, Debuggable caller, boolean reformat) {
        message = TagManager.cleanOutputFully(message.replace("<Y>", ChatColor.YELLOW.toString()).replace("<G>", ChatColor.DARK_GRAY.toString()).replace("<A>", ChatColor.AQUA.toString()).replace("<R>", ChatColor.DARK_RED.toString()).replace("<W>", ChatColor.WHITE.toString()));
        ConsoleSender.sendMessage(message, reformat);
        Consumer<String> additional = dB.getDebugSender(caller);
        if (additional != null) {
            additional.accept(message);
        }
    }

    private static class ConsoleSender {
        static CommandSender commandSender = null;
        public static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        static boolean skipFooter = false;

        private ConsoleSender() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void sendMessage(String string, boolean reformat) {
            if (commandSender == null) {
                commandSender = Bukkit.getServer().getConsoleSender();
            }
            if (string.equals(ChatColor.LIGHT_PURPLE + "+---------------------+")) {
                if (skipFooter) return;
                skipFooter = true;
            } else {
                skipFooter = false;
            }
            if (reformat) {
                String[] words = string.split(" ");
                StringBuilder buffer = new StringBuilder();
                int length = 0;
                int width = Settings.consoleWidth();
                for (String word : words) {
                    int strippedLength = ChatColor.stripColor((String)word).length() + 1;
                    if (length + strippedLength < width) {
                        buffer.append(word).append(" ");
                        length += strippedLength;
                        continue;
                    }
                    length = strippedLength;
                    buffer.append("\n                   ").append(word).append(" ");
                }
                string = buffer.toString();
            }
            if (record) {
                Recording.append(URLEncoder.encode(dateFormat.format(new Date()) + " [INFO] " + string.replace('\u00a7', '\u0001') + "\n"));
            }
            commandSender.sendMessage(showColor ? string : ChatColor.stripColor((String)string));
        }
    }

    private static class SecurityManagerTrick
    extends SecurityManager {
        private SecurityManagerTrick() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

