/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.listeners.core;

import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.listeners.core.KillListenerType;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.Depends;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillListenerInstance
extends AbstractListener
implements Listener {
    KillListenerType.KillType type = null;
    List<String> targets = new ArrayList<String>();
    int quantity = 1;
    int currentKills = 0;
    String argRegion = null;

    @Override
    public String report() {
        return this.player.getName() + " current has quest listener '" + this.listenerId + "' active and must kill " + Arrays.toString(this.targets.toArray()) + " '" + this.type.name() + "'(s). Current progress '" + this.currentKills + "/" + this.quantity + "'.";
    }

    @Override
    public void onBuild(List<String> args) {
        for (String arg : args) {
            if (this.aH.matchesValueArg("TYPE", arg, ArgumentHelper.ArgumentType.Custom)) {
                try {
                    this.type = KillListenerType.KillType.valueOf(this.aH.getStringFrom(arg).toUpperCase());
                    dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, this.type.name());
                }
                catch (Exception e) {}
                continue;
            }
            if (this.aH.matchesQuantity(arg)) {
                this.quantity = this.aH.getIntegerFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_QUANTITY, String.valueOf(this.quantity));
                continue;
            }
            if (this.aH.matchesValueArg("TARGETS, TARGET, NAME, NAMES", arg, ArgumentHelper.ArgumentType.Custom)) {
                this.targets = this.aH.getListFrom(arg);
                dB.echoDebug("...set TARGETS: " + Arrays.toString(this.targets.toArray()));
                continue;
            }
            if (!this.aH.matchesValueArg("REGION", arg, ArgumentHelper.ArgumentType.Custom)) continue;
            this.argRegion = this.aH.getStringFrom(arg);
            dB.echoDebug("...set REGION.");
        }
        if (this.targets.isEmpty()) {
            dB.echoError("Missing TARGETS argument!");
            this.cancel();
        }
        if (this.type == null) {
            dB.echoError("Missing TYPE argument! Valid: NPC, ENTITY, PLAYER, GROUP");
            this.cancel();
        }
    }

    @Override
    public void onLoad() {
        this.type = KillListenerType.KillType.valueOf((String)this.get("Type"));
        this.targets = (List)this.get("Targets");
        this.quantity = (Integer)this.get("Quantity");
        this.currentKills = (Integer)this.get("Current Kills");
    }

    @Override
    public void onSave() {
        this.store("Type", this.type.name());
        this.store("Targets", this.targets);
        this.store("Quantity", this.quantity);
        this.store("Current Kills", this.currentKills);
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void constructed() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @Override
    public void deconstructed() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void listen(EntityDeathEvent event) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (event.getEntity().getKiller() != this.player) {
                            return;
                        }
                        if (this.argRegion != null && !this.inRegion(this.player)) {
                            return;
                        }
                        if (this.type != KillListenerType.KillType.ENTITY) break block4;
                        if (!this.targets.contains(event.getEntityType().toString()) && !this.targets.contains("*")) break block5;
                        ++this.currentKills;
                        dB.log(this.player.getName() + " killed a " + event.getEntityType().toString() + ". Current progress '" + this.currentKills + "/" + this.quantity + "'.");
                        this.check();
                        break block5;
                    }
                    if (this.type != KillListenerType.KillType.NPC) break block6;
                    if (!CitizensAPI.getNPCRegistry().isNPC((Entity)event.getEntity()) || !this.targets.contains(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getName().toUpperCase()) && !this.targets.contains("*") && !this.targets.contains(String.valueOf(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getId()))) break block5;
                    ++this.currentKills;
                    dB.log(this.player.getName() + " killed " + String.valueOf(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getId()) + "/" + CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getName() + ". Current progress '" + this.currentKills + "/" + this.quantity + "'.");
                    this.check();
                    break block5;
                }
                if (this.type != KillListenerType.KillType.PLAYER) break block7;
                if (event.getEntityType() != EntityType.PLAYER || !this.targets.contains(((Player)event.getEntity()).getName().toUpperCase()) && !this.targets.contains("*")) break block5;
                ++this.currentKills;
                dB.log(this.player.getName() + " killed " + ((Player)event.getEntity()).getName().toUpperCase() + ". Current progress '" + this.currentKills + "/" + this.quantity + "'.");
                this.check();
                break block5;
            }
            if (this.type == KillListenerType.KillType.GROUP && event.getEntityType() == EntityType.PLAYER) {
                for (String group : Depends.permissions.getPlayerGroups((Player)event.getEntity())) {
                    if (!this.targets.contains(group.toUpperCase())) continue;
                    ++this.currentKills;
                    dB.log(this.player.getName() + " killed " + ((Player)event.getEntity()).getName().toUpperCase() + " of group " + group + ".");
                    this.check();
                    break;
                }
            }
        }
    }

    public void check() {
        if (this.currentKills >= this.quantity) {
            this.finish();
        }
    }

    public boolean inRegion(Player thePlayer) {
        if (Depends.worldGuard == null) {
            return false;
        }
        boolean inRegion = false;
        ApplicableRegionSet currentRegions = Depends.worldGuard.getRegionManager(thePlayer.getWorld()).getApplicableRegions(thePlayer.getLocation());
        for (ProtectedRegion thisRegion : currentRegions) {
            dB.echoDebug("...checking current player region: " + thisRegion.getId());
            if (!thisRegion.getId().contains(this.argRegion)) continue;
            inRegion = true;
            dB.echoDebug("...matched region");
        }
        return inRegion;
    }
}

