/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.scripts.commands.core.EngageCommand;
import net.aufdemrand.denizen.scripts.helpers.ScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_4_6.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_4_6.entity.CraftLivingEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenizenNPC {
    private NPC npc;
    private Denizen plugin;
    private ScriptHelper sH;

    DenizenNPC(NPC citizensNPC) {
        this.npc = citizensNPC;
        this.plugin = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        this.sH = this.plugin.getScriptEngine().getScriptHelper();
    }

    public EntityLiving getHandle() {
        return ((CraftLivingEntity)this.getEntity()).getHandle();
    }

    public NPC getCitizen() {
        return this.npc;
    }

    public LivingEntity getEntity() {
        try {
            return this.npc.getBukkitEntity();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public EntityType getEntityType() {
        return this.npc.getBukkitEntity().getType();
    }

    public Navigator getNavigator() {
        return this.npc.getNavigator();
    }

    public int getId() {
        return this.npc.getId();
    }

    public String getName() {
        return this.npc.getName();
    }

    public void showInfo(Player theClicker) {
    }

    public String getInteractScript(Player thePlayer, Class<? extends AbstractTrigger> triggerType) {
        return this.sH.getInteractScript(this.getCitizen(), thePlayer, triggerType);
    }

    public boolean isSpawned() {
        return this.npc.isSpawned();
    }

    public Location getLocation() {
        return this.npc.getBukkitEntity().getLocation();
    }

    public World getWorld() {
        return this.npc.getBukkitEntity().getWorld();
    }

    public void setHealth(int newHealth) {
        ((CraftLivingEntity)this.getEntity()).getHandle().setHealth(newHealth);
    }

    public int getHealth() {
        return ((CraftLivingEntity)this.getEntity()).getHandle().getHealth();
    }

    public String toString() {
        return this.npc.getName() + "/" + this.npc.getId();
    }

    public boolean isInteracting() {
        return !this.plugin.getCommandRegistry().get(EngageCommand.class).getEngaged(this.getCitizen());
    }

    public String getAssignment() {
        return ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).getAssignment();
    }

    public boolean setAssignment(String assignment) {
        return ((AssignmentTrait)this.npc.getTrait(AssignmentTrait.class)).setAssignment(assignment);
    }

    public void action(String actionName, Player player) {
        if (this.npc.hasTrait(AssignmentTrait.class)) {
            this.plugin.getNPCRegistry().getActionHandler().doAction(actionName, this, player, this.getAssignment());
        }
    }
}

