/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CastCommand
extends AbstractCommand {
    PotionEffect potionEffect;
    LivingEntity target;
    LivingEntity caster;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        int duration = 60;
        int amplifier = 1;
        PotionEffectType potion = null;
        if (scriptEntry.getPlayer() != null) {
            this.target = scriptEntry.getPlayer();
        } else if (scriptEntry.getNPC() != null) {
            this.target = scriptEntry.getNPC().getEntity();
        }
        if (scriptEntry.getNPC() != null) {
            this.caster = scriptEntry.getNPC().getEntity();
        } else if (scriptEntry.getPlayer() != null) {
            this.caster = scriptEntry.getPlayer();
        }
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesDuration(arg)) {
                duration = Integer.valueOf(arg.split(":")[1]);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, arg);
                continue;
            }
            if (this.aH.matchesValueArg("TYPE", arg, ArgumentHelper.ArgumentType.Custom)) {
                try {
                    potion = PotionEffectType.getByName((String)this.aH.getStringFrom(arg));
                    dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, this.aH.getStringFrom(arg));
                }
                catch (Exception e) {
                    dB.echoError("Invalid PotionEffectType!");
                }
                continue;
            }
            if (this.aH.matchesValueArg("POWER", arg, ArgumentHelper.ArgumentType.Integer)) {
                amplifier = this.aH.getIntegerFrom(arg);
                dB.echoDebug("...set POWER to '%s'.", String.valueOf(amplifier));
                continue;
            }
            if (this.aH.matchesValueArg("TARGET", arg, ArgumentHelper.ArgumentType.Custom)) {
                if (this.aH.getStringFrom(arg).equalsIgnoreCase("PLAYER") && scriptEntry.getPlayer() != null) {
                    this.target = scriptEntry.getPlayer();
                    continue;
                }
                if (this.aH.getStringFrom(arg).equalsIgnoreCase("NPC") && scriptEntry.getNPC() != null) {
                    this.target = scriptEntry.getNPC().getEntity();
                    continue;
                }
                dB.echoError("Invalid TARGET type or unavailable TARGET object! Valid: PLAYER, NPC");
                continue;
            }
            if (this.aH.matchesValueArg("TARGET", arg, ArgumentHelper.ArgumentType.Custom)) {
                if (this.aH.getStringFrom(arg).equalsIgnoreCase("PLAYER") && scriptEntry.getPlayer() != null) {
                    this.target = scriptEntry.getPlayer();
                    continue;
                }
                if (this.aH.getStringFrom(arg).equalsIgnoreCase("NPC") && scriptEntry.getNPC() != null) {
                    this.target = scriptEntry.getNPC().getEntity();
                    continue;
                }
                dB.echoError("Invalid TARGET type or unavailable TARGET object! Valid: PLAYER, NPC");
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (potion == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "TYPE");
        }
        if (this.target == null) {
            throw new InvalidArgumentsException("No target Object! Perhaps you specified a non-existing  Player or NPCID? Use PLAYER:player_name or NPCID:#.");
        }
        this.potionEffect = new PotionEffect(potion, duration, amplifier);
    }

    public void execute(String commandName) throws CommandExecutionException {
        this.potionEffect.apply(this.target);
    }
}

