/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.commands.core.GiveType;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.util.Messaging;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public class GiveCommand
extends AbstractCommand {
    Player player;
    GiveType giveType;
    int theAmount;
    ItemStack theItem;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (scriptEntry.getArguments() == null) {
            throw new InvalidArgumentsException("...Usage: GIVE [MONEY|#(:#)|MATERIAL_TYPE(:#)] (QTY:#)");
        }
        this.player = scriptEntry.getPlayer();
        this.giveType = null;
        this.theAmount = 1;
        this.theItem = null;
        for (String thisArg : scriptEntry.getArguments()) {
            if (this.aH.matchesQuantity(thisArg)) {
                this.theAmount = this.aH.getIntegerFrom(thisArg);
                dB.echoDebug("...set quantity to '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesArg("MONEY", thisArg)) {
                this.giveType = GiveType.MONEY;
                dB.echoDebug("...giving MONEY.");
                continue;
            }
            if (this.aH.matchesArg("HEROESEXP", thisArg) || this.aH.matchesArg("HEROES_EXP", thisArg)) {
                this.giveType = GiveType.HEROESEXP;
                dB.echoDebug("...giving Heroes Quest EXP.");
                continue;
            }
            if (this.aH.matchesArg("XP", thisArg) || this.aH.matchesArg("EXP", thisArg)) {
                this.giveType = GiveType.EXP;
                dB.echoDebug("...giving EXP.");
                continue;
            }
            if (this.aH.matchesItem(thisArg)) {
                this.theItem = this.aH.getItemFrom(thisArg);
                this.giveType = GiveType.ITEM;
                if (this.theItem == null) continue;
                dB.echoDebug("...set item to be given to '%s'.", thisArg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, thisArg);
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        dB.echoDebug("execute (" + commandName + ")");
        if (this.giveType != null) {
            switch (this.giveType) {
                case MONEY: {
                    try {
                        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
                        if (provider == null || provider.getProvider() == null) break;
                        Economy economy = (Economy)provider.getProvider();
                        double doubleAmount = this.theAmount;
                        dB.echoDebug("Giving player " + this.theAmount + " money.");
                        economy.depositPlayer(this.player.getName(), doubleAmount);
                    }
                    catch (NoClassDefFoundError e) {
                        dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                        Messaging.logTr((String)"citizens.economy.error-loading", (Object[])new Object[0]);
                    }
                    break;
                }
                case EXP: {
                    this.player.giveExp(this.theAmount);
                    dB.echoDebug("..giving player " + this.theAmount + " EXP");
                    break;
                }
                case ITEM: {
                    this.theItem.setAmount(this.theAmount);
                    dB.echoDebug("..giving player " + this.theAmount + " of " + this.theItem);
                    HashMap leftovers = this.player.getInventory().addItem(new ItemStack[]{this.theItem});
                    if (leftovers.isEmpty()) break;
                    dB.echoDebug("...Player did not have enough space in their inventory, the rest of the items have been placed on the floor.");
                    for (Map.Entry leftoverItem : leftovers.entrySet()) {
                        this.player.getWorld().dropItem(this.player.getLocation(), (ItemStack)leftoverItem.getValue());
                    }
                    break;
                }
            }
        }
    }
}

