/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.entity.Player;

public class ListenCommand
extends AbstractCommand {
    Player player;
    AbstractListener listener;
    String id;
    ListenAction listenAction;
    String listenerType;
    List<String> listenerArguments;
    String script;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        this.listenAction = ListenAction.NEW;
        this.id = null;
        this.listenerType = null;
        this.player = scriptEntry.getPlayer();
        this.listenerArguments = new ArrayList<String>();
        for (String arg : scriptEntry.getArguments()) {
            if (this.aH.matchesArg("CANCEL", arg)) {
                this.listenAction = ListenAction.CANCEL;
                dB.echoDebug("...marked to CANCEL.");
                continue;
            }
            if (this.aH.matchesScript(arg)) {
                this.script = this.aH.getStringFrom(arg);
                dB.echoDebug(dB.Messages.DEBUG_SET_SCRIPT, arg);
                continue;
            }
            if (this.aH.matchesArg("FINISH", arg)) {
                this.listenAction = ListenAction.FINISH;
                dB.echoDebug("...marked to FINISH.");
                continue;
            }
            if (this.aH.matchesValueArg("ID", arg, ArgumentHelper.ArgumentType.String)) {
                this.id = this.aH.getStringFrom(arg);
                dB.echoDebug("...ID set: '%s'", this.id);
                continue;
            }
            if (this.denizen.getListenerRegistry().get(arg) != null) {
                this.listenerType = arg;
                dB.echoDebug("...TYPE set: '%s'", this.listenerType);
                continue;
            }
            this.listenerArguments.add(arg);
        }
        if (this.id == null && this.player == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_NO_PLAYER);
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        switch (this.listenAction) {
            case NEW: {
                try {
                    this.denizen.getListenerRegistry().get(this.listenerType).createInstance(this.player, this.id).build(this.player, this.id, this.listenerType, this.listenerArguments, this.script);
                }
                catch (Exception e) {
                    dB.echoDebug("Cancelled creation of NEW listener!");
                    try {
                        this.denizen.getListenerRegistry().getListenerFor(this.player, this.id).cancel();
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case FINISH: {
                if (this.denizen.getListenerRegistry().getListenerFor(this.player, this.id) == null) break;
                this.denizen.getListenerRegistry().getListenerFor(this.player, this.id).finish();
                break;
            }
            case CANCEL: {
                if (this.denizen.getListenerRegistry().getListenerFor(this.player, this.id) == null) break;
                this.denizen.getListenerRegistry().getListenerFor(this.player, this.id).cancel();
            }
        }
    }

    public void onEnable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListenAction {
        NEW,
        CANCEL,
        FINISH;

    }
}

