/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.scripts.helpers.ArgumentHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class TeleportCommand
extends AbstractCommand {
    public static final String NPC_ARG = "NPC";
    List<LivingEntity> teleportEntities = new ArrayList<LivingEntity>();
    private List<NPC> teleportNPCs = new ArrayList<NPC>();
    private Location teleportLocation = null;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (scriptEntry.getArguments() == null || scriptEntry.getArguments().size() == 0 || scriptEntry.getArguments().size() > 3) {
            throw new InvalidArgumentsException("Usage: TELEPORT (NPC) [LOCATION:x,y,z,world] (TARGETS:[[NPCID:#]|[PLAYER:PlayerName],])");
        }
        Boolean teleportPlayer = true;
        for (String thisArg : scriptEntry.getArguments()) {
            if (thisArg.equalsIgnoreCase(NPC_ARG)) {
                this.teleportNPCs.add(scriptEntry.getNPC().getCitizen());
                teleportPlayer = false;
                dB.echoDebug("...Teleporting the NPC instead of the PLAYER", thisArg);
                continue;
            }
            if (this.aH.matchesLocation(thisArg)) {
                this.teleportLocation = this.aH.getLocationFrom(thisArg);
                dB.echoDebug("...Teleport location now at '%s'.", thisArg);
                continue;
            }
            if (this.aH.matchesValueArg("TARGETS", thisArg, ArgumentHelper.ArgumentType.Custom)) {
                teleportPlayer = false;
                for (String target : this.aH.getListFrom(thisArg)) {
                    if (target.matches("\\d+")) {
                        NPC npc = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(target).intValue());
                        if (npc != null) {
                            this.teleportNPCs.add(npc);
                            continue;
                        }
                        dB.echoError("Unable to find NPC: %s", target);
                    } else {
                        Player player = Bukkit.getPlayer((String)target);
                        if (player != null) {
                            this.teleportEntities.add((LivingEntity)player);
                            continue;
                        }
                        dB.echoError("Unable to find player: %s", target);
                    }
                    dB.echoError("Invalid TARGET '%s'!", target);
                }
                continue;
            }
            dB.echoError("...unable to match '%s'!", thisArg);
        }
        if (teleportPlayer.booleanValue()) {
            this.teleportEntities.add((LivingEntity)scriptEntry.getPlayer());
        }
    }

    public void execute(String commandName) throws CommandExecutionException {
        if (this.teleportLocation != null) {
            for (LivingEntity entity : this.teleportEntities) {
                entity.teleport(this.teleportLocation);
            }
            for (NPC npc : this.teleportNPCs) {
                npc.despawn();
                npc.spawn(this.teleportLocation);
            }
        }
    }
}

