/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.commands.core.NewCommand;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentHelper {
    Denizen denizen;
    final Pattern doublePtrn = Pattern.compile("(?:-|)(?:(?:\\d+)|)(?:(?:\\.\\d+)|)");
    final Pattern floatPtrn = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    final Pattern integerPtrn = Pattern.compile("(?:-|)\\d+");
    final Pattern stringPtrn = Pattern.compile(".+");
    final Pattern wordPtrn = Pattern.compile("\\w+");
    final Pattern matchesEntityPattern = Pattern.compile("entity:(.+)", 2);
    final Pattern getEntityFromPtrn = Pattern.compile("(?:(?:.+?:)|)(.+)");

    public ArgumentHelper(Denizen denizen) {
        this.denizen = denizen;
    }

    public boolean getBooleanFrom(String arg) {
        if (arg.split(":").length >= 2) {
            return Boolean.valueOf(arg.split(":", 2)[1]);
        }
        return Boolean.valueOf(arg);
    }

    public double getDoubleFrom(String arg) {
        try {
            if (arg.split(":").length >= 2) {
                return Double.valueOf(arg.split(":", 2)[1]);
            }
            return Double.valueOf(arg);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public float getFloatFrom(String arg) {
        try {
            if (arg.split(":").length >= 2) {
                return Float.valueOf(arg.split(":", 2)[1]).floatValue();
            }
            return Float.valueOf(arg).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public int getIntegerFrom(String arg) {
        try {
            if (arg.split(":").length >= 2) {
                return Integer.valueOf(arg.split(":", 2)[1]);
            }
            return Integer.valueOf(arg);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public ItemStack getItemFrom(String arg) {
        ItemStack stack;
        block8: {
            Pattern[] getItemPtrn = new Pattern[]{Pattern.compile("(?:(?:.+?:)|)(\\d+):(\\d+)"), Pattern.compile("(?:(?:.+?:)|)(\\d+)"), Pattern.compile("(?:(?:.+?:)|)([a-zA-Z\\x5F]+?):(\\d+)"), Pattern.compile("(?:(?:.+?:)|)([a-zA-Z\\x5F]+)"), Pattern.compile("(?:(?:.+?:)|)itemstack\\.(.+)", 2)};
            Matcher[] m = new Matcher[4];
            m[0] = getItemPtrn[4].matcher(arg);
            if (m[0].matches()) {
                String itemName = m[0].group(1).toUpperCase();
                if (this.denizen.getCommandRegistry().get(NewCommand.class).itemStacks.containsKey(itemName)) {
                    return this.denizen.getCommandRegistry().get(NewCommand.class).itemStacks.get(itemName);
                }
                dB.echoError("Invalid item! '" + itemName + "' could not be found.");
            }
            m[0] = getItemPtrn[0].matcher(arg);
            m[1] = getItemPtrn[1].matcher(arg);
            m[2] = getItemPtrn[2].matcher(arg);
            m[3] = getItemPtrn[3].matcher(arg);
            stack = null;
            try {
                if (m[0].matches()) {
                    stack = new ItemStack(Integer.valueOf(m[0].group(1)).intValue());
                    stack.setDurability(Short.valueOf(m[0].group(2)).shortValue());
                    return stack;
                }
                if (m[1].matches()) {
                    return new ItemStack(Integer.valueOf(m[1].group(1)).intValue());
                }
                if (m[2].matches()) {
                    stack = new ItemStack(Material.valueOf((String)m[2].group(1).toUpperCase()));
                    stack.setDurability(Short.valueOf(m[2].group(2)).shortValue());
                    return stack;
                }
                if (m[3].matches()) {
                    return new ItemStack(Material.valueOf((String)m[3].group(1).toUpperCase()));
                }
            }
            catch (Exception e) {
                dB.echoError("Invalid item! Failed to find a matching Bukkit ItemStack.");
                if (!dB.showStackTraces) break block8;
                e.printStackTrace();
            }
        }
        return stack;
    }

    public List<String> getListFrom(String arg) {
        if (arg == null || arg.equals("")) {
            return new ArrayList<String>();
        }
        if (arg.split(":").length >= 2) {
            return Arrays.asList(arg.split(":", 2)[1].split("\\|"));
        }
        return Arrays.asList(arg.split("\\|"));
    }

    public Location getLocationFrom(String arg) {
        arg = arg.split(":", 2)[1];
        String[] num = arg.split(",");
        Location location = null;
        try {
            location = new Location(Bukkit.getWorld((String)num[3]), Double.valueOf(num[0]).doubleValue(), Double.valueOf(num[1]).doubleValue(), Double.valueOf(num[2]).doubleValue());
        }
        catch (Exception e) {
            dB.echoError("Unable to build a location with this information! Provided: '" + arg + "'.");
            return null;
        }
        return location;
    }

    public Player getPlayerFrom(String arg) {
        if (arg.split(":").length >= 2) {
            arg = arg.split(":", 2)[1];
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            return player;
        }
        dB.echoError("Player '" + arg + "' is invalid, or offline.");
        return null;
    }

    public Player getOfflinePlayerFrom(String arg) {
        if (arg.split(":").length >= 2) {
            arg = arg.split(":", 2)[1];
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(arg)) continue;
            return player;
        }
        dB.echoError("OfflinePlayer '" + arg + "' is invalid, or has never logged in to this server.");
        return null;
    }

    public ScriptEngine.QueueType getQueueFrom(String arg) {
        try {
            if (arg.split(":").length >= 2) {
                return ScriptEngine.QueueType.valueOf(arg.split(":")[1].toUpperCase());
            }
            return ScriptEngine.QueueType.valueOf(arg.toUpperCase());
        }
        catch (Exception e) {
            dB.echoError("Invalid Queuetype!");
            return null;
        }
    }

    public String getStringFrom(String arg) {
        if (arg.split(":").length >= 2 && (arg.indexOf(58) < arg.indexOf(32) || arg.indexOf(32) == -1)) {
            return arg.split(":", 2)[1];
        }
        return arg;
    }

    public boolean matchesArg(String names, String arg) {
        if (names.split(",").length == 1) {
            if (arg.toUpperCase().equals(names.toUpperCase())) {
                return true;
            }
        } else {
            for (String string : names.split(",")) {
                if (!arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesDouble(String arg) {
        Matcher m = this.doublePtrn.matcher(arg);
        return m.matches();
    }

    public boolean matchesDuration(String arg) {
        Pattern matchesDurationPtrn = Pattern.compile("duration:\\d+", 2);
        Matcher m = matchesDurationPtrn.matcher(arg);
        return m.matches();
    }

    public boolean matchesEntity(String arg) {
        return false;
    }

    public boolean matchesInteger(String arg) {
        Matcher m = this.integerPtrn.matcher(arg);
        return m.matches();
    }

    public boolean matchesItem(String arg) {
        Pattern[] matchesItemPtrn = new Pattern[]{Pattern.compile("item:\\d+:\\d+", 2), Pattern.compile("item:\\d+", 2), Pattern.compile("item:([a-zA-Z\\x5F]+)", 2), Pattern.compile("item:itemstack\\..+", 2)};
        Matcher m = matchesItemPtrn[3].matcher(arg);
        if (m.matches()) {
            return true;
        }
        m = matchesItemPtrn[0].matcher(arg);
        if (m.matches()) {
            return true;
        }
        m = matchesItemPtrn[1].matcher(arg);
        if (m.matches()) {
            return true;
        }
        m = matchesItemPtrn[2].matcher(arg);
        if (m.matches()) {
            for (Material mat : Material.values()) {
                if (!mat.name().equalsIgnoreCase(m.group(1))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesLocation(String arg) {
        Pattern locationPattern = Pattern.compile("location:(?:-|)\\d+,(?:-|)\\d+,(?:-|)\\d+,\\w+", 2);
        Matcher m = locationPattern.matcher(arg);
        return m.matches();
    }

    public boolean matchesQuantity(String arg) {
        Pattern matchesQuantityPtrn = Pattern.compile("qty:(?:-|)\\d+", 2);
        Matcher m = matchesQuantityPtrn.matcher(arg);
        return m.matches();
    }

    public boolean matchesQueueType(String arg) {
        Pattern matchesQueuePtrn = Pattern.compile("(?:(?:queue)|(?:queuetype)):(?:(?:player)|(?:player_task)|(?:npc))", 2);
        Matcher m = matchesQueuePtrn.matcher(arg);
        return m.matches();
    }

    public boolean matchesScript(String arg) {
        Pattern matchesScriptPtrn = Pattern.compile("script:(.+)", 2);
        Matcher m = matchesScriptPtrn.matcher(arg);
        return m.matches() && this.denizen.getScripts().contains(arg.split(":")[1].toUpperCase() + ".TYPE");
    }

    public boolean matchesToggle(String arg) {
        Pattern matchesTogglePtrn = Pattern.compile("toggle:(?:(?:true)|(?:false)|(?:toggle))", 2);
        Matcher m = matchesTogglePtrn.matcher(arg);
        return m.matches();
    }

    public boolean matchesValueArg(String names, String arg, ArgumentType type) {
        if (arg == null) {
            return false;
        }
        if (arg.split(":").length == 1) {
            return false;
        }
        if (names.split(",").length == 1) {
            if (!arg.split(":")[0].equalsIgnoreCase(names)) {
                return false;
            }
        } else {
            boolean matched = false;
            for (String string : names.split(",")) {
                if (!arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                matched = true;
            }
            if (!matched) {
                return false;
            }
        }
        arg = arg.split(":", 2)[1];
        switch (type) {
            case Word: {
                Matcher m = this.wordPtrn.matcher(arg);
                return m.matches();
            }
            case Integer: {
                Matcher m = this.integerPtrn.matcher(arg);
                return m.matches();
            }
            case Double: {
                Matcher m = this.doublePtrn.matcher(arg);
                return m.matches();
            }
            case Float: {
                Matcher m = this.floatPtrn.matcher(arg);
                return m.matches();
            }
            case Boolean: {
                return arg.equalsIgnoreCase("true");
            }
            case Location: {
                return this.matchesLocation("location:" + arg);
            }
            case Script: {
                return this.matchesLocation("script:" + arg);
            }
            case Item: {
                return this.matchesItem("item:" + arg);
            }
            case Entity: {
                return this.matchesEntity("entity:" + arg);
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgumentType {
        Entity,
        Item,
        Boolean,
        Custom,
        Double,
        Float,
        Integer,
        String,
        Word,
        Location,
        Script;

    }
}

