/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.commands.core.EngageCommand;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.util.Paginator;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class TriggerTrait
extends Trait
implements Listener {
    private Map<String, Boolean> enabled = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Double> cooldownDuration = new ConcurrentHashMap<String, Double>();
    private Map<String, TriggerRegistry.CooldownType> cooldownType = new ConcurrentHashMap<String, TriggerRegistry.CooldownType>();
    private Map<String, Integer> localRadius = new ConcurrentHashMap<String, Integer>();
    private Denizen denizen;

    public TriggerTrait() {
        super("triggers");
        if (this.denizen == null) {
            this.denizen = (Denizen)Bukkit.getServer().getPluginManager().getPlugin("Denizen");
        }
        for (String triggerName : this.denizen.getTriggerRegistry().list().keySet()) {
            this.enabled.put(triggerName, this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().ENABLED_BY_DEFAULT);
        }
    }

    public void load(DataKey key) throws NPCLoadException {
        for (String triggerName : this.denizen.getTriggerRegistry().list().keySet()) {
            this.enabled.put(triggerName, key.getBoolean(triggerName.toLowerCase() + "-trigger" + ".enabled", false));
            if (key.keyExists(triggerName.toLowerCase() + "-trigger" + ".cooldown")) {
                this.cooldownDuration.put(triggerName, key.getDouble(triggerName.toLowerCase() + "-trigger" + ".cooldown"));
            }
            if (key.keyExists(triggerName.toLowerCase() + "-trigger" + ".cooldowntype")) {
                this.cooldownType.put(triggerName, TriggerRegistry.CooldownType.valueOf(key.getString(triggerName.toLowerCase() + "-trigger" + ".cooldowntype")));
            }
            if (!key.keyExists(triggerName.toLowerCase() + "-trigger" + ".radius")) continue;
            this.localRadius.put(triggerName, key.getInt(triggerName.toLowerCase() + "-trigger" + ".radius"));
        }
    }

    public void save(DataKey key) {
        for (Map.Entry<String, Boolean> entry : this.enabled.entrySet()) {
            key.setBoolean(entry.getKey().toLowerCase() + "-trigger" + ".enabled", entry.getValue().booleanValue());
        }
        for (Map.Entry<String, Comparable<Boolean>> entry : this.cooldownDuration.entrySet()) {
            key.setDouble(entry.getKey().toLowerCase() + "-trigger" + ".cooldown", ((Double)entry.getValue()).doubleValue());
        }
        for (Map.Entry<String, Object> entry : this.cooldownType.entrySet()) {
            key.setString(entry.getKey().toLowerCase() + "-trigger" + ".cooldowntype", ((TriggerRegistry.CooldownType)((Object)entry.getValue())).name());
        }
        for (Map.Entry<String, Object> entry : this.localRadius.entrySet()) {
            key.setInt(entry.getKey().toLowerCase() + "-trigger" + ".radius", ((Integer)entry.getValue()).intValue());
        }
    }

    public String toggleTrigger(String triggerName, boolean toggle) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            this.enabled.put(triggerName.toUpperCase(), toggle);
            return triggerName + " trigger is now " + (toggle ? "enabled." : "disabled.");
        }
        return triggerName + " trigger not found!";
    }

    public String toggleTrigger(String triggerName) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            if (this.enabled.get(triggerName.toUpperCase()).booleanValue()) {
                this.enabled.put(triggerName.toUpperCase(), false);
                return triggerName + " trigger is now disabled.";
            }
            this.enabled.put(triggerName.toUpperCase(), true);
            return triggerName + " trigger is now enabled.";
        }
        return triggerName + " trigger not found!";
    }

    public boolean isEnabled(String triggerName) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            return this.enabled.get(triggerName.toUpperCase());
        }
        return false;
    }

    public void setLocalCooldown(String triggerName, double value) {
        this.cooldownDuration.put(triggerName.toUpperCase(), value);
    }

    public double getCooldownDuration(String triggerName) {
        if (this.cooldownDuration.containsKey(triggerName.toUpperCase())) {
            return this.cooldownDuration.get(triggerName.toUpperCase());
        }
        return this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().DEFAULT_COOLDOWN;
    }

    public TriggerRegistry.CooldownType getCooldownType(String triggerName) {
        if (this.cooldownType.containsKey(triggerName.toUpperCase())) {
            return this.cooldownType.get(triggerName.toUpperCase());
        }
        return this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().DEFAULT_COOLDOWN_TYPE;
    }

    public void setLocalRadius(String triggerName, int value) {
        if (this.localRadius.containsKey(triggerName.toUpperCase())) {
            this.localRadius.put(triggerName, value);
        }
    }

    public int getRadius(String triggerName) {
        if (this.localRadius.containsKey(triggerName.toUpperCase())) {
            return this.localRadius.get(triggerName.toUpperCase());
        }
        return this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().DEFAULT_RADIUS;
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Triggers");
        paginator.addLine("<e>Key: <a>Name  <b>Status  <c>Cooldown  <d>Cooldown Type  <e>(Radius)");
        for (Map.Entry<String, Boolean> entry : this.enabled.entrySet()) {
            String line = "<a> " + entry.getKey() + "<b> " + (entry.getValue() != false ? "Enabled" : "Disabled") + "<c> " + this.getCooldownDuration(entry.getKey()) + "<d> " + this.getCooldownType(entry.getKey()).name() + "<e> " + (this.getRadius(entry.getKey()) == -1 ? "" : Integer.valueOf(this.getRadius(entry.getKey())));
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public boolean triggerCooldownOnly(AbstractTrigger triggerClass, Player player) {
        if (!this.denizen.getTriggerRegistry().checkCooldown(this.npc, player, triggerClass)) {
            return false;
        }
        if (this.denizen.getCommandRegistry().get(EngageCommand.class).getEngaged(this.npc)) {
            return false;
        }
        this.denizen.getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(triggerClass.getName()), this.getCooldownType(triggerClass.getName()));
        return true;
    }

    public boolean trigger(AbstractTrigger triggerClass, Player player) {
        if (!this.denizen.getTriggerRegistry().checkCooldown(this.npc, player, triggerClass)) {
            return false;
        }
        if (this.denizen.getCommandRegistry().get(EngageCommand.class).getEngaged(this.npc)) {
            this.denizen.getNPCRegistry().getDenizen(this.npc).action("unavailable", player);
            return false;
        }
        this.denizen.getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(triggerClass.getName()), this.getCooldownType(triggerClass.getName()));
        this.denizen.getNPCRegistry().getDenizen(this.npc).action(triggerClass.getName(), player);
        return true;
    }
}

