/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    public Integer getMaxProximityRangeInBlocks() {
        return 5;
    }

    @EventHandler
    public void proximityTrigger(PlayerMoveEvent event) {
        if (!event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            Location playerLocation = event.getTo();
            Location fromBlockLocation = event.getFrom().getBlock().getLocation();
            Location toBlockLocation = event.getTo().getBlock().getLocation();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                DenizenNPC denizenNPC;
                String theScript;
                if (!npc.hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).isEnabled(this.name) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).trigger(this, event.getPlayer()) || !npc.isSpawned() || !npc.getBukkitEntity().getLocation().getWorld().equals(playerLocation.getWorld()) || (theScript = (denizenNPC = this.denizen.getNPCRegistry().getDenizen(npc)).getInteractScript(event.getPlayer(), this.getClass())) == null) continue;
                String theStep = this.sH.getCurrentStep(event.getPlayer(), theScript);
                int entryRadius = this.getMaxProximityRangeInBlocks();
                int exitRadius = this.getMaxProximityRangeInBlocks();
                try {
                    entryRadius = this.denizen.getScripts().getInt(theScript + ".STEPS." + theStep + ".PROXIMITY TRIGGER.ENTRYRADIUS", this.getMaxProximityRangeInBlocks().intValue());
                }
                catch (NumberFormatException nfe) {
                    dB.echoError("entryRadius was not an integer.  Assuming " + entryRadius + " as the radius.");
                }
                try {
                    exitRadius = this.denizen.getScripts().getInt(theScript + ".STEPS." + theStep + ".PROXIMITY TRIGGER.EXITRADIUS", this.getMaxProximityRangeInBlocks().intValue());
                }
                catch (NumberFormatException nfe) {
                    dB.echoError("exitRadius was not an integer.  Assuming " + exitRadius + " as the radius.");
                }
                if (npc.getBukkitEntity().getLocation().distance(toBlockLocation) <= (double)entryRadius && npc.getBukkitEntity().getLocation().distance(fromBlockLocation) > (double)entryRadius) {
                    dB.echoDebug("theScript: " + theScript);
                    dB.echoDebug(ChatColor.GOLD + " FOUND NPC IN ENTERING RANGE: " + npc.getFullName());
                    this.parse(denizenNPC, event.getPlayer(), theScript, true);
                    continue;
                }
                if (!(npc.getBukkitEntity().getLocation().distance(fromBlockLocation) <= (double)exitRadius) || !(npc.getBukkitEntity().getLocation().distance(toBlockLocation) > (double)exitRadius)) continue;
                dB.echoDebug("theScript: " + theScript);
                dB.echoDebug(ChatColor.GOLD + " FOUND NPC IN EXITING RANGE: " + npc.getFullName());
                this.parse(denizenNPC, event.getPlayer(), theScript, false);
            }
        }
    }

    public boolean parse(DenizenNPC theDenizen, Player thePlayer, String theScriptName, boolean entry) {
        if (theScriptName == null) {
            return false;
        }
        String theStep = this.sH.getCurrentStep(thePlayer, theScriptName);
        List<String> scriptsToParse = entry ? Arrays.asList((theScriptName + ".Steps." + theStep + ".Proximity Trigger." + ScriptHelper.scriptKey).toUpperCase(), (theScriptName + ".Steps." + theStep + ".Proximity Trigger.Entry." + ScriptHelper.scriptKey).toUpperCase()) : Arrays.asList((theScriptName + ".Steps." + theStep + ".Proximity Trigger.Exit" + ScriptHelper.scriptKey).toUpperCase());
        for (String path : scriptsToParse) {
            List<String> theScript = this.sH.getScriptContents(path);
            if (theScript == null || theScript.isEmpty()) continue;
            this.sB.queueScriptEntries(thePlayer, this.sB.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.PLAYER);
        }
        return true;
    }
}

