/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.flags;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.commands.core.FlagCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;

public class FlagManager {
    private Denizen denizen;

    public FlagManager(Denizen denizen) {
        this.denizen = denizen;
    }

    public Flag getFlag(FlagCommand.FlagType flagType, String targetName, Integer npcid, String flagName) {
        if (flagType == FlagCommand.FlagType.GLOBAL) {
            return new Flag("Global.Flags." + flagName.toUpperCase());
        }
        if (flagType == FlagCommand.FlagType.PLAYER) {
            return new Flag("Players." + targetName + ".Flags." + flagName.toUpperCase());
        }
        if (flagType == FlagCommand.FlagType.NPC) {
            return new Flag("NPCs." + npcid + ".Flags." + flagName.toUpperCase());
        }
        return new Flag("Global.Flags.null");
    }

    public Flag getNPCFlag(int npcid, String flagName) {
        return new Flag("NPCs." + npcid + ".Flags." + flagName.toUpperCase());
    }

    public Flag getGlobalFlag(String flagName) {
        return new Flag("Global.Flags." + flagName.toUpperCase());
    }

    public Flag getPlayerFlag(String playerName, String flagName) {
        return new Flag("Players." + playerName + ".Flags." + flagName.toUpperCase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Value {
        private List<String> values;
        private int index = -1;

        private Value(List<String> values) {
            this.values = values;
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
        }

        private void adjustIndex() {
            if (this.index < 0) {
                this.index = this.size() - 1;
            }
        }

        public boolean asBoolean() {
            this.adjustIndex();
            try {
                return !this.values.get(this.index).equalsIgnoreCase("FALSE");
            }
            catch (Exception e) {
                return false;
            }
        }

        public double asDouble() {
            this.adjustIndex();
            try {
                return Double.valueOf(this.values.get(this.index)).intValue();
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        public int asInteger() {
            this.adjustIndex();
            try {
                return Double.valueOf(this.values.get(this.index)).intValue();
            }
            catch (Exception e) {
                return 0;
            }
        }

        public String asCommaSeparatedList() {
            this.adjustIndex();
            String returnList = "";
            for (String string : this.values) {
                returnList = returnList + string + ",";
            }
            return returnList.substring(0, returnList.length() - 2);
        }

        public String asString() {
            this.adjustIndex();
            try {
                return this.values.get(this.index);
            }
            catch (Exception e) {
                return "";
            }
        }

        public Object asAutoDetectedObject() {
            this.adjustIndex();
            String arg = this.values.get(this.index);
            try {
                if (aH.matchesInteger(arg)) {
                    return aH.getIntegerFrom(arg);
                }
                if (aH.matchesDouble(arg)) {
                    return aH.getDoubleFrom(arg);
                }
                if (arg.equalsIgnoreCase("true")) {
                    return true;
                }
                if (arg.equalsIgnoreCase("false")) {
                    return false;
                }
                if (arg.contains("|")) {
                    ArrayList<String> toList = new ArrayList<String>();
                    for (String string : arg.split("|")) {
                        toList.add(string);
                    }
                    return toList;
                }
                return arg;
            }
            catch (Exception e) {
                return "";
            }
        }

        private Value get(int i) {
            this.index = i - 1;
            this.adjustIndex();
            return this;
        }

        public boolean isEmpty() {
            if (this.size() < this.index + 1) {
                return true;
            }
            return this.values.get(this.index).equals("");
        }

        private int size() {
            return this.values.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Flag {
        private Value value;
        private String flagPath;
        private long expiration = -1L;

        Flag(String flagPath) {
            this.flagPath = flagPath;
            this.rebuild();
        }

        public boolean contains(String stringValue) {
            this.checkExpired();
            for (String val : this.value.values) {
                if (val.equalsIgnoreCase(stringValue)) {
                    return true;
                }
                try {
                    if (!Double.valueOf(val).equals(Double.valueOf(stringValue))) continue;
                    return true;
                }
                catch (Exception e) {
                }
            }
            return false;
        }

        public List<String> values() {
            this.checkExpired();
            return this.value.values;
        }

        public Value get(int index) {
            this.checkExpired();
            return this.value.get(index);
        }

        public Value getFirst() {
            this.checkExpired();
            return this.value.get(1);
        }

        public Value getLast() {
            this.checkExpired();
            return this.value.get(this.value.size());
        }

        public void set(Object obj) {
            this.set(obj, -1);
        }

        public void set(Object obj, int index) {
            this.checkExpired();
            if (index < 0) {
                index = this.size();
            }
            if (this.size() == 0) {
                this.value.values.add((String)obj);
            } else if (index > 0) {
                if (this.value.values.size() > index - 1) {
                    this.value.values.remove(index - 1);
                    this.value.values.add(index - 1, (String)obj);
                } else {
                    this.value.values.add((String)obj);
                }
            }
            this.save();
            this.rebuild();
        }

        public int add(Object obj) {
            this.checkExpired();
            this.value.values.add((String)obj);
            this.save();
            this.rebuild();
            return this.size();
        }

        public void remove(Object obj) {
            this.remove(obj, -1);
        }

        public void remove(Object obj, int index) {
            this.checkExpired();
            if (index < 0) {
                int x = 0;
                for (String val : this.value.values) {
                    if (val.equalsIgnoreCase((String)obj)) {
                        this.value.values.remove(x);
                        return;
                    }
                    try {
                        if (Double.valueOf(val).equals(Double.valueOf((String)obj))) {
                            this.value.values.remove(x);
                            return;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++x;
                }
            } else if (index < this.size()) {
                this.value.values.remove(index - 1);
            }
            this.save();
            this.rebuild();
        }

        public void setEntireValue(Object obj) {
            FlagManager.this.denizen.getSaves().set(this.flagPath, obj);
            FlagManager.this.denizen.saveSaves();
            this.rebuild();
        }

        public void setExpiration(Long expiration) {
            this.expiration = expiration;
            this.save();
        }

        public int size() {
            this.checkExpired();
            return this.value.size();
        }

        public void save() {
            FlagManager.this.denizen.getSaves().set(this.flagPath, (Object)this.value.values);
            FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", (Object)this.expiration);
            FlagManager.this.denizen.saveSaves();
        }

        public String toString() {
            this.checkExpired();
            return this.value.get(this.value.size()).asString();
        }

        private void checkExpired() {
            this.rebuild();
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration") && this.expiration > 1L && this.expiration < System.currentTimeMillis()) {
                FlagManager.this.denizen.getSaves().set(this.flagPath + "-expiration", null);
                FlagManager.this.denizen.getSaves().set(this.flagPath, null);
                this.rebuild();
                dB.echoDebug("// A FLAG has expired! " + this.flagPath);
            }
        }

        private Flag rebuild() {
            ArrayList<String> cval;
            if (FlagManager.this.denizen.getSaves().contains(this.flagPath + "-expiration")) {
                this.expiration = FlagManager.this.denizen.getSaves().getLong(this.flagPath + "-expiration");
            }
            if ((cval = FlagManager.this.denizen.getSaves().getStringList(this.flagPath)) == null) {
                cval = new ArrayList<String>();
                cval.add(FlagManager.this.denizen.getSaves().getString(this.flagPath, ""));
            }
            this.value = new Value(cval);
            return this;
        }
    }
}

