/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.events.dScriptReloadEvent;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptEngine;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class ProximityTrigger
extends AbstractTrigger
implements Listener {
    private static int maxProximityDistance = 25;
    private static Map<Player, Set<Integer>> proximityTracker = new ConcurrentHashMap<Player, Set<Integer>>();

    public void onEnable() {
        this.denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.denizen);
    }

    @EventHandler
    public void proximityTrigger(PlayerMoveEvent event) {
        if (!event.getTo().getBlock().equals(event.getFrom().getBlock())) {
            Location toBlockLocation = event.getTo().getBlock().getLocation();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(TriggerTrait.class) || !((TriggerTrait)npc.getTrait(TriggerTrait.class)).isEnabled(this.name) || !npc.isSpawned() || !npc.getBukkitEntity().getLocation().getWorld().equals(event.getPlayer().getWorld()) && this.hasExitedProximityOf(event.getPlayer(), npc) || !this.isCloseEnough(event.getPlayer(), npc) && this.hasExitedProximityOf(event.getPlayer(), npc)) continue;
                boolean originalDebugState = dB.debugMode;
                dB.debugMode = false;
                DenizenNPC denizenNPC = this.denizen.getNPCRegistry().getDenizen(npc);
                String theScript = null;
                if (denizenNPC.hasAssignment()) {
                    theScript = denizenNPC.getInteractScript(event.getPlayer(), this.getClass());
                }
                int entryRadius = ((TriggerTrait)denizenNPC.getCitizen().getTrait(TriggerTrait.class)).getRadius(this.name);
                int exitRadius = ((TriggerTrait)denizenNPC.getCitizen().getTrait(TriggerTrait.class)).getRadius(this.name);
                dB.debugMode = originalDebugState;
                if (theScript != null) {
                    String theStep = this.sH.getCurrentStep(event.getPlayer(), theScript, false);
                    try {
                        if (this.denizen.getScripts().contains((theScript + ".STEPS." + theStep + ".PROXIMITY TRIGGER.ENTRY RADIUS").toUpperCase())) {
                            entryRadius = this.denizen.getScripts().getInt(theScript + ".STEPS." + theStep + ".PROXIMITY TRIGGER.ENTRY RADIUS", entryRadius);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        dB.echoDebug("Entry Radius was not an integer.  Assuming " + entryRadius + " as the radius.");
                    }
                    try {
                        if (this.denizen.getScripts().contains((theScript + ".STEPS." + theStep + ".PROXIMITY TRIGGER.EXIT RADIUS").toUpperCase())) {
                            exitRadius = this.denizen.getScripts().getInt(theScript + ".STEPS." + theStep + ".PROXIMITY TRIGGER.EXIT RADIUS", exitRadius);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        dB.echoDebug("Exit Radius was not an integer.  Assuming " + exitRadius + " as the radius.");
                    }
                }
                if (npc.getBukkitEntity().getLocation().distance(toBlockLocation) <= (double)entryRadius && this.hasExitedProximityOf(event.getPlayer(), npc)) {
                    if (!((TriggerTrait)npc.getTrait(TriggerTrait.class)).triggerCooldownOnly(this, event.getPlayer())) continue;
                    this.enterProximityOf(event.getPlayer(), npc);
                    dB.echoDebug(ChatColor.GOLD + "FOUND! NPC is in ENTERING range: '" + npc.getName() + "'");
                    denizenNPC.action("enter proximity", event.getPlayer());
                    this.parse(denizenNPC, event.getPlayer(), theScript, true);
                } else if (npc.getBukkitEntity().getLocation().distance(toBlockLocation) >= (double)exitRadius && !this.hasExitedProximityOf(event.getPlayer(), npc)) {
                    if (!((TriggerTrait)npc.getTrait(TriggerTrait.class)).triggerCooldownOnly(this, event.getPlayer())) continue;
                    this.exitProximityOf(event.getPlayer(), npc);
                    dB.echoDebug(ChatColor.YELLOW + "FOUND! NPC is in EXITING range: '" + npc.getName() + "'");
                    denizenNPC.action("exit proximity", event.getPlayer());
                    this.parse(denizenNPC, event.getPlayer(), theScript, false);
                }
                dB.debugMode = originalDebugState;
            }
        }
    }

    public boolean parse(DenizenNPC theDenizen, Player thePlayer, String theScriptName, boolean entry) {
        if (theScriptName == null) {
            return false;
        }
        String theStep = this.sH.getCurrentStep(thePlayer, theScriptName);
        List<String> scriptsToParse = entry ? Arrays.asList((theScriptName + ".Steps." + theStep + ".Proximity Trigger." + ScriptHelper.scriptKey).toUpperCase(), (theScriptName + ".Steps." + theStep + ".Proximity Trigger.Entry." + ScriptHelper.scriptKey).toUpperCase()) : Arrays.asList((theScriptName + ".Steps." + theStep + ".Proximity Trigger.Exit" + ScriptHelper.scriptKey).toUpperCase());
        for (String path : scriptsToParse) {
            List<String> theScript = this.sH.getScriptContents(path);
            if (theScript == null || theScript.isEmpty()) continue;
            this.sB.queueScriptEntries(thePlayer, this.sB.buildScriptEntries(thePlayer, theDenizen, theScript, theScriptName, theStep), ScriptEngine.QueueType.PLAYER);
        }
        return true;
    }

    private boolean isCloseEnough(Player player, NPC npc) {
        Location pLoc = player.getLocation();
        Location nLoc = npc.getBukkitEntity().getLocation();
        if (Math.abs(pLoc.getBlockX() - nLoc.getBlockX()) > maxProximityDistance) {
            return false;
        }
        if (Math.abs(pLoc.getBlockY() - nLoc.getBlockY()) > maxProximityDistance) {
            return false;
        }
        return Math.abs(pLoc.getBlockZ() - nLoc.getBlockZ()) <= maxProximityDistance;
    }

    @EventHandler
    public void checkMaxProximities(dScriptReloadEvent event) {
        for (String string : DenizenAPI.getCurrentInstance().getScripts().getConfigurationSection("").getKeys(false)) {
        }
    }

    private boolean hasExitedProximityOf(Player player, NPC npc) {
        if (!proximityTracker.containsKey(player)) {
            return true;
        }
        return !proximityTracker.get(player).contains(npc.getId());
    }

    private void enterProximityOf(Player player, NPC npc) {
        Set<Integer> npcs = new HashSet<Integer>();
        if (proximityTracker.containsKey(player)) {
            npcs = proximityTracker.get(player);
        }
        npcs.add(npc.getId());
        proximityTracker.put(player, npcs);
    }

    private void exitProximityOf(Player player, NPC npc) {
        Set<Object> npcs = new HashSet();
        if (proximityTracker.containsKey(player)) {
            npcs = proximityTracker.get(player);
        }
        if (npcs.contains(npc.getId())) {
            npcs.remove(npc.getId());
        }
        proximityTracker.put(player, npcs);
    }
}

