/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.npc.DenizenNPC;
import net.aufdemrand.denizen.npc.actions.ActionHandler;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenizenNPCRegistry
implements Listener {
    private static Map<NPC, DenizenNPC> denizenNPCs = new ConcurrentHashMap<NPC, DenizenNPC>();
    private Denizen plugin;
    private ActionHandler actionHandler;

    public DenizenNPCRegistry(Denizen denizen) {
        this.plugin = denizen;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.actionHandler = new ActionHandler(this.plugin);
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    private boolean isDenizenNPC(NPC npc) {
        return denizenNPCs.containsKey(npc);
    }

    private void registerNPC(NPC npc) {
        if (!denizenNPCs.containsKey(npc)) {
            denizenNPCs.put(npc, new DenizenNPC(npc));
        }
        dB.log("Constructing NPC " + this.getDenizen(npc).toString());
    }

    public DenizenNPC getDenizen(NPC npc) {
        if (!denizenNPCs.containsKey(npc)) {
            this.registerNPC(npc);
        }
        return denizenNPCs.get(npc);
    }

    public Map<NPC, DenizenNPC> getSpawnedNPCs() {
        for (Map.Entry<NPC, DenizenNPC> npc : denizenNPCs.entrySet()) {
            try {
                npc.getKey().getBukkitEntity();
            }
            catch (NullPointerException e) {
                denizenNPCs.remove(npc.getKey());
                dB.log(ChatColor.RED + "Removed NPC from DenizenRegistry. " + ChatColor.WHITE + "The bukkit entity has been removed.");
            }
        }
        return denizenNPCs;
    }

    @EventHandler
    public void onSpawn(NPCSpawnEvent event) {
        this.registerNPC(event.getNPC());
        this.plugin.getNPCRegistry().getDenizen(event.getNPC()).action("spawn", null);
    }

    @EventHandler
    public void onRemove(NPCRemoveEvent event) {
        this.plugin.getNPCRegistry().getDenizen(event.getNPC()).action("remove", null);
        if (this.isDenizenNPC(event.getNPC())) {
            denizenNPCs.remove(event.getNPC());
        }
        dB.log(ChatColor.RED + "Deconstructing Denizen NPC " + event.getNPC().getName() + "/" + event.getNPC().getId());
    }
}

