/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.scripts.commands.core.EngageCommand;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.util.Paginator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class TriggerTrait
extends Trait
implements Listener {
    private Denizen denizen;
    @Persist(value="enabled", collectionType=ConcurrentHashMap.class)
    private Map<String, Boolean> enabled = new ConcurrentHashMap<String, Boolean>();
    @Persist(value="duration", collectionType=ConcurrentHashMap.class)
    private Map<String, Double> duration = new ConcurrentHashMap<String, Double>();
    @Persist(value="cooldowntype", collectionType=ConcurrentHashMap.class)
    private Map<String, TriggerRegistry.CooldownType> type = new ConcurrentHashMap<String, TriggerRegistry.CooldownType>();
    @Persist(value="radius", collectionType=ConcurrentHashMap.class)
    private Map<String, Integer> radius = new ConcurrentHashMap<String, Integer>();

    public TriggerTrait() {
        super("triggers");
        if (this.denizen == null) {
            this.denizen = DenizenAPI.getCurrentInstance();
        }
        for (String triggerName : this.denizen.getTriggerRegistry().list().keySet()) {
            if (this.enabled.containsKey(triggerName)) continue;
            this.enabled.put(triggerName, this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().ENABLED_BY_DEFAULT);
        }
    }

    public String toggleTrigger(String triggerName, boolean toggle) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            this.enabled.put(triggerName.toUpperCase(), toggle);
            return triggerName + " trigger is now " + (toggle ? "enabled." : "disabled.");
        }
        return triggerName + " trigger not found!";
    }

    public String toggleTrigger(String triggerName) {
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            if (this.enabled.get(triggerName.toUpperCase()).booleanValue()) {
                this.enabled.put(triggerName.toUpperCase(), false);
                return triggerName + " trigger is now disabled.";
            }
            this.enabled.put(triggerName.toUpperCase(), true);
            return triggerName + " trigger is now enabled.";
        }
        return triggerName + " trigger not found!";
    }

    public boolean isEnabled(String triggerName) {
        if (!DenizenAPI.getDenizenNPC(this.npc).hasAssignment()) {
            return false;
        }
        if (this.enabled.containsKey(triggerName.toUpperCase())) {
            return this.enabled.get(triggerName.toUpperCase());
        }
        return false;
    }

    public void setLocalCooldown(String triggerName, double value) {
        this.duration.put(triggerName.toUpperCase(), value);
    }

    public double getCooldownDuration(String triggerName) {
        if (this.duration.containsKey(triggerName.toUpperCase())) {
            return this.duration.get(triggerName.toUpperCase());
        }
        return this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().DEFAULT_COOLDOWN;
    }

    public TriggerRegistry.CooldownType getCooldownType(String triggerName) {
        if (this.type.containsKey(triggerName.toUpperCase())) {
            return this.type.get(triggerName.toUpperCase());
        }
        return this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().DEFAULT_COOLDOWN_TYPE;
    }

    public void setLocalRadius(String triggerName, int value) {
        if (triggerName == null) {
            return;
        }
        if (this.radius.containsKey(triggerName.toUpperCase())) {
            this.radius.put(triggerName, value);
        }
    }

    public int getRadius(String triggerName) {
        if (this.radius.containsKey(triggerName.toUpperCase())) {
            return this.radius.get(triggerName.toUpperCase());
        }
        return this.denizen.getTriggerRegistry().get((String)triggerName).getOptions().DEFAULT_RADIUS;
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        Paginator paginator = new Paginator().header("Triggers");
        paginator.addLine("<e>Key: <a>Name  <b>Status  <c>Cooldown  <d>Cooldown Type  <e>(Radius)");
        for (Map.Entry<String, Boolean> entry : this.enabled.entrySet()) {
            String line = "<a> " + entry.getKey() + "<b> " + (entry.getValue() != false ? "Enabled" : "Disabled") + "<c> " + this.getCooldownDuration(entry.getKey()) + "<d> " + this.getCooldownType(entry.getKey()).name() + "<e> " + (this.getRadius(entry.getKey()) == -1 ? "" : Integer.valueOf(this.getRadius(entry.getKey())));
            paginator.addLine(line);
        }
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public boolean triggerCooldownOnly(AbstractTrigger triggerClass, Player player) {
        if (!this.denizen.getTriggerRegistry().checkCooldown(this.npc, player, triggerClass, this.getCooldownType(triggerClass.getName()))) {
            return false;
        }
        if (this.denizen.getCommandRegistry().get(EngageCommand.class).getEngaged(this.npc)) {
            return false;
        }
        this.denizen.getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(triggerClass.getName()), this.getCooldownType(triggerClass.getName()));
        return true;
    }

    public boolean trigger(AbstractTrigger triggerClass, Player player) {
        if (!this.denizen.getTriggerRegistry().checkCooldown(this.npc, player, triggerClass, this.getCooldownType(triggerClass.getName()))) {
            return false;
        }
        if (this.denizen.getCommandRegistry().get(EngageCommand.class).getEngaged(this.npc)) {
            this.denizen.getNPCRegistry().getDenizen(this.npc).action("unavailable", player);
            return false;
        }
        this.denizen.getTriggerRegistry().setCooldown(this.npc, player, triggerClass, this.getCooldownDuration(triggerClass.getName()), this.getCooldownType(triggerClass.getName()));
        this.denizen.getNPCRegistry().getDenizen(this.npc).action(triggerClass.getName(), player);
        return true;
    }
}

