/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public class TakeCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        TakeType takeType = null;
        double quantity = 1.0;
        ItemStack item = null;
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("MONEY, COINS", arg)) {
                takeType = TakeType.MONEY;
                dB.echoDebug("...taking MONEY");
            } else if (aH.matchesArg("ITEMINHAND", arg)) {
                takeType = TakeType.ITEMINHAND;
                dB.echoDebug("...taking ITEMINHAND");
            } else if (aH.matchesQuantity(arg)) {
                quantity = aH.getDoubleFrom(arg);
            } else if (aH.matchesItem(arg)) {
                takeType = TakeType.ITEMINHAND;
                item = aH.getItemFrom(arg);
                dB.echoDebug("...taking " + item.getType());
            } else {
                throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
            }
            scriptEntry.addObject("item", item);
            scriptEntry.addObject("takeType", (Object)takeType);
            scriptEntry.addObject("quantity", quantity);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        switch ((TakeType)((Object)scriptEntry.getObject("takeType"))) {
            case ITEMINHAND: {
                scriptEntry.getPlayer().setItemInHand(new ItemStack(0));
                dB.echoDebug("...item taken");
                break;
            }
            case MONEY: {
                try {
                    RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
                    if (provider == null || provider.getProvider() == null) break;
                    Economy economy = (Economy)provider.getProvider();
                    dB.echoDebug("...taking " + scriptEntry.getObject("quantity") + " money.");
                    economy.withdrawPlayer(scriptEntry.getPlayer().getName(), ((Double)scriptEntry.getObject("quantity")).doubleValue());
                }
                catch (NoClassDefFoundError e) {
                    dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                }
                break;
            }
            case ITEM: {
                ((ItemStack)scriptEntry.getObject("item")).setAmount(((Double)scriptEntry.getObject("quantity")).intValue());
                if (scriptEntry.getPlayer().getInventory().removeItem(new ItemStack[]{(ItemStack)scriptEntry.getObject("item")}).isEmpty()) break;
                dB.echoDebug("The Player did not have enough " + ((ItemStack)scriptEntry.getObject("item")).getType().toString() + " on hand, so Denizen took as much as possible. To avoid this situation, use an IF or REQUIREMENT to check.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TakeType {
        MONEY,
        ITEMINHAND,
        ITEM;

    }
}

