/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.events.ReplaceableTagEvent;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.NBTItem;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class PlayerTags
implements Listener {
    Map<String, List<String>> playerChatHistory = new ConcurrentHashMap<String, List<String>>();

    public PlayerTags(Denizen denizen) {
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void addMessage(AsyncPlayerChatEvent event) {
        List<String> history = new ArrayList<String>();
        if (this.playerChatHistory.containsKey(event.getPlayer().getName())) {
            history = this.playerChatHistory.get(event.getPlayer().getName());
        }
        if (history.size() > 10) {
            history.remove(9);
        }
        history.add(0, event.getMessage());
        this.playerChatHistory.put(event.getPlayer().getName(), history);
    }

    @EventHandler
    public void playerTags(ReplaceableTagEvent event) {
        block97: {
            String subType;
            if (!event.matches("PLAYER") || event.getPlayer() == null) {
                return;
            }
            Player p = event.getPlayer();
            String type = event.getType() != null ? event.getType().toUpperCase() : "";
            String string = subType = event.getSubType() != null ? event.getSubType().toUpperCase() : "";
            if (type.equals("CHAT_HISTORY")) {
                if (event.hasTypeContext()) {
                    if (aH.matchesInteger(event.getTypeContext()) && this.playerChatHistory.containsKey(event.getPlayer().getName())) {
                        List<String> history = this.playerChatHistory.get(event.getPlayer().getName());
                        if (history.size() < aH.getIntegerFrom(event.getTypeContext())) {
                            event.setReplaced(history.get(history.size() - 1));
                        } else {
                            event.setReplaced(history.get(aH.getIntegerFrom(event.getTypeContext()) - 1));
                        }
                    }
                } else if (this.playerChatHistory.containsKey(event.getPlayer().getName())) {
                    event.setReplaced(this.playerChatHistory.get(event.getPlayer().getName()).get(0));
                }
            } else if (type.equals("ITEM_IN_HAND")) {
                if (subType.equals("QTY")) {
                    event.setReplaced(String.valueOf(p.getItemInHand().getAmount()));
                } else if (subType.equals("ID")) {
                    event.setReplaced(String.valueOf(p.getItemInHand().getTypeId()));
                } else if (subType.equals("DURABILITY")) {
                    event.setReplaced(String.valueOf(p.getItemInHand().getDurability()));
                } else if (subType.equals("DATA")) {
                    event.setReplaced(String.valueOf(p.getItemInHand().getData()));
                } else if (subType.equals("MAX_STACK")) {
                    event.setReplaced(String.valueOf(p.getItemInHand().getMaxStackSize()));
                } else if (subType.equals("ENCHANTMENTS")) {
                    event.setReplaced(NBTItem.getEnchantments(p.getItemInHand()).asDScriptList());
                } else if (subType.equals("ENCHANTMENTS_WITH_LEVEL")) {
                    event.setReplaced(NBTItem.getEnchantments(p.getItemInHand()).asDScriptListWithLevels());
                } else if (subType.equals("ENCHANTMENTS_WITH_LEVEL_ONLY")) {
                    event.setReplaced(NBTItem.getEnchantments(p.getItemInHand()).asDScriptListLevelsOnly());
                } else if (subType.equals("LORE")) {
                    event.setReplaced(NBTItem.getLore(p.getItemInHand()).asDScriptList());
                } else if (subType.equals("DISPLAY")) {
                    event.setReplaced(p.getItemInHand().getItemMeta().getDisplayName());
                } else if (subType.equals("MATERIAL")) {
                    event.setReplaced(p.getItemInHand().getType().name());
                }
            } else if (type.equals("NAME")) {
                event.setReplaced(p.getName());
                if (subType.equals("DISPLAY")) {
                    event.setReplaced(p.getDisplayName());
                } else if (subType.equals("LIST")) {
                    event.setReplaced(p.getPlayerListName());
                }
            } else if (type.equals("LOCATION")) {
                event.setReplaced(p.getLocation().getBlockX() + "," + p.getLocation().getBlockY() + "," + p.getLocation().getBlockZ() + "," + p.getWorld().getName());
                if (subType.equals("FORMATTED")) {
                    event.setReplaced("X '" + p.getLocation().getBlockX() + "', Y '" + p.getLocation().getBlockY() + "', Z '" + p.getLocation().getBlockZ() + "', in world '" + p.getWorld().getName() + "'");
                } else if (subType.equals("STANDING_ON")) {
                    event.setReplaced(p.getLocation().add(0.0, -1.0, 0.0).getBlock().getType().name());
                } else if (subType.equals("WORLD_SPAWN")) {
                    event.setReplaced(p.getWorld().getSpawnLocation().getBlockX() + "," + p.getWorld().getSpawnLocation().getBlockY() + "," + p.getWorld().getSpawnLocation().getBlockZ() + "," + p.getWorld().getName());
                } else if (subType.equals("BED_SPAWN")) {
                    event.setReplaced(p.getBedSpawnLocation().getBlockX() + "," + p.getBedSpawnLocation().getBlockY() + "," + p.getBedSpawnLocation().getBlockZ() + "," + p.getWorld().getName());
                } else if (subType.equals("WORLD")) {
                    event.setReplaced(p.getWorld().getName());
                }
            } else if (type.equals("HEALTH")) {
                event.setReplaced(String.valueOf(p.getHealth()));
                if (subType.equals("FORMATTED")) {
                    int maxHealth = p.getMaxHealth();
                    if (event.getType().split("\\.").length > 2) {
                        maxHealth = Integer.valueOf(event.getType().split(".")[2]);
                    }
                    if ((double)((float)p.getHealth() / (float)maxHealth) < 0.1) {
                        event.setReplaced("dying");
                    } else if ((double)((float)p.getHealth() / (float)maxHealth) < 0.4) {
                        event.setReplaced("seriously wounded");
                    } else if ((double)((float)p.getHealth() / (float)maxHealth) < 0.75) {
                        event.setReplaced("injured");
                    } else if ((float)p.getHealth() / (float)maxHealth < 1.0f) {
                        event.setReplaced("scraped");
                    } else {
                        event.setReplaced("healthy");
                    }
                } else if (subType.equals("PERCENTAGE")) {
                    int maxHealth = p.getMaxHealth();
                    if (event.getType().split("\\.").length > 2) {
                        maxHealth = Integer.valueOf(event.getType().split(".")[2]);
                    }
                    event.setReplaced(String.valueOf((float)p.getHealth() / (float)maxHealth * 100.0f));
                }
            } else if (type.equals("FOOD_LEVEL")) {
                event.setReplaced(String.valueOf(p.getFoodLevel()));
                if (subType.equals("FORMATTED")) {
                    int maxFood = 20;
                    if (event.getType().split("\\.").length > 2) {
                        maxFood = Integer.valueOf(event.getType().split(".")[2]);
                    }
                    if ((double)((float)p.getHealth() / (float)maxFood) < 0.1) {
                        event.setReplaced("starving");
                    } else if ((double)((float)p.getFoodLevel() / (float)maxFood) < 0.4) {
                        event.setReplaced("famished");
                    } else if ((double)((float)p.getFoodLevel() / (float)maxFood) < 0.75) {
                        event.setReplaced("hungry");
                    } else if ((float)p.getFoodLevel() / (float)maxFood < 1.0f) {
                        event.setReplaced("parched");
                    } else {
                        event.setReplaced("healthy");
                    }
                } else if (subType.equals("PERCENTAGE")) {
                    int maxFood = 20;
                    if (event.getType().split("\\.").length > 2) {
                        maxFood = Integer.valueOf(event.getType().split(".")[2]);
                    }
                    event.setReplaced(String.valueOf((float)p.getFoodLevel() / (float)maxFood * 100.0f));
                }
            } else if (type.equals("MONEY")) {
                try {
                    RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
                    if (provider == null || provider.getProvider() == null) break block97;
                    Economy economy = (Economy)provider.getProvider();
                    event.setReplaced(String.valueOf(economy.getBalance(p.getName())));
                    if (subType.equals("CURRENCY_SINGULAR")) {
                        event.setReplaced(economy.currencyNameSingular());
                    } else if (subType.equals("CURRENCY_PLURAL")) {
                        event.setReplaced(economy.currencyNamePlural());
                    }
                }
                catch (NoClassDefFoundError e) {
                    dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                }
            } else if (type.equals("IS_OP")) {
                event.setReplaced(String.valueOf(p.isOp()));
            } else if (event.getType().startsWith("EQUIPMENT")) {
                event.setReplaced(String.valueOf(event.getNPC().getEntity().getHealth()));
            } else if (event.getType().startsWith("INVENTORY")) {
                event.setReplaced(String.valueOf(event.getNPC().getEntity().getHealth()));
            } else if (event.getType().startsWith("XP")) {
                event.setReplaced(String.valueOf(event.getPlayer().getExp() * 100.0f));
                if (subType.equals("TO_NEXT_LEVEL")) {
                    event.setReplaced(String.valueOf(p.getExpToLevel()));
                } else if (subType.equals("TOTAL")) {
                    event.setReplaced(String.valueOf(p.getTotalExperience()));
                } else if (subType.equals("LEVEL")) {
                    event.setReplaced(String.valueOf(p.getLevel()));
                }
            }
        }
    }
}

