/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.Location;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable3;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ShootCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        EntityType entityType = null;
        Integer qty = null;
        Location location = null;
        Boolean ride = false;
        Boolean burning = false;
        if (scriptEntry.getPlayer() != null) {
            location = new Location(scriptEntry.getPlayer().getLocation());
        }
        if (location == null && scriptEntry.getNPC() != null) {
            location = new Location(scriptEntry.getNPC().getLocation());
        }
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesEntityType(arg)) {
                entityType = aH.getEntityFrom(arg);
                continue;
            }
            if (aH.matchesQuantity(arg)) {
                qty = aH.getIntegerFrom(arg);
                continue;
            }
            if (aH.matchesLocation(arg)) {
                location = aH.getLocationFrom(arg);
                continue;
            }
            if (aH.matchesArg("RIDE, MOUNT", arg)) {
                ride = true;
                continue;
            }
            if (aH.matchesArg("BURNING", arg)) {
                burning = true;
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (entityType == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_INVALID_ENTITY);
        }
        scriptEntry.addObject("location", location);
        scriptEntry.addObject("entityType", entityType);
        scriptEntry.addObject("qty", qty);
        scriptEntry.addObject("ride", ride);
        scriptEntry.addObject("burning", burning);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Location location = (Location)scriptEntry.getObject("location");
        Integer qty = (Integer)scriptEntry.getObject("qty");
        EntityType entityType = (EntityType)scriptEntry.getObject("entityType");
        Boolean ride = (Boolean)scriptEntry.getObject("ride");
        Boolean burning = (Boolean)scriptEntry.getObject("burning");
        qty = qty != null && entityType != null ? Integer.valueOf(1) : Integer.valueOf(1);
        Utilities.faceLocation((Entity)scriptEntry.getNPC().getCitizen().getBukkitEntity(), location);
        Entity entity = scriptEntry.getNPC().getWorld().spawnEntity(scriptEntry.getNPC().getEyeLocation().add(scriptEntry.getNPC().getEyeLocation().getDirection()).subtract(0.0, -0.8, 0.0), entityType);
        Utilities.faceLocation(entity, location);
        if (ride.booleanValue()) {
            entity.setPassenger((Entity)scriptEntry.getPlayer());
        }
        if (burning.booleanValue()) {
            entity.setFireTicks(500);
        }
        if (entity instanceof Projectile) {
            ((Projectile)entity).setShooter(scriptEntry.getNPC().getCitizen().getBukkitEntity());
        }
        Runnable3<ScriptEntry, Entity, Location> task = new Runnable3<ScriptEntry, Entity, Location>(scriptEntry, entity, location){

            @Override
            public void run(ScriptEntry scriptEntry, Entity entity, Location location) {
                if (this.getRuns() < 40 && entity.isValid()) {
                    dB.echoDebug(entity.getType().name() + " flying time " + this.getRuns() + " in task " + this.getId());
                    Vector v1 = entity.getLocation().toVector().clone();
                    Vector v2 = location.toVector().clone();
                    Vector v3 = v2.clone().subtract(v1).normalize().multiply(2);
                    entity.setVelocity(v3);
                    this.addRuns();
                    if (Math.abs(v2.getBlockX() - v1.getBlockX()) < 2 && Math.abs(v2.getBlockY() - v1.getBlockY()) < 2 && Math.abs(v2.getBlockZ() - v1.getBlockZ()) < 2) {
                        this.cancel();
                        this.clearRuns();
                        dB.echoApproval("Finished task for " + entity.getType().name());
                    }
                } else {
                    this.cancel();
                    this.clearRuns();
                    dB.echoApproval("Finished task for " + entity.getType().name());
                }
            }
        };
        task.setId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.denizen, (Runnable)task, 2L, 2L));
        dB.echoApproval("Scheduled task with ID: " + task.getId());
    }
}

