/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_4_R1.EntityLiving;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static String arrayToString(String[] input, String glue) {
        String output = "";
        int length = input.length;
        int i = 1;
        for (String s : input) {
            output.concat(s);
            if (++i == length) continue;
            output.concat(glue);
        }
        return output;
    }

    public static int lastIndexOfUCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfLCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public String getVersionNumber() {
        Properties props = new Properties();
        props.put("version", "Unknown development build");
        try {
            props.load(this.getClass().getResourceAsStream("/META-INF/maven/net.aufdemrand/denizen/pom.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props.getProperty("version");
    }

    public String getVersionString() {
        return "Denizen version: " + this.getVersionNumber();
    }

    public Map<Material, Integer> getInventoryMap(Player thePlayer) {
        HashMap<Material, Integer> playerInv = new HashMap<Material, Integer>();
        ItemStack[] getContentsArray = thePlayer.getInventory().getContents();
        List<ItemStack> getContents = Arrays.asList(getContentsArray);
        for (int x = 0; x < getContents.size(); ++x) {
            if (getContents.get(x) == null) continue;
            if (playerInv.containsKey(getContents.get(x).getType())) {
                int t = (Integer)playerInv.get(getContents.get(x).getType());
                playerInv.put(getContents.get(x).getType(), t += getContents.get(x).getAmount());
                continue;
            }
            playerInv.put(getContents.get(x).getType(), getContents.get(x).getAmount());
        }
        return playerInv;
    }

    public Map<String, Integer> getInventoryIdMap(Player thePlayer) {
        HashMap<String, Integer> playerInv = new HashMap<String, Integer>();
        ItemStack[] getContentsArray = thePlayer.getInventory().getContents();
        List<ItemStack> getContents = Arrays.asList(getContentsArray);
        for (int x = 0; x < getContents.size(); ++x) {
            if (getContents.get(x) == null) continue;
            MaterialData specificItem = getContents.get(x).getData();
            String friendlyItem = specificItem.getItemTypeId() + ":" + specificItem.getData();
            if (playerInv.containsKey(friendlyItem)) {
                int t = (Integer)playerInv.get(friendlyItem);
                playerInv.put(friendlyItem, t += getContents.get(x).getAmount());
                continue;
            }
            playerInv.put(friendlyItem, getContents.get(x).getAmount());
        }
        return playerInv;
    }

    public static void faceLocation(Entity from, Location at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location loc = from.getLocation();
        double xDiff = at.getX() - loc.getX();
        double yDiff = at.getY() - loc.getY();
        double zDiff = at.getZ() - loc.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.acos(xDiff / distanceXZ) * 180.0 / Math.PI;
        double pitch = Math.acos(yDiff / distanceY) * 180.0 / Math.PI - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        if (from instanceof LivingEntity) {
            EntityLiving handle = ((CraftLivingEntity)from).getHandle();
            handle.yaw = (float)yaw - 90.0f;
            handle.pitch = (float)pitch;
            handle.az = handle.yaw;
        }
    }

    public static void faceEntity(Entity from, Entity at) {
        Utilities.faceLocation(from, at.getLocation());
    }

    public static NPC getClosestNPC(Location location, int range) {
        NPC closestNPC = null;
        Double closestDistance = range;
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.isSpawned() || !npc.getBukkitEntity().getLocation().getWorld().equals(location.getWorld()) || !(npc.getBukkitEntity().getLocation().distance(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getBukkitEntity().getLocation().distance(location);
        }
        return closestNPC;
    }

    public static List<NPC> getClosestNPCs(Location location, int maxRange) {
        ArrayList<NPC> closestNPCs = new ArrayList<NPC>();
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            if (!npc.isSpawned() || !npc.getBukkitEntity().getLocation().getWorld().equals(location.getWorld()) || !(npc.getBukkitEntity().getLocation().distance(location) < (double)maxRange)) continue;
            closestNPCs.add(npc);
        }
        return closestNPCs;
    }
}

