/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import java.util.Set;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.listeners.AbstractListener;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.NameplateTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.PushableTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.scripts.ScriptHelper;
import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.ScriptRepo;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Paginator;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.shade.json.JSONException;

public class CommandHandler {
    private final Citizens plugin;

    public CommandHandler(Citizens plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"npc"}, usage="pushable -t (-r) (--delay #)", desc="Makes a NPC pushable.", flags="rt", modifiers={"pushable", "push"}, min=1, max=2, permission="npc.pushable")
    @Requirements(selected=true, ownership=true)
    public void pushable(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(PushableTrait.class)) {
            npc.addTrait(PushableTrait.class);
        }
        PushableTrait trait = (PushableTrait)npc.getTrait(PushableTrait.class);
        if (args.hasFlag('r') && !args.hasFlag('t')) {
            trait.setReturnable(!trait.isReturnable());
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + (trait.isReturnable() ? " will " : " will not ") + "return when being pushed" + (!trait.isReturnable() || trait.isPushable() ? "." : ", but is currently not pushable.")});
            return;
        }
        if (args.hasValueFlag("delay") && !args.hasFlag('t')) {
            if (args.getFlag("delay").matches("\\d+") && args.getFlagInteger("delay") > 0) {
                trait.setDelay(Integer.valueOf(args.getFlag("delay")));
                trait.setReturnable(true);
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + " will return after '" + args.getFlag("delay") + "' seconds" + (trait.isPushable() ? "." : ", but is currently not pushable.")});
                return;
            }
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.RED + "Delay must be a valid number of seconds!"});
            return;
        }
        if (args.hasFlag('t') && !args.hasValueFlag("delay") && !args.hasFlag('r')) {
            trait.toggle();
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + (trait.isPushable() ? " is" : " is not") + " currently pushable" + (trait.isReturnable() && trait.isPushable() ? " and will return when pushed after '" + trait.getDelay() + "' seconds." : ".")});
            return;
        }
        if (args.hasFlag('t')) {
            trait.toggle();
            if (args.hasFlag('r')) {
                trait.setReturnable(true);
            }
            if (args.hasValueFlag("delay") && args.getFlag("delay").matches("\\d+") && args.getFlagInteger("delay") > 0) {
                trait.setDelay(args.getFlagInteger("delay"));
            }
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + (trait.isPushable() ? " is" : " is not") + " currently pushable" + (trait.isReturnable() && trait.isPushable() ? " and will return when pushed after '" + trait.getDelay() + "' seconds." : ".")});
            return;
        }
        if (args.length() > 2) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Use '-t' to toggle pushable state. <b>Example: /npc pushable -t"});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>To have the NPC return when pushed, use '-r'."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Change the return delay with '--delay #'."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + (trait.isPushable() ? " is" : " is not") + " currently pushable" + (trait.isReturnable() ? " and will return when pushed after " + trait.getDelay() + " seconds." : ".")});
    }

    @Command(aliases={"npc"}, usage="constant --set|remove name --value constant value", desc="Views/adds/removes NPC string constants.", flags="r", modifiers={"constants", "constant", "cons"}, min=1, max=3, permission="npc.constants")
    @Requirements(selected=true, ownership=true)
    public void constants(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(ConstantsTrait.class)) {
            npc.addTrait(ConstantsTrait.class);
        }
        ConstantsTrait trait = (ConstantsTrait)npc.getTrait(ConstantsTrait.class);
        if (args.hasValueFlag("set")) {
            if (!args.hasValueFlag("value")) {
                throw new CommandException("--SET requires use of the '--VALUE \"constant value\"' argument.");
            }
            trait.setConstant(args.getFlag("set"), args.getFlag("value"));
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + " has added constant '" + args.getFlag("set") + "'."});
            return;
        }
        if (args.hasValueFlag("remove")) {
            trait.removeConstant(args.getFlag("remove"));
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + " has removed constant '" + args.getFlag("remove") + "'."});
            return;
        }
        if (args.length() > 2 && args.getInteger(1, 0) < 1) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Use '--set name' to add/set a new NPC-specific constant."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Must also specify '--value \"constant value\"'."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<b>Example: /npc constant --set constant_1 --value \"test value\""});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Remove NPC-specific constants with '--remove name'"});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Note: Constants set will override any specified in an"});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>assignment. Constants specified in assignments cannot be"});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>removed with this command."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
            return;
        }
        trait.describe(sender, args.getInteger(1, 1));
    }

    @Command(aliases={"npc"}, usage="assignment --set assignment_name (-r)", desc="Controls the assignment for an NPC.", flags="r", modifiers={"assignment", "assign"}, min=1, max=3, permission="npc.assign")
    @Requirements(selected=true, ownership=true)
    public void assignment(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(AssignmentTrait.class)) {
            npc.addTrait(AssignmentTrait.class);
        }
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        AssignmentTrait trait = (AssignmentTrait)npc.getTrait(AssignmentTrait.class);
        if (args.hasValueFlag("set")) {
            if (trait.setAssignment(args.getFlag("set").replace("\"", ""), player)) {
                if (trait.hasAssignment()) {
                    Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + "'s assignment is now: '" + trait.getAssignment().getName() + "'."});
                } else {
                    Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + "'s assignment was not able to be set."});
                }
            } else {
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.RED + "Invalid assignment! Has the script sucessfully loaded, or has it been mispelled?"});
            }
            return;
        }
        if (args.hasFlag('r')) {
            trait.removeAssignment(player);
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + "'s assignment has been removed."});
            return;
        }
        if (args.length() > 2 && args.getInteger(1, 0) < 1) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Use '--set name' to set an assignment script to this NPC."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<b>Example: /npc assignment --set \"Magic Shop\""});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Remove an assignment with '-r'."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Note: Assigning a script will fire an 'On Assignment:' action."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
            return;
        }
        trait.describe(sender, args.getInteger(1, 1));
    }

    @Command(aliases={"npc"}, usage="trigger [trigger name] [(--cooldown [seconds])|(--radius [radius])|(-t)]", desc="Controls the various triggers for an NPC.", flags="t", modifiers={"trigger", "tr"}, min=1, max=3, permission="npc.trigger")
    @Requirements(selected=true, ownership=true)
    public void trigger(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(TriggerTrait.class)) {
            npc.addTrait(TriggerTrait.class);
        }
        TriggerTrait trait = (TriggerTrait)npc.getTrait(TriggerTrait.class);
        if (args.hasValueFlag("name") || args.argsLength() > 1 && args.getJoinedStrings(1) != null && !args.getString(1).matches("\\d+")) {
            String triggerName = args.hasValueFlag("name") ? args.getFlag("name") : args.getJoinedStrings(1);
            if (DenizenAPI.getCurrentInstance().getTriggerRegistry().get(triggerName) == null) {
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.RED + "'" + triggerName.toUpperCase() + "' trigger does not exist."});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Usage: /npc trigger [trigger_name] [(--cooldown #)|(--radius #)|(-t)]"});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Use '--name trigger_name' to specify a specific trigger, and '-t' to toggle."});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"<b>Example: /npc trigger --name damage -t"});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>You may also use '--cooldown #' to specify a new cooldown time, and '--radius #' to specify a specific radius, when applicable."});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
                return;
            }
            if (args.hasFlag('t')) {
                trait.toggleTrigger(triggerName);
            }
            if (args.hasValueFlag("cooldown")) {
                trait.setLocalCooldown(triggerName, args.getFlagDouble("cooldown"));
            }
            if (args.hasValueFlag("radius")) {
                trait.setLocalRadius(triggerName, args.getFlagInteger("radius"));
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + triggerName.toUpperCase() + " trigger radius now " + args.getFlag("radius") + "."});
            }
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + triggerName.toUpperCase() + " trigger " + (trait.isEnabled(triggerName) ? "is" : "is not") + " currently enabled" + (trait.isEnabled(triggerName) ? " with a cooldown of '" + trait.getCooldownDuration(triggerName) + "' seconds." : ".")});
            return;
        }
        trait.describe(sender, args.getInteger(1, 1));
    }

    @Command(aliases={"npc"}, usage="nickname [--set nickname]", desc="Gives the NPC a nickname, used with a Denizen-compatible Speech Engine.", modifiers={"nickname", "nick", "ni"}, min=1, max=3, permission="npc.nickname")
    @Requirements(selected=true, ownership=true)
    public void nickname(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(NicknameTrait.class)) {
            npc.addTrait(NicknameTrait.class);
        }
        NicknameTrait trait = (NicknameTrait)npc.getTrait(NicknameTrait.class);
        if (args.hasValueFlag("set")) {
            trait.setNickname(args.getFlag("set"));
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Nickname set."});
            return;
        }
        if (args.hasFlag('r')) {
            trait.setNickname("");
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + "Nickname removed."});
            return;
        }
        if (trait.hasNickname()) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + "'s nickname is '" + trait.getNickname() + "'."});
        } else {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + " does not have a nickname!"});
        }
    }

    @Command(aliases={"npc"}, usage="nameplate [--color color]", desc="Sets the namepalte color of the NPC.", modifiers={"nameplate", "nametag", "np", "nt"}, min=1, max=3, permission="npc.nameplate")
    @Requirements(selected=true, ownership=true)
    public void nameplate(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(NameplateTrait.class)) {
            npc.addTrait(NameplateTrait.class);
        }
        NameplateTrait trait = (NameplateTrait)npc.getTrait(NameplateTrait.class);
        if (args.hasValueFlag("color")) {
            String colorString = args.getFlag("color").toUpperCase();
            ChatColor color = null;
            try {
                color = ChatColor.valueOf((String)colorString);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (color != null) {
                trait.setColor(color);
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Nameplate color set."});
            } else {
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.RED + "No color with name '" + colorString + "' found!"});
            }
            return;
        }
        if (args.hasFlag('r')) {
            trait.setColor(null);
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Nameplate color reset."});
        }
        if (trait.hasColor()) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + "'s nameplate color is " + trait.getColor() + trait.getColor().name() + "."});
        } else {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + " does not have a nameplate color!"});
        }
    }

    @Command(aliases={"npc"}, usage="health --set # (-r)", desc="Sets the max health for an NPC.", modifiers={"health", "he", "hp"}, min=1, max=3, permission="npc.health", flags="rs")
    @Requirements(selected=true, ownership=true)
    public void health(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.hasTrait(HealthTrait.class)) {
            npc.addTrait(HealthTrait.class);
        }
        HealthTrait trait = (HealthTrait)npc.getTrait(HealthTrait.class);
        boolean showMore = true;
        if (args.hasValueFlag("max")) {
            trait.setMaxhealth(args.getFlagInteger("max"));
            trait.setHealth();
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + npc.getName() + "'s health maximum is now " + trait.getMaxhealth() + "."});
            showMore = false;
        }
        if (args.hasValueFlag("set")) {
            trait.setHealth(args.getFlagInteger("set"));
        }
        if (args.hasValueFlag("respawndelay")) {
            trait.setRespawnDelay(args.getFlag("respawndelay"));
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + npc.getName() + "'s respawn delay now " + trait.getRespawnDelay() + (trait.isRespawnable() ? "." : ", but is not currently auto-respawnable upon death.")});
            showMore = false;
        }
        if (args.hasValueFlag("respawnlocation")) {
            trait.setRespawnLocation(args.getFlag("respawnlocation"));
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + npc.getName() + "'s respawn location now " + trait.getRespawnLocationAsString() + (trait.isRespawnable() ? "." : ", but is not currently auto-respawnable upon death.")});
            showMore = false;
        }
        if (args.hasFlag('s')) {
            trait.setRespawnable(!trait.isRespawnable());
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + npc.getName() + (trait.isRespawnable() ? " will now auto-respawn on death after " + trait.getRespawnDelay() + " seconds." : " will no longer auto-respawn on death.")});
            showMore = false;
        }
        if (args.hasFlag('a')) {
            trait.animateOnDeath(!trait.animatesOnDeath());
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + npc.getName() + (trait.animatesOnDeath() ? " will now animate on death." : " will no longer animate on death.")});
            showMore = false;
        } else if (args.hasFlag('r')) {
            trait.setHealth();
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + npc.getName() + "'s health reset to " + trait.getMaxhealth() + "."});
            showMore = false;
        }
        if (showMore) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + npc.getName() + "'s health is '" + trait.getHealth() + "/" + trait.getMaxhealth() + "'."});
        }
    }

    @Command(aliases={"denizen"}, usage="debug", desc="Toggles debug mode for Denizen.", modifiers={"debug", "de", "db"}, min=1, max=3, permission="denizen.debug", flags="s")
    public void debug(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.hasFlag('s')) {
            if (!dB.debugMode) {
                dB.toggle();
            }
            dB.showStackTraces = !dB.showStackTraces;
        } else {
            dB.toggle();
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = ChatColor.YELLOW + "Denizen debugger is " + (dB.debugMode ? (dB.showStackTraces ? "enabled and showing stack-traces." : "enabled.") : "disabled.");
        Messaging.send((CommandSender)sender, (Object[])objectArray);
    }

    @Command(aliases={"denizen"}, usage="version", desc="Shows the currently loaded version of Denizen.", modifiers={"version"}, min=1, max=3, permission="denizen.basic")
    public void version(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + " _/_ _  ._  _ _  "});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.YELLOW + "(/(-/ )/ /_(-/ ) " + ChatColor.GRAY + " scriptable NPCs"});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GRAY + "by: " + ChatColor.WHITE + "aufdemrand"});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GRAY + "version: " + ChatColor.WHITE + Denizen.versionTag});
    }

    @Command(aliases={"denizen"}, usage="save", desc="Saves the current state of Denizen/saves.yml.", modifiers={"save"}, min=1, max=3, permission="denizen.basic", flags="s")
    public void save(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ((Denizen)this.plugin.getServer().getPluginManager().getPlugin("Denizen")).saveSaves();
        Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Denizen/saves.yml saved to disk from memory."});
    }

    @Command(aliases={"denizen"}, usage="listener (--player) --id listener_id --report|cancel|finish", desc="Checks/cancels/finishes listeners in progress.", modifiers={"listener"}, min=1, max=3, permission="denizen.basic", flags="s")
    public void listener(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Denizen denizen = (Denizen)this.plugin.getServer().getPluginManager().getPlugin("Denizen");
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (args.hasValueFlag("player")) {
            player = aH.getPlayerFrom(args.getFlag("player"));
        }
        if (player == null) {
            throw new CommandException("Specified player not online or not found!");
        }
        if (args.hasValueFlag("report")) {
            for (AbstractListener quest : denizen.getListenerRegistry().getListenersFor((OfflinePlayer)player).values()) {
                if (!quest.getListenerId().equalsIgnoreCase(args.getFlag("report"))) continue;
                Messaging.send((CommandSender)sender, (Object[])new Object[]{quest.report()});
            }
            return;
        }
        if (args.hasValueFlag("cancel")) {
            for (AbstractListener quest : denizen.getListenerRegistry().getListenersFor((OfflinePlayer)player).values()) {
                if (!quest.getListenerId().equalsIgnoreCase(args.getFlag("cancel"))) continue;
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Cancelling '" + quest.getListenerId() + "' for " + player.getName() + "."});
                quest.cancel();
            }
            return;
        }
        if (args.hasValueFlag("finish")) {
            for (AbstractListener quest : denizen.getListenerRegistry().getListenersFor((OfflinePlayer)player).values()) {
                if (!quest.getListenerId().equalsIgnoreCase(args.getFlag("finish"))) continue;
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Force-finishing '" + quest.getListenerId() + "' for " + player.getName() + "."});
                quest.finish();
            }
            return;
        }
        if (args.length() > 2 && args.getInteger(1, 0) < 1) {
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Use '--report|cancel|finish id' to modify/view a specific quest listener."});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{"<b>Example: /npc listener --report \"Journey 1\""});
            Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
            return;
        }
        Paginator paginator = new Paginator();
        paginator.header("Active quest listeners for " + player.getName() + ":");
        paginator.addLine("<e>Key: <a>Type  <b>ID");
        if (denizen.getListenerRegistry().getListenersFor((OfflinePlayer)player).isEmpty()) {
            paginator.addLine("None.");
        } else {
            for (AbstractListener quest : denizen.getListenerRegistry().getListenersFor((OfflinePlayer)player).values()) {
                paginator.addLine("<a>" + quest.getListenerType() + "  <b>" + quest.getListenerId());
            }
        }
        paginator.sendPage(sender, args.getInteger(1, 1));
    }

    @Command(aliases={"denizen"}, usage="reload (saves|config|scripts) (-a)", desc="Reloads various Denizen YML files from disk to memory.", modifiers={"reload"}, min=1, max=3, permission="denizen.basic", flags="a")
    public void reload(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Denizen denizen = (Denizen)this.plugin.getServer().getPluginManager().getPlugin("Denizen");
        if (args.hasFlag('a')) {
            denizen.reloadSaves();
            denizen.reloadConfig();
            ScriptHelper.reloadScripts();
            Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Denizen/saves.yml, Denizen/config.yml, and Denizen/scripts/... reloaded from disk to memory."});
            return;
        }
        if (args.length() > 2) {
            if (args.getString(1).equalsIgnoreCase("saves")) {
                denizen.reloadSaves();
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Denizen/saves.yml reloaded from disk to memory."});
                return;
            }
            if (args.getString(1).equalsIgnoreCase("config")) {
                denizen.reloadConfig();
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Denizen/config.yml reloaded from disk to memory."});
                return;
            }
            if (args.getString(1).equalsIgnoreCase("scripts")) {
                ScriptHelper.reloadScripts();
                Messaging.send((CommandSender)sender, (Object[])new Object[]{ChatColor.GREEN + "Denizen/scripts/... reloaded from disk to memory."});
                return;
            }
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Specify which parts to reload. Valid options are: SAVES, CONFIG, SCRIPTS"});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"<b>Example: /denizen reload scripts"});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"<f>Use '-a' to reload all parts."});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{""});
    }

    @Command(aliases={"denizen"}, usage="scripts (--type assignment|task|activity|interact) (--filter string)", desc="Lists currently loaded dScripts.", modifiers={"scripts"}, min=1, max=4, permission="denizen.basic")
    public void scripts(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Denizen denizen = (Denizen)this.plugin.getServer().getPluginManager().getPlugin("Denizen");
        String type = null;
        if (args.hasValueFlag("type")) {
            type = args.getFlag("type");
        }
        String filter = null;
        if (args.hasValueFlag("filter")) {
            filter = args.getFlag("filter");
        }
        Set<String> scripts = ScriptRegistry._getScriptNames();
        Paginator paginator = new Paginator().header("Scripts");
        paginator.addLine("<e>Key: <a>Type  <b>Name");
        for (String script : scripts) {
            ScriptContainer scriptContainer = ScriptRegistry.getScriptContainer(script);
            if (type != null) {
                if (!scriptContainer.getType().equalsIgnoreCase(type)) continue;
                if (filter != null) {
                    if (!script.contains(filter.toUpperCase())) continue;
                    paginator.addLine("<a>" + scriptContainer.getType().substring(0, 4) + "  <b>" + script);
                    continue;
                }
                paginator.addLine("<a>" + scriptContainer.getType().substring(0, 4) + "  <b>" + script);
                continue;
            }
            if (filter != null) {
                if (!script.contains(filter.toUpperCase())) continue;
                paginator.addLine("<a>" + scriptContainer.getType().substring(0, 4) + "  <b>" + script);
                continue;
            }
            paginator.addLine("<a>" + scriptContainer.getType().substring(0, 4) + "  <b>" + script);
        }
        if (!paginator.sendPage(sender, args.getInteger(1, 1))) {
            throw new CommandException("citizens.commands.page-missing");
        }
    }

    @Command(aliases={"denizen"}, usage="repo (info|search|load)", desc="Repo commands.", modifiers={"info", "search", "load"}, min=1, permission="denizen.repo")
    public void repo(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Denizen denizen = (Denizen)this.plugin.getServer().getPluginManager().getPlugin("Denizen");
        if (args.argsLength() > 1 && args.getString(2).equalsIgnoreCase("info")) {
            if (args.argsLength() == 3) {
                try {
                    ScriptRepo.info(sender, args.getString(2));
                }
                catch (JSONException e) {
                    Messaging.send((CommandSender)sender, (Object[])new Object[]{"The Script Repo sent a bad reply, please try again."});
                }
            } else {
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"Invalid usage! Correct usage: "});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"/citizens denizen repo info [ID] - View information about a script."});
            }
        } else if (args.argsLength() > 1 && args.getString(2).equalsIgnoreCase("search")) {
            if (args.argsLength() >= 3) {
                String query = Utilities.arrayToString(args.getSlice(3), "+");
                try {
                    ScriptRepo.search(sender, query);
                }
                catch (JSONException e) {
                    Messaging.send((CommandSender)sender, (Object[])new Object[]{"The Script Repo sent a bad reply, please try again."});
                }
            } else {
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"Invalid usage! Correct usage: "});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"/citizens denizen repo search [search query] - Search the script repo."});
            }
        } else if (args.argsLength() > 1 && args.getString(2).equalsIgnoreCase("load")) {
            if (args.argsLength() == 3) {
                try {
                    ScriptRepo.load(sender, args.getString(2));
                }
                catch (JSONException e) {
                    Messaging.send((CommandSender)sender, (Object[])new Object[]{"The Script Repo sent a bad reply, please try again."});
                }
            } else {
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"Invalid usage! Correct usage: "});
                Messaging.send((CommandSender)sender, (Object[])new Object[]{"/citizens denizen repo load (ID) - Load the specified script (or the most recently viewed) onto your server."});
            }
        }
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"\u00a7cThe Citizens Script Repo is a website accessible at \u00a7bhttp://scripts.citizensnpcs.com/\u00a7c where you can browse and post numerous types of scripts including Denizen scripts."});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"\u00a7cYou can also search and download scripts directly in game with the repo subcommand."});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"/citizens denizen repo info [ID] - View information about a script."});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"/citizens denizen repo search [search query] - Search the script repo."});
        Messaging.send((CommandSender)sender, (Object[])new Object[]{"/citizens denizen repo load (ID) - Load the specified script (or the most recently viewed) onto your server."});
    }

    @Command(aliases={"denizen"}, usage="report", desc="For testing purposes only, use at your own risk!", modifiers={"report"}, min=1, max=3, permission="denizen.basic")
    public void text(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        TriggerTrait trait = (TriggerTrait)npc.getTrait(TriggerTrait.class);
        trait.report();
    }
}

