/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import net.aufdemrand.denizen.scripts.ScriptRegistry;
import net.aufdemrand.denizen.scripts.containers.ScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.utilities.arguments.Item;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.LeatherColorer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    public ItemScriptContainer(ConfigurationSection configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public Item getItemFrom() {
        Item stack = null;
        try {
            if (this.contains("MATERIAL")) {
                stack = Item.valueOf(this.getString("MATERIAL"));
            }
            if (stack == null) {
                return null;
            }
            ItemMeta meta = stack.getItemMeta();
            if (this.contains("DISPLAY NAME")) {
                meta.setDisplayName(this.getString("DISPLAY NAME"));
            }
            if (this.contains("LORE")) {
                meta.setLore(this.getStringList("LORE"));
            }
            stack.setItemMeta(meta);
            if (this.contains("ENCHANTMENTS")) {
                for (String enchantment : this.getStringList("ENCHANTMENTS")) {
                    try {
                        int level = 1;
                        if (enchantment.split(":").length > 1) {
                            level = Integer.valueOf(enchantment.split(":")[1]);
                            enchantment = enchantment.split(":")[0];
                        }
                        Enchantment ench = Enchantment.getByName((String)enchantment.toUpperCase());
                        stack.addEnchantment(ench, level);
                    }
                    catch (Exception e) {}
                }
            }
            if (this.contains("COLOR")) {
                LeatherColorer.colorArmor(stack, this.getString("COLOR"));
            }
            if (this.contains("BOOK")) {
                BookScriptContainer book = ScriptRegistry.getScriptContainerAs(this.getString("BOOK"), BookScriptContainer.class);
                stack = book.writeBookTo(stack);
            }
            stack.setId(this.getName());
        }
        catch (Exception e) {
            dB.echoError("Woah! An exception has been called with this item script!");
            if (!dB.showStackTraces) {
                dB.echoError("Enable '/denizen stacktrace' for the nitty-gritty.");
            } else {
                e.printStackTrace();
            }
            stack = null;
        }
        return stack;
    }
}

