/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.activities;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.interfaces.DenizenRegistry;
import net.aufdemrand.denizen.interfaces.RegistrationableInstance;
import net.aufdemrand.denizen.npc.activities.AbstractActivity;
import net.aufdemrand.denizen.npc.activities.core.TaskActivity;
import net.aufdemrand.denizen.npc.activities.core.WanderActivity;
import net.aufdemrand.denizen.npc.dNPC;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.citizensnpcs.api.npc.NPC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityRegistry
implements DenizenRegistry {
    public final Denizen denizen;
    private Map<String, AbstractActivity> instances = new HashMap<String, AbstractActivity>();
    private Map<Class<? extends AbstractActivity>, String> classes = new HashMap<Class<? extends AbstractActivity>, String>();

    public ActivityRegistry(Denizen denizenPlugin) {
        this.denizen = denizenPlugin;
    }

    public void addActivity(String activity, dNPC dNPC2, String[] args, int priority) {
        if (this.instances.containsKey(activity.toUpperCase())) {
            this.instances.get(activity.toUpperCase()).addGoal(dNPC2, args, priority);
        } else {
            this.denizen.getLogger().log(Level.SEVERE, "'" + activity + "' is an invalid activity!");
        }
    }

    @Override
    public void disableCoreMembers() {
        for (AbstractActivity member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                if (!dB.showStackTraces) continue;
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        if (this.classes.containsKey(clazz)) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(this.classes.get(clazz))));
        }
        return null;
    }

    @Override
    public AbstractActivity get(String activityName) {
        if (this.instances.containsKey(activityName.toUpperCase())) {
            return this.instances.get(activityName.toUpperCase());
        }
        return null;
    }

    public Map<String, AbstractActivity> list() {
        return this.instances;
    }

    @Override
    public boolean register(String activityName, RegistrationableInstance activityClass) {
        this.instances.put(activityName.toUpperCase(), (AbstractActivity)activityClass);
        this.classes.put(((AbstractActivity)activityClass).getClass(), activityName.toUpperCase());
        return true;
    }

    @Override
    public void registerCoreMembers() {
        WanderActivity wanderActivity = new WanderActivity();
        TaskActivity taskActivity = new TaskActivity();
        wanderActivity.activate().as("WANDER");
        taskActivity.activate().as("TASK");
        dB.echoApproval("Loaded core activities: " + this.instances.keySet().toString());
    }

    public void removeActivity(String activity, NPC denizenNPC) {
        if (this.instances.containsKey(activity.toUpperCase())) {
            this.instances.get(activity.toUpperCase()).removeGoal(this.denizen.getNPCRegistry().getDenizen(denizenNPC), true);
        } else {
            this.denizen.getLogger().log(Level.SEVERE, "Invalid activity!");
        }
    }

    public void removeAllActivities(NPC denizenNPC) {
        for (AbstractActivity theActivity : this.instances.values()) {
            theActivity.removeGoal(this.denizen.getNPCRegistry().getDenizen(denizenNPC), false);
        }
    }
}

