/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.runnables.Runnable2;
import net.minecraft.server.v1_4_R1.Block;
import net.minecraft.server.v1_4_R1.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.CraftWorld;
import org.bukkit.plugin.Plugin;

public class SwitchCommand
extends AbstractCommand {
    private Map<Location, Integer> taskMap = new ConcurrentHashMap<Location, Integer>();
    SwitchState switchState;
    Location interactLocation;
    int duration = -1;

    public void onEnable() {
    }

    public void parseArgs(ScriptEntry theEntry) throws InvalidArgumentsException {
        this.interactLocation = null;
        this.duration = -1;
        this.switchState = SwitchState.TOGGLE;
        for (String arg : theEntry.getArguments()) {
            if (aH.matchesDuration(arg)) {
                this.duration = Integer.valueOf(arg.split(":")[1]);
                dB.echoDebug(dB.Messages.DEBUG_SET_DURATION, arg);
                continue;
            }
            if (aH.matchesValueArg("STATE", arg, aH.ArgumentType.Custom)) {
                if (aH.getStringFrom(arg).equalsIgnoreCase("ON") || aH.getStringFrom(arg).equalsIgnoreCase("OPEN")) {
                    this.switchState = SwitchState.ON;
                    dB.echoDebug("...set STATE: 'ON'.");
                    continue;
                }
                if (aH.getStringFrom(arg).equalsIgnoreCase("OFF") || aH.getStringFrom(arg).equalsIgnoreCase("CLOSE")) {
                    this.switchState = SwitchState.OFF;
                    dB.echoDebug("...set STATE: 'OFF'.");
                    continue;
                }
                if (aH.getStringFrom(arg).equalsIgnoreCase("TOGGLE")) {
                    this.switchState = SwitchState.TOGGLE;
                    dB.echoDebug("...set STATE: 'TOGGLE'.");
                    continue;
                }
                dB.echoError("Unknown STATE! Valid: ON, OFF, TOGGLE");
                continue;
            }
            if (aH.matchesLocation(arg)) {
                this.interactLocation = aH.getLocationFrom(arg);
                if (this.interactLocation == null) continue;
                dB.echoError("...switch LOCATION now: '%s'", arg);
                continue;
            }
            throw new InvalidArgumentsException(dB.Messages.ERROR_UNKNOWN_ARGUMENT, arg);
        }
        if (this.interactLocation == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_LOCATION);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        this.switchBlock(this.interactLocation, this.switchState);
        if (this.duration > 0) {
            if (this.taskMap.containsKey(this.interactLocation)) {
                try {
                    this.denizen.getServer().getScheduler().cancelTask(this.taskMap.get(this.interactLocation).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dB.echoDebug(dB.Messages.DEBUG_RUNNING_DELAYED_TASK, "SWITCH");
            this.taskMap.put(this.interactLocation, this.denizen.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.denizen, (Runnable)new Runnable2<Location, SwitchState>(this.interactLocation, this.switchState){

                @Override
                public void run(Location iLocation, SwitchState sState) {
                    if (sState == SwitchState.OFF && (iLocation.getBlock().getData() & 8) <= 0) {
                        SwitchCommand.this.switchBlock(iLocation, SwitchState.ON);
                    } else if (sState == SwitchState.ON && (iLocation.getBlock().getData() & 8) > 0) {
                        SwitchCommand.this.switchBlock(iLocation, SwitchState.OFF);
                    } else if (sState == SwitchState.TOGGLE) {
                        SwitchCommand.this.switchBlock(iLocation, SwitchState.TOGGLE);
                    }
                }
            }, (long)(this.duration * 20)));
        }
    }

    public void switchBlock(Location interactLocation, SwitchState switchState) {
        org.bukkit.World world = interactLocation.getWorld();
        boolean currentState = (interactLocation.getBlock().getData() & 8) > 0;
        switch (interactLocation.getBlock().getType()) {
            case LEVER: {
                switch (switchState) {
                    case TOGGLE: {
                        Block.LEVER.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case ON: {
                        if (currentState) break;
                        Block.LEVER.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case OFF: {
                        if (!currentState) break;
                        Block.LEVER.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
                dB.echoDebug("SWITCHED! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
                break;
            }
            case STONE_BUTTON: {
                switch (switchState) {
                    case TOGGLE: {
                        Block.STONE_BUTTON.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case ON: {
                        if (currentState) break;
                        Block.STONE_BUTTON.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case OFF: {
                        if (!currentState) break;
                        Block.STONE_BUTTON.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
                dB.echoDebug("SWITCHED! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
                break;
            }
            case STONE_PLATE: {
                switch (switchState) {
                    case TOGGLE: {
                        Block.STONE_PLATE.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case ON: {
                        if (currentState) break;
                        Block.STONE_PLATE.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case OFF: {
                        if (!currentState) break;
                        Block.STONE_PLATE.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
                dB.echoDebug("SWITCHED! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
                break;
            }
            case WOOD_PLATE: {
                switch (switchState) {
                    case TOGGLE: {
                        Block.WOOD_PLATE.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case ON: {
                        if (currentState) break;
                        Block.WOOD_PLATE.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case OFF: {
                        if (!currentState) break;
                        Block.WOOD_PLATE.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
                dB.echoDebug("SWITCHED! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
                break;
            }
            case WOODEN_DOOR: {
                switch (switchState) {
                    case TOGGLE: {
                        Block.WOODEN_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case ON: {
                        if (currentState) break;
                        Block.WOODEN_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case OFF: {
                        if (!currentState) break;
                        Block.WOODEN_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
                dB.echoDebug("SWITCHED! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
                break;
            }
            case IRON_DOOR_BLOCK: {
                switch (switchState) {
                    case TOGGLE: {
                        Block.IRON_DOOR_BLOCK.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case ON: {
                        if (currentState) break;
                        Block.WOODEN_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case OFF: {
                        if (!currentState) break;
                        Block.WOODEN_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
                dB.echoDebug("SWITCHED! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
                break;
            }
            case TRAP_DOOR: {
                switch (switchState) {
                    case TOGGLE: {
                        Block.TRAP_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case ON: {
                        if (currentState) break;
                        Block.TRAP_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case OFF: {
                        if (!currentState) break;
                        Block.TRAP_DOOR.interact((World)((CraftWorld)world).getHandle(), interactLocation.getBlockX(), interactLocation.getBlockY(), interactLocation.getBlockZ(), null, 0, 0.0f, 0.0f, 0.0f);
                    }
                }
                dB.echoDebug("SWITCHED! Current state now: " + ((interactLocation.getBlock().getData() & 8) > 0 ? "ON" : "OFF"));
                break;
            }
            default: {
                dB.echoError("UNSWITCHABLE! Not a valid type of block!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SwitchState {
        ON,
        OFF,
        TOGGLE;

    }
}

