/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.exceptions.CommandExecutionException;
import net.aufdemrand.denizen.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizen.scripts.ScriptEntry;
import net.aufdemrand.denizen.scripts.commands.AbstractCommand;
import net.aufdemrand.denizen.utilities.arguments.aH;
import net.aufdemrand.denizen.utilities.debugging.dB;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ExecuteCommand
extends AbstractCommand {
    String command = null;
    ExecuteType executeType = null;
    LivingEntity target = null;

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (String arg : scriptEntry.getArguments()) {
            if (aH.matchesArg("ASPLAYER, AS_PLAYER", arg)) {
                this.executeType = ExecuteType.AS_PLAYER;
                this.target = scriptEntry.getPlayer();
                dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, arg);
                continue;
            }
            if (aH.matchesArg("ASOPPLAYER, ASOP, AS_OP, AS_OP_PLAYER", arg)) {
                this.executeType = ExecuteType.AS_OP;
                this.target = scriptEntry.getPlayer();
                dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, arg);
                continue;
            }
            if (aH.matchesArg("ASNPC, AS_NPC", arg)) {
                this.executeType = ExecuteType.AS_NPC;
                this.target = scriptEntry.getNPC().getEntity();
                dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, arg);
                continue;
            }
            if (aH.matchesArg("ASSERVER, AS_SERVER", arg)) {
                this.executeType = ExecuteType.AS_SERVER;
                dB.echoDebug(dB.Messages.DEBUG_SET_TYPE, arg);
                continue;
            }
            this.command = arg;
            dB.echoDebug(dB.Messages.DEBUG_SET_COMMAND, arg);
        }
        if (this.executeType == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "EXECUTE_TYPE");
        }
        if (this.command == null) {
            throw new InvalidArgumentsException(dB.Messages.ERROR_MISSING_OTHER, "COMMAND_TEXT");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        switch (this.executeType) {
            case AS_PLAYER: {
                ((Player)this.target).performCommand(this.command);
                return;
            }
            case AS_OP: {
                boolean isOp = false;
                if (((Player)this.target).isOp()) {
                    isOp = true;
                }
                if (!isOp) {
                    ((Player)this.target).setOp(true);
                }
                ((Player)this.target).performCommand(this.command);
                if (!isOp) {
                    ((Player)this.target).setOp(false);
                }
                return;
            }
            case AS_NPC: {
                if (this.target.getType() != EntityType.PLAYER) {
                    throw new CommandExecutionException("Cannot EXECUTE AS_NPC unless the NPC is Player-Type.");
                }
                ((Player)this.target).setOp(true);
                ((Player)this.target).performCommand(this.command);
                ((Player)this.target).setOp(false);
                return;
            }
            case AS_SERVER: {
                this.denizen.getServer().dispatchCommand((CommandSender)this.denizen.getServer().getConsoleSender(), this.command);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExecuteType {
        AS_SERVER,
        AS_NPC,
        AS_PLAYER,
        AS_OP;

    }
}

